/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public final class PropertiesAttributeDefinition
extends MapAttributeDefinition {
    private PropertiesAttributeDefinition(Builder builder) {
        super(builder);
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        this.setValueType(node);
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.setValueType(node);
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.setValueType(node);
    }

    void setValueType(ModelNode node) {
        node.get("value-type").set(ModelType.STRING);
        if (this.isAllowExpression()) {
            node.get("expressions-allowed").set(ModelNode.TRUE);
        }
    }

    public Map<String, String> unwrap(ExpressionResolver context, ModelNode model) throws OperationFailedException {
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            return PropertiesAttributeDefinition.unwrapModel(context, value);
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> unwrapModel(ExpressionResolver context, ModelNode model) throws OperationFailedException {
        if (!model.isDefined()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (Property p : model.asPropertyList()) {
            ModelNode value = context.resolveExpressions(p.getValue());
            props.put(p.getName(), value.isDefined() ? value.asString() : null);
        }
        return props;
    }

    public static class Builder
    extends MapAttributeDefinition.Builder<Builder, PropertiesAttributeDefinition> {
        private boolean xmlNameExplicitlySet = false;

        public Builder(String name, boolean optional) {
            super(name, optional);
        }

        public Builder(PropertiesAttributeDefinition basis) {
            super(basis);
        }

        public Builder(MapAttributeDefinition basis) {
            super(basis);
        }

        @Override
        public Builder setXmlName(String xmlName) {
            this.xmlNameExplicitlySet = true;
            return (Builder)super.setXmlName(xmlName);
        }

        @Override
        public PropertiesAttributeDefinition build() {
            String elementName;
            if (this.elementValidator == null) {
                this.elementValidator = new ModelTypeValidator(ModelType.STRING);
            }
            String xmlName = this.getXmlName();
            String string = elementName = this.getName().equals(xmlName) ? null : xmlName;
            if (this.getAttributeMarshaller() == null) {
                this.setAttributeMarshaller(new AttributeMarshallers.PropertiesAttributeMarshaller(null, this.xmlNameExplicitlySet ? xmlName : elementName, true));
            }
            if (this.getParser() == null) {
                this.setAttributeParser(new AttributeParsers.PropertiesParser(null, this.xmlNameExplicitlySet ? xmlName : elementName, true));
            }
            return new PropertiesAttributeDefinition(this);
        }
    }
}

