/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.annotated.slim;

import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.io.IOException;
import java.lang.reflect.Field;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class AnnotatedFieldMarshaller<X, T extends SlimAnnotatedType<X>, F extends AnnotatedField<X>>
implements ProtoStreamMarshaller<F> {
    private static final int TYPE_INDEX = 1;
    private static final int DECLARING_TYPE_INDEX = 2;
    private static final int FIELD_NAME_INDEX = 3;
    private final Class<F> targetClass;
    private final Class<T> typeClass;

    public AnnotatedFieldMarshaller(Class<F> targetClass, Class<T> typeClass) {
        this.targetClass = targetClass;
        this.typeClass = typeClass;
    }

    public Class<F> getJavaClass() {
        return this.targetClass;
    }

    public F readFrom(ProtoStreamReader reader) throws IOException {
        SlimAnnotatedType type = null;
        Class declaringType = null;
        String fieldName = null;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    type = (SlimAnnotatedType)reader.readObject(this.typeClass);
                    continue block5;
                }
                case 2: {
                    declaringType = (Class)reader.readObject(Class.class);
                    continue block5;
                }
                case 3: {
                    fieldName = reader.readString();
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        Class fieldClass = declaringType != null ? declaringType : type.getJavaClass();
        for (AnnotatedField annotatedField : type.getFields()) {
            Field field = annotatedField.getJavaMember();
            if (field.getDeclaringClass() != fieldClass || !field.getName().equals(fieldName)) continue;
            return (F)((AnnotatedField)this.targetClass.cast(annotatedField));
        }
        throw new IllegalStateException();
    }

    public void writeTo(ProtoStreamWriter writer, F field) throws IOException {
        Field member;
        AnnotatedType type = field.getDeclaringType();
        if (type != null) {
            writer.writeObject(1, (Object)type);
        }
        if ((member = field.getJavaMember()) != null) {
            Class<?> declaringClass = member.getDeclaringClass();
            if (declaringClass != type.getJavaClass()) {
                writer.writeObject(2, declaringClass);
            }
            writer.writeString(3, member.getName());
        }
    }
}

