/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import java.util.Map;
import org.jboss.as.ee.utils.ClassLoadingUtils;
import org.jboss.as.ejb3.deployment.ApplicationExceptionDescriptions;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.metadata.ejb.spec.ApplicationExceptionMetaData;
import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.modules.Module;

public class ApplicationExceptionMergingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ApplicationExceptionsMetaData ddAppExceptions;
        AssemblyDescriptorMetaData assemblyDescriptor;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!EjbDeploymentMarker.isEjbDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        List accessibleSubDeployments = (List)deploymentUnit.getAttachment(Attachments.ACCESSIBLE_SUB_DEPLOYMENTS);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ApplicationExceptions applicationExceptions = new ApplicationExceptions();
        for (DeploymentUnit unit : accessibleSubDeployments) {
            ApplicationExceptionDescriptions exceptionDescriptions = (ApplicationExceptionDescriptions)unit.getAttachment(EjbDeploymentAttachmentKeys.APPLICATION_EXCEPTION_DESCRIPTIONS);
            if (exceptionDescriptions == null) continue;
            for (Map.Entry<String, ApplicationExceptionDetails> exception : exceptionDescriptions.getApplicationExceptions().entrySet()) {
                try {
                    Class index = ClassLoadingUtils.loadClass((String)exception.getKey(), (Module)module);
                    applicationExceptions.addApplicationException(index, exception.getValue());
                }
                catch (ClassNotFoundException e) {
                    EjbLogger.ROOT_LOGGER.debug("Could not load application exception class", e);
                }
            }
        }
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData != null && (assemblyDescriptor = ejbJarMetaData.getAssemblyDescriptor()) != null && (ddAppExceptions = assemblyDescriptor.getApplicationExceptions()) != null && !ddAppExceptions.isEmpty()) {
            for (ApplicationExceptionMetaData applicationException : ddAppExceptions) {
                String exceptionClassName = applicationException.getExceptionClass();
                try {
                    Class index = ClassLoadingUtils.loadClass((String)exceptionClassName, (Module)module);
                    boolean rollback = applicationException.isRollback();
                    boolean inherited = applicationException.isInherited() == null ? true : applicationException.isInherited();
                    applicationExceptions.addApplicationException(index, new ApplicationExceptionDetails(exceptionClassName, inherited, rollback));
                }
                catch (ClassNotFoundException e) {
                    throw EjbLogger.ROOT_LOGGER.failToLoadAppExceptionClassInEjbJarXml(exceptionClassName, e);
                }
            }
        }
        deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.APPLICATION_EXCEPTION_DETAILS, (Object)applicationExceptions);
    }
}

