/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.ArrayList;
import org.jboss.as.ejb3.interceptor.server.ClientInterceptorCache;
import org.jboss.as.ejb3.subsystem.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.ejb.client.EJBClientInterceptor;

public class ClientInterceptorsBindingsProcessor
implements DeploymentUnitProcessor {
    private final ClientInterceptorCache clientInterceptorCache;

    public ClientInterceptorsBindingsProcessor(ClientInterceptorCache clientInterceptorCache) {
        this.clientInterceptorCache = clientInterceptorCache;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        try {
            DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
            ArrayList<EJBClientInterceptor> clientInterceptors = (ArrayList<EJBClientInterceptor>)deploymentUnit.getAttachment(Attachments.STATIC_EJB_CLIENT_INTERCEPTORS);
            if (clientInterceptors == null) {
                clientInterceptors = new ArrayList<EJBClientInterceptor>();
            }
            for (Class<? extends EJBClientInterceptor> interceptorClass : this.clientInterceptorCache.getClientInterceptors()) {
                clientInterceptors.add(interceptorClass.newInstance());
            }
            deploymentUnit.putAttachment(Attachments.STATIC_EJB_CLIENT_INTERCEPTORS, clientInterceptors);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }
}

