/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.provider;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.infinispan.retry.RetryingInvoker;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.distribution.ConsistentHashLocality;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.server.infinispan.ClusteringServerLogger;
import org.wildfly.clustering.server.infinispan.group.InfinispanAddressResolver;
import org.wildfly.clustering.server.infinispan.provider.AddressSetAddFunction;
import org.wildfly.clustering.server.infinispan.provider.AddressSetRemoveFunction;
import org.wildfly.clustering.server.infinispan.provider.AutoCloseableServiceProviderRegistry;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistryConfiguration;
import org.wildfly.clustering.server.infinispan.provider.SimpleServiceProviderRegistration;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener(observation=Listener.Observation.POST)
public class CacheServiceProviderRegistry<T>
implements AutoCloseableServiceProviderRegistry<T> {
    private final Batcher<? extends Batch> batcher;
    private final ConcurrentMap<T, Map.Entry<ServiceProviderRegistration.Listener, ExecutorService>> listeners = new ConcurrentHashMap<T, Map.Entry<ServiceProviderRegistration.Listener, ExecutorService>>();
    private final Cache<T, Set<Address>> cache;
    private final org.wildfly.clustering.server.group.Group<Address> group;
    private final Invoker invoker;
    private final Executor executor;

    public CacheServiceProviderRegistry(CacheServiceProviderRegistryConfiguration<T> config) {
        this.group = config.getGroup();
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.executor = config.getBlockingManager().asExecutor(this.getClass().getName());
        this.cache.addListener((Object)this);
        this.invoker = new RetryingInvoker(this.cache);
    }

    @Override
    public void close() {
        this.cache.removeListener((Object)this);
        for (Map.Entry entry : this.listeners.values()) {
            ExecutorService executor = (ExecutorService)entry.getValue();
            if (executor == null) continue;
            this.shutdown(executor);
        }
        this.listeners.clear();
    }

    private void shutdown(ExecutorService executor) {
        WildFlySecurityManager.doUnchecked((Object)executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_ACTION);
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T> register(T service) {
        return this.register(service, null);
    }

    public ServiceProviderRegistration<T> register(T service, ServiceProviderRegistration.Listener listener) {
        AbstractMap.SimpleEntry<ServiceProviderRegistration.Listener, Object> newEntry = new AbstractMap.SimpleEntry<ServiceProviderRegistration.Listener, Object>(listener, null);
        Map.Entry entry = this.listeners.computeIfAbsent(service, key -> {
            if (listener != null) {
                newEntry.setValue(new DefaultExecutorService(listener.getClass(), (Function)ExecutorServiceFactory.SINGLE_THREAD));
            }
            return newEntry;
        });
        if (entry != newEntry) {
            throw new IllegalArgumentException(service.toString());
        }
        this.invoker.invoke((ExceptionRunnable)new RegisterLocalServiceTask(service));
        return new SimpleServiceProviderRegistration<T>(service, this, () -> {
            Address localAddress = InfinispanAddressResolver.INSTANCE.apply(this.group.getLocalMember());
            try (Batch batch = this.batcher.createBatch();){
                this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS, Flag.IGNORE_RETURN_VALUES}).compute(service, (BiFunction)((Object)new AddressSetRemoveFunction(localAddress)));
            }
            finally {
                ExecutorService executor;
                Map.Entry oldEntry = (Map.Entry)this.listeners.remove(service);
                if (oldEntry != null && (executor = (ExecutorService)oldEntry.getValue()) != null) {
                    this.shutdown(executor);
                }
            }
        });
    }

    void registerLocal(T service) {
        try (Batch batch = this.batcher.createBatch();){
            this.register(InfinispanAddressResolver.INSTANCE.apply(this.group.getLocalMember()), service);
        }
    }

    void register(Address address, T service) {
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS, Flag.IGNORE_RETURN_VALUES}).compute(service, (BiFunction)((Object)new AddressSetAddFunction(address)));
    }

    public Set<Node> getProviders(T service) {
        Set addresses = (Set)this.cache.get(service);
        if (addresses == null) {
            return Collections.emptySet();
        }
        TreeSet<Node> members = new TreeSet<Node>();
        for (Address address : addresses) {
            Node member = this.group.createNode((Object)address);
            if (member == null) continue;
            members.add(member);
        }
        return Collections.unmodifiableSet(members);
    }

    public Set<T> getServices() {
        return this.cache.keySet();
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<T, Set<Address>> event) {
        ConsistentHash previousHash = event.getWriteConsistentHashAtStart();
        List previousMembers = previousHash.getMembers();
        ConsistentHash hash = event.getWriteConsistentHashAtEnd();
        List members = hash.getMembers();
        if (!members.equals(previousMembers)) {
            Set localServices;
            AdvancedCache cache = event.getCache().getAdvancedCache().withFlags(Flag.FORCE_SYNCHRONOUS);
            Address localAddress = cache.getCacheManager().getAddress();
            HashSet leftMembers = new HashSet(previousMembers);
            leftMembers.removeAll(members);
            if (!leftMembers.isEmpty()) {
                ConsistentHashLocality locality = new ConsistentHashLocality((Cache)cache, hash);
                Iterator addresses = leftMembers.iterator();
                while (addresses.hasNext()) {
                    if (locality.isLocal(addresses.next())) continue;
                    addresses.remove();
                }
            }
            Set<Object> set = localServices = !previousMembers.contains(localAddress) ? this.listeners.keySet() : Collections.emptySet();
            if (!leftMembers.isEmpty() || !localServices.isEmpty()) {
                Batcher<? extends Batch> batcher = this.batcher;
                Invoker invoker = this.invoker;
                this.executor.execute(() -> this.lambda$topologyChanged$2(leftMembers, batcher, (Cache)cache, localServices, invoker));
            }
        }
        return CompletableFuture.completedStage(null);
    }

    @CacheEntryCreated
    @CacheEntryModified
    public CompletionStage<Void> modified(CacheEntryEvent<T, Set<Address>> event) {
        ServiceProviderRegistration.Listener listener;
        Map.Entry entry = (Map.Entry)this.listeners.get(event.getKey());
        if (entry != null && (listener = (ServiceProviderRegistration.Listener)entry.getKey()) != null) {
            this.executor.execute(() -> {
                try {
                    ((ExecutorService)entry.getValue()).submit(() -> {
                        TreeSet<Node> members = new TreeSet<Node>();
                        for (Address address : (Set)event.getValue()) {
                            Node member = this.group.createNode((Object)address);
                            if (member == null) continue;
                            members.add(member);
                        }
                        try {
                            listener.providersChanged(members);
                        }
                        catch (Throwable e) {
                            ClusteringServerLogger.ROOT_LOGGER.serviceProviderRegistrationListenerFailed(e, this.cache.getCacheManager().getCacheManagerConfiguration().cacheManagerName(), this.cache.getName(), members);
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            });
        }
        return CompletableFuture.completedStage(null);
    }

    private /* synthetic */ void lambda$topologyChanged$2(Set leftMembers, Batcher batcher, Cache cache, Set localServices, Invoker invoker) {
        if (!leftMembers.isEmpty()) {
            try (Batch batch = batcher.createBatch();
                 CloseableIterator keys = cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).keySet().iterator();){
                while (keys.hasNext()) {
                    cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS, Flag.IGNORE_RETURN_VALUES}).compute(keys.next(), (BiFunction)((Object)new AddressSetRemoveFunction(leftMembers)));
                }
            }
        }
        if (!localServices.isEmpty()) {
            for (Object localService : localServices) {
                invoker.invoke((ExceptionRunnable)new RegisterLocalServiceTask(localService));
            }
        }
    }

    private class RegisterLocalServiceTask
    implements ExceptionRunnable<CacheException> {
        private final T localService;

        RegisterLocalServiceTask(T localService) {
            this.localService = localService;
        }

        public void run() {
            CacheServiceProviderRegistry.this.registerLocal(this.localService);
        }
    }
}

