/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.hibernate.cache.commons.TimeSource;
import org.infinispan.hibernate.cache.commons.access.BaseInvalidationInterceptor;
import org.infinispan.hibernate.cache.commons.access.LockingInterceptor;
import org.infinispan.hibernate.cache.commons.access.NonTxInvalidationInterceptor;
import org.infinispan.hibernate.cache.commons.access.NonTxPutFromLoadInterceptor;
import org.infinispan.hibernate.cache.commons.access.TxInvalidationInterceptor;
import org.infinispan.hibernate.cache.commons.access.TxPutFromLoadInterceptor;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.interceptors.impl.InvalidationInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.ByteString;

public class PutFromLoadValidator {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(PutFromLoadValidator.class);
    private final long expirationPeriod;
    private final Cache<Object, PendingPutMap> pendingPuts;
    private final AdvancedCache cache;
    private final TimeSource timeSource;
    private volatile long regionInvalidationTimestamp = Long.MIN_VALUE;
    private int regionInvalidations = 0;

    public PutFromLoadValidator(AdvancedCache cache, TimeSource timeSource, Configuration pendingPutsConfiguration) {
        this(cache, timeSource, cache.getCacheManager(), pendingPutsConfiguration);
    }

    public PutFromLoadValidator(AdvancedCache cache, TimeSource timeSource, EmbeddedCacheManager cacheManager, Configuration pendingPutsConfiguration) {
        this.timeSource = timeSource;
        String pendingPutsName = this.getPendingPutsName(cache);
        if (cacheManager.getCacheConfiguration(pendingPutsName) != null) {
            log.pendingPutsCacheAlreadyDefined(pendingPutsName);
        } else {
            ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
            configurationBuilder.read(pendingPutsConfiguration);
            configurationBuilder.template(false);
            cacheManager.defineConfiguration(pendingPutsName, configurationBuilder.build());
        }
        if (pendingPutsConfiguration.expiration() == null || pendingPutsConfiguration.expiration().maxIdle() <= 0L) {
            throw log.pendingPutsMustHaveMaxIdle();
        }
        this.expirationPeriod = pendingPutsConfiguration.expiration().maxIdle();
        this.cache = cache;
        this.pendingPuts = cacheManager.getCache(pendingPutsName);
        this.pendingPuts.start();
        CacheMode cacheMode = cache.getCacheConfiguration().clustering().cacheMode();
        if (cacheMode.isClustered()) {
            if (!cacheMode.isInvalidation()) {
                throw new IllegalArgumentException("PutFromLoadValidator in clustered caches requires invalidation mode.");
            }
            PutFromLoadValidator.addToCache(cache, this);
        }
    }

    private String getPendingPutsName(AdvancedCache cache) {
        return cache.getName() + "-pending-puts";
    }

    public static void addToCache(AdvancedCache cache, PutFromLoadValidator validator) {
        AsyncInterceptorChain chain = cache.getAsyncInterceptorChain();
        List interceptors = chain.getInterceptors();
        log.debugf("Interceptor chain was: ", interceptors);
        int position = 0;
        int entryWrappingPosition = 0;
        for (AsyncInterceptor ci : interceptors) {
            if (ci instanceof EntryWrappingInterceptor) {
                entryWrappingPosition = position;
            }
            ++position;
        }
        boolean transactional = cache.getCacheConfiguration().transaction().transactionMode().isTransactional();
        BasicComponentRegistry componentRegistry = (BasicComponentRegistry)cache.getComponentRegistry().getComponent(BasicComponentRegistry.class);
        if (transactional) {
            TxInvalidationInterceptor txInvalidationInterceptor = new TxInvalidationInterceptor();
            componentRegistry.replaceComponent(TxInvalidationInterceptor.class.getName(), (Object)txInvalidationInterceptor, true);
            componentRegistry.getComponent(TxInvalidationInterceptor.class).running();
            chain.replaceInterceptor((AsyncInterceptor)txInvalidationInterceptor, InvalidationInterceptor.class);
            TxPutFromLoadInterceptor txPutFromLoadInterceptor = new TxPutFromLoadInterceptor(validator, ByteString.fromString((String)cache.getName()));
            componentRegistry.replaceComponent(TxPutFromLoadInterceptor.class.getName(), (Object)txPutFromLoadInterceptor, true);
            componentRegistry.getComponent(TxPutFromLoadInterceptor.class).running();
            chain.addInterceptor((AsyncInterceptor)txPutFromLoadInterceptor, entryWrappingPosition);
        } else {
            NonTxPutFromLoadInterceptor nonTxPutFromLoadInterceptor = new NonTxPutFromLoadInterceptor(validator, ByteString.fromString((String)cache.getName()));
            componentRegistry.replaceComponent(NonTxPutFromLoadInterceptor.class.getName(), (Object)nonTxPutFromLoadInterceptor, true);
            componentRegistry.getComponent(NonTxPutFromLoadInterceptor.class).running();
            chain.addInterceptor((AsyncInterceptor)nonTxPutFromLoadInterceptor, entryWrappingPosition);
            NonTxInvalidationInterceptor nonTxInvalidationInterceptor = new NonTxInvalidationInterceptor();
            componentRegistry.replaceComponent(NonTxInvalidationInterceptor.class.getName(), (Object)nonTxInvalidationInterceptor, true);
            componentRegistry.getComponent(NonTxInvalidationInterceptor.class).running();
            chain.replaceInterceptor((AsyncInterceptor)nonTxInvalidationInterceptor, InvalidationInterceptor.class);
            LockingInterceptor lockingInterceptor = new LockingInterceptor();
            componentRegistry.replaceComponent(LockingInterceptor.class.getName(), (Object)lockingInterceptor, true);
            componentRegistry.getComponent(LockingInterceptor.class).running();
            chain.replaceInterceptor((AsyncInterceptor)lockingInterceptor, NonTransactionalLockingInterceptor.class);
        }
        log.debugf("New interceptor chain is: ", cache.getAsyncInterceptorChain());
        if (componentRegistry.getComponent(PutFromLoadValidator.class) == null) {
            componentRegistry.registerComponent(PutFromLoadValidator.class, (Object)validator, false);
        } else {
            componentRegistry.replaceComponent(PutFromLoadValidator.class.getName(), (Object)validator, false);
        }
    }

    public static PutFromLoadValidator removeFromCache(AdvancedCache cache) {
        AsyncInterceptorChain chain = cache.getAsyncInterceptorChain();
        BasicComponentRegistry cr = (BasicComponentRegistry)cache.getComponentRegistry().getComponent(BasicComponentRegistry.class);
        chain.removeInterceptor(TxPutFromLoadInterceptor.class);
        chain.removeInterceptor(NonTxPutFromLoadInterceptor.class);
        chain.getInterceptors().stream().filter(BaseInvalidationInterceptor.class::isInstance).findFirst().map(AsyncInterceptor::getClass).ifPresent(invalidationClass -> {
            InvalidationInterceptor invalidationInterceptor = new InvalidationInterceptor();
            cr.replaceComponent(InvalidationInterceptor.class.getName(), (Object)invalidationInterceptor, true);
            cr.getComponent(InvalidationInterceptor.class).running();
            chain.replaceInterceptor((AsyncInterceptor)invalidationInterceptor, invalidationClass);
        });
        chain.getInterceptors().stream().filter(LockingInterceptor.class::isInstance).findFirst().map(AsyncInterceptor::getClass).ifPresent(invalidationClass -> {
            NonTransactionalLockingInterceptor lockingInterceptor = new NonTransactionalLockingInterceptor();
            cr.replaceComponent(NonTransactionalLockingInterceptor.class.getName(), (Object)lockingInterceptor, true);
            cr.getComponent(NonTransactionalLockingInterceptor.class).running();
            chain.replaceInterceptor((AsyncInterceptor)lockingInterceptor, LockingInterceptor.class);
        });
        return (PutFromLoadValidator)cr.getComponent(PutFromLoadValidator.class).running();
    }

    public void destroy() {
        this.pendingPuts.stop();
        this.pendingPuts.getCacheManager().undefineConfiguration(this.pendingPuts.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lock acquirePutFromLoadLock(Object session, Object key, long txTimestamp) {
        if (log.isTraceEnabled()) {
            log.tracef("acquirePutFromLoadLock(%s#%s, %d)", this.cache.getName(), key, txTimestamp);
        }
        boolean locked = false;
        PendingPutMap pending = (PendingPutMap)this.pendingPuts.get(key);
        try {
            while (true) {
                PendingPut pendingPut;
                PendingPutMap existing;
                if (pending != null) {
                    locked = pending.acquireLock(100L, TimeUnit.MILLISECONDS);
                    if (locked) {
                        PendingPutMap pendingPutMap;
                        boolean valid;
                        block24: {
                            block22: {
                                block23: {
                                    valid = false;
                                    try {
                                        if (!pending.isRemoved()) break block22;
                                        pending.releaseLock();
                                        locked = false;
                                        pending = null;
                                        if (log.isTraceEnabled()) {
                                            log.tracef("Record removed when waiting for the lock.", new Object[0]);
                                        }
                                        if (valid || pending == null) break block23;
                                        pending.releaseLock();
                                        locked = false;
                                    }
                                    catch (Throwable throwable) {
                                        if (!valid && pending != null) {
                                            pending.releaseLock();
                                            locked = false;
                                        }
                                        if (log.isTraceEnabled()) {
                                            log.tracef("acquirePutFromLoadLock(%s#%s, %d) ended with %s, valid: %s", new Object[]{this.cache.getName(), key, txTimestamp, pending, valid});
                                        }
                                        throw throwable;
                                    }
                                }
                                if (!log.isTraceEnabled()) continue;
                                log.tracef("acquirePutFromLoadLock(%s#%s, %d) ended with %s, valid: %s", new Object[]{this.cache.getName(), key, txTimestamp, pending, valid});
                                continue;
                            }
                            PendingPut toCancel = pending.remove(session);
                            if (toCancel != null) {
                                valid = !toCancel.completed;
                                toCancel.completed = true;
                            } else {
                                valid = pending.hasInvalidator() ? false : (pending.lastInvalidationEnd != Long.MIN_VALUE ? txTimestamp > pending.lastInvalidationEnd : txTimestamp > this.regionInvalidationTimestamp);
                            }
                            PendingPutMap pendingPutMap2 = pendingPutMap = valid ? pending : null;
                            if (valid || pending == null) break block24;
                            pending.releaseLock();
                            locked = false;
                        }
                        if (log.isTraceEnabled()) {
                            log.tracef("acquirePutFromLoadLock(%s#%s, %d) ended with %s, valid: %s", new Object[]{this.cache.getName(), key, txTimestamp, pending, valid});
                        }
                        return pendingPutMap;
                    }
                    if (log.isTraceEnabled()) {
                        log.tracef("acquirePutFromLoadLock(%s#%s, %d) failed to lock", this.cache.getName(), key, txTimestamp);
                    }
                    return null;
                }
                long regionInvalidationTimestamp = this.regionInvalidationTimestamp;
                if (txTimestamp <= regionInvalidationTimestamp) {
                    if (log.isTraceEnabled()) {
                        log.tracef("acquirePutFromLoadLock(%s#%s, %d) failed due to region invalidated at %d", new Object[]{this.cache.getName(), key, txTimestamp, regionInvalidationTimestamp});
                    }
                    return null;
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Region invalidated at %d, this transaction started at %d", regionInvalidationTimestamp, txTimestamp);
                }
                if ((existing = (PendingPutMap)this.pendingPuts.putIfAbsent(key, (Object)(pending = new PendingPutMap(pendingPut = new PendingPut(session))))) == null) continue;
                pending = existing;
            }
        }
        catch (Throwable t) {
            if (locked) {
                pending.releaseLock();
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void releasePutFromLoadLock(Object key, Lock lock) {
        PendingPutMap pending;
        if (log.isTraceEnabled()) {
            log.tracef("releasePutFromLoadLock(%s#%s, %s)", this.cache.getName(), key, lock);
        }
        if ((pending = (PendingPutMap)lock) != null) {
            if (pending.canRemove()) {
                pending.setRemoved();
                this.pendingPuts.remove(key, (Object)pending);
            }
            pending.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginInvalidatingRegion() {
        if (log.isTraceEnabled()) {
            log.trace("Started invalidating region " + this.cache.getName());
        }
        boolean ok = true;
        long now = this.timeSource.nextTimestamp();
        PutFromLoadValidator putFromLoadValidator = this;
        synchronized (putFromLoadValidator) {
            this.regionInvalidationTimestamp = Long.MAX_VALUE;
            ++this.regionInvalidations;
        }
        try {
            CloseableIterator it = this.pendingPuts.values().iterator();
            while (it.hasNext()) {
                PendingPutMap entry = (PendingPutMap)it.next();
                it.remove();
                if (entry.acquireLock(60L, TimeUnit.SECONDS)) {
                    try {
                        entry.invalidate(now);
                        continue;
                    }
                    finally {
                        entry.releaseLock();
                        continue;
                    }
                }
                ok = false;
            }
        }
        catch (Exception e) {
            ok = false;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endInvalidatingRegion() {
        PutFromLoadValidator putFromLoadValidator = this;
        synchronized (putFromLoadValidator) {
            if (--this.regionInvalidations == 0) {
                this.regionInvalidationTimestamp = this.timeSource.nextTimestamp();
                if (log.isTraceEnabled()) {
                    log.tracef("Finished invalidating region %s at %d", this.cache.getName(), this.regionInvalidationTimestamp);
                }
            } else if (log.isTraceEnabled()) {
                log.tracef("Finished invalidating region %s, but there are %d ongoing invalidations", this.cache.getName(), this.regionInvalidations);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPendingPut(Object session, Object key, long txTimestamp) {
        block13: {
            PendingPutMap existing;
            long invalidationTimestamp = this.regionInvalidationTimestamp;
            if (txTimestamp <= invalidationTimestamp) {
                if (log.isTraceEnabled()) {
                    log.tracef("registerPendingPut(%s#%s, %d) skipped due to region invalidation (%d)", new Object[]{this.cache.getName(), key, txTimestamp, invalidationTimestamp});
                }
                return;
            }
            PendingPut pendingPut = new PendingPut(session);
            PendingPutMap pendingForKey = new PendingPutMap(pendingPut);
            while ((existing = (PendingPutMap)this.pendingPuts.putIfAbsent(key, (Object)pendingForKey)) != null) {
                if (existing.acquireLock(10L, TimeUnit.SECONDS)) {
                    block12: {
                        try {
                            if (existing.isRemoved()) {
                                if (!log.isTraceEnabled()) continue;
                                log.tracef("Record removed when waiting for the lock.", new Object[0]);
                                continue;
                            }
                            if (existing.hasInvalidator()) break block12;
                            existing.put(pendingPut);
                        }
                        finally {
                            existing.releaseLock();
                            continue;
                        }
                    }
                    if (log.isTraceEnabled()) {
                        log.tracef("registerPendingPut(%s#%s, %d) ended with %s", new Object[]{this.cache.getName(), key, txTimestamp, existing});
                    }
                    break block13;
                }
                if (log.isTraceEnabled()) {
                    log.tracef("registerPendingPut(%s#%s, %d) failed to acquire lock", this.cache.getName(), key, txTimestamp);
                }
                break block13;
            }
            if (log.isTraceEnabled()) {
                log.tracef("registerPendingPut(%s#%s, %d) registered using putIfAbsent: %s", new Object[]{this.cache.getName(), key, txTimestamp, pendingForKey});
            }
        }
    }

    public boolean beginInvalidatingKey(Object lockOwner, Object key) {
        return this.beginInvalidatingWithPFER(lockOwner, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginInvalidatingWithPFER(Object lockOwner, Object key, Object valueForPFER) {
        block9: {
            PendingPutMap pending;
            while (true) {
                PendingPutMap prev;
                if ((prev = (PendingPutMap)this.pendingPuts.putIfAbsent(key, (Object)(pending = new PendingPutMap(null)))) != null) {
                    pending = prev;
                }
                if (!pending.acquireLock(60L, TimeUnit.SECONDS)) break block9;
                try {
                    if (pending.isRemoved()) {
                        if (!log.isTraceEnabled()) continue;
                        log.tracef("Record removed when waiting for the lock.", new Object[0]);
                        continue;
                    }
                    long now = this.timeSource.nextTimestamp();
                    if (log.isTraceEnabled()) {
                        log.tracef("beginInvalidatingKey(%s#%s, %s) remove invalidator from %s", new Object[]{this.cache.getName(), key, PutFromLoadValidator.lockOwnerToString(lockOwner), pending});
                    }
                    pending.invalidate(now);
                    pending.addInvalidator(lockOwner, valueForPFER, now);
                }
                finally {
                    pending.releaseLock();
                    continue;
                }
                break;
            }
            if (log.isTraceEnabled()) {
                log.tracef("beginInvalidatingKey(%s#%s, %s) ends with %s", new Object[]{this.cache.getName(), key, PutFromLoadValidator.lockOwnerToString(lockOwner), pending});
            }
            return true;
        }
        log.tracef("beginInvalidatingKey(%s#%s, %s) failed to acquire lock", this.cache.getName(), key, PutFromLoadValidator.lockOwnerToString(lockOwner));
        return false;
    }

    public boolean endInvalidatingKey(Object lockOwner, Object key) {
        return this.endInvalidatingKey(lockOwner, key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endInvalidatingKey(Object lockOwner, Object key, boolean doPFER) {
        PendingPutMap pending = (PendingPutMap)this.pendingPuts.get(key);
        if (pending == null) {
            if (log.isTraceEnabled()) {
                log.tracef("endInvalidatingKey(%s#%s, %s) could not find pending puts", this.cache.getName(), key, PutFromLoadValidator.lockOwnerToString(lockOwner));
            }
            return true;
        }
        if (pending.acquireLock(60L, TimeUnit.SECONDS)) {
            boolean bl;
            try {
                long now = this.timeSource.nextTimestamp();
                pending.removeInvalidator(lockOwner, key, now, doPFER);
                bl = true;
                pending.releaseLock();
            }
            catch (Throwable throwable) {
                pending.releaseLock();
                if (log.isTraceEnabled()) {
                    log.tracef("endInvalidatingKey(%s#%s, %s) ends with %s", new Object[]{this.cache.getName(), key, PutFromLoadValidator.lockOwnerToString(lockOwner), pending});
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.tracef("endInvalidatingKey(%s#%s, %s) ends with %s", new Object[]{this.cache.getName(), key, PutFromLoadValidator.lockOwnerToString(lockOwner), pending});
            }
            return bl;
        }
        if (log.isTraceEnabled()) {
            log.tracef("endInvalidatingKey(%s#%s, %s) failed to acquire lock", this.cache.getName(), key, PutFromLoadValidator.lockOwnerToString(lockOwner));
        }
        return false;
    }

    private static String lockOwnerToString(Object lockOwner) {
        return lockOwner instanceof SessionImplementor ? "Session#" + lockOwner.hashCode() : lockOwner.toString();
    }

    public void removePendingPutsCache() {
        String pendingPutsName = this.getPendingPutsName(this.cache);
        EmbeddedCacheManager cm = this.cache.getCacheManager();
        cm.administration().removeCache(pendingPutsName);
    }

    private class PendingPutMap
    extends Lock {
        private static final int GC_THRESHOLD = 10;
        private PendingPut singlePendingPut;
        private Map<Object, PendingPut> fullMap;
        private final java.util.concurrent.locks.Lock lock = new ReentrantLock();
        private Invalidator singleInvalidator;
        private Map<Object, Invalidator> invalidators;
        private long lastInvalidationEnd = Long.MIN_VALUE;
        private boolean removed = false;

        PendingPutMap(PendingPut singleItem) {
            this.singlePendingPut = singleItem;
        }

        public String toString() {
            if (this.lock.tryLock()) {
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append("{ PendingPuts=");
                    if (this.singlePendingPut == null) {
                        if (this.fullMap == null) {
                            sb.append("[]");
                        } else {
                            sb.append(this.fullMap.values());
                        }
                    } else {
                        sb.append('[').append(this.singlePendingPut).append(']');
                    }
                    sb.append(", Invalidators=");
                    if (this.singleInvalidator == null) {
                        if (this.invalidators == null) {
                            sb.append("[]");
                        } else {
                            sb.append(this.invalidators.values());
                        }
                    } else {
                        sb.append('[').append(this.singleInvalidator).append(']');
                    }
                    sb.append(", LastInvalidationEnd=");
                    if (this.lastInvalidationEnd == Long.MIN_VALUE) {
                        sb.append("<none>");
                    } else {
                        sb.append(this.lastInvalidationEnd);
                    }
                    String string = sb.append(", Removed=").append(this.removed).append("}").toString();
                    return string;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return "PendingPutMap: <locked>";
        }

        public void put(PendingPut pendingPut) {
            if (this.singlePendingPut == null) {
                if (this.fullMap == null) {
                    this.singlePendingPut = pendingPut;
                } else {
                    this.fullMap.put(pendingPut.owner, pendingPut);
                    if (this.fullMap.size() >= 10) {
                        this.gc();
                    }
                }
            } else {
                this.fullMap = new HashMap<Object, PendingPut>(4);
                this.fullMap.put(this.singlePendingPut.owner, this.singlePendingPut);
                this.singlePendingPut = null;
                this.fullMap.put(pendingPut.owner, pendingPut);
            }
        }

        public PendingPut remove(Object ownerForPut) {
            PendingPut removed = null;
            if (this.fullMap == null) {
                if (this.singlePendingPut != null && this.singlePendingPut.owner.equals(ownerForPut)) {
                    removed = this.singlePendingPut;
                    this.singlePendingPut = null;
                }
            } else {
                removed = this.fullMap.remove(ownerForPut);
            }
            return removed;
        }

        public int size() {
            return this.fullMap == null ? (this.singlePendingPut == null ? 0 : 1) : this.fullMap.size();
        }

        public boolean acquireLock(long time, TimeUnit unit) {
            try {
                return this.lock.tryLock(time, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        public void releaseLock() {
            this.lock.unlock();
        }

        public void invalidate(long now) {
            if (this.singlePendingPut != null) {
                if (this.singlePendingPut.invalidate(now, PutFromLoadValidator.this.expirationPeriod)) {
                    this.singlePendingPut = null;
                }
            } else if (this.fullMap != null) {
                Iterator<PendingPut> it = this.fullMap.values().iterator();
                while (it.hasNext()) {
                    PendingPut pp = it.next();
                    if (!pp.invalidate(now, PutFromLoadValidator.this.expirationPeriod)) continue;
                    it.remove();
                }
            }
        }

        private void gc() {
            assert (this.fullMap != null);
            long now = PutFromLoadValidator.this.timeSource.nextTimestamp();
            log.tracef("Contains %d, doing GC at %d, expiration %d", this.size(), now, PutFromLoadValidator.this.expirationPeriod);
            Iterator<PendingPut> it = this.fullMap.values().iterator();
            while (it.hasNext()) {
                PendingPut pp = it.next();
                if (!pp.gc(now, PutFromLoadValidator.this.expirationPeriod)) continue;
                it.remove();
            }
        }

        public void addInvalidator(Object owner, Object valueForPFER, long now) {
            assert (owner != null);
            if (this.invalidators == null) {
                if (this.singleInvalidator == null) {
                    this.singleInvalidator = new Invalidator(owner, now, valueForPFER);
                    this.put(new PendingPut(owner));
                } else {
                    if (this.singleInvalidator.registeredTimestamp + PutFromLoadValidator.this.expirationPeriod < now) {
                        this.singleInvalidator = new Invalidator(owner, now, valueForPFER);
                        this.put(new PendingPut(owner));
                    }
                    this.invalidators = new HashMap<Object, Invalidator>();
                    this.invalidators.put(this.singleInvalidator.owner, this.singleInvalidator);
                    this.invalidators.put(owner, new Invalidator(owner, now, null));
                    this.singleInvalidator = null;
                }
            } else {
                long allowedRegistration = now - PutFromLoadValidator.this.expirationPeriod;
                Iterator<Invalidator> it = this.invalidators.values().iterator();
                while (it.hasNext()) {
                    if (it.next().registeredTimestamp >= allowedRegistration) continue;
                    it.remove();
                }
                if (valueForPFER != null && this.invalidators.isEmpty()) {
                    this.put(new PendingPut(owner));
                } else {
                    valueForPFER = null;
                }
                this.invalidators.put(owner, new Invalidator(owner, now, valueForPFER));
            }
        }

        public boolean hasInvalidator() {
            return this.singleInvalidator != null || this.invalidators != null && !this.invalidators.isEmpty();
        }

        public Collection<Invalidator> getInvalidators() {
            this.lock.lock();
            try {
                if (this.singleInvalidator != null) {
                    Set<Invalidator> set = Collections.singleton(this.singleInvalidator);
                    return set;
                }
                if (this.invalidators != null) {
                    ArrayList<Invalidator> arrayList = new ArrayList<Invalidator>(this.invalidators.values());
                    return arrayList;
                }
                List list = Collections.EMPTY_LIST;
                return list;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void removeInvalidator(Object owner, Object key, long now, boolean doPFER) {
            if (this.invalidators == null) {
                if (this.singleInvalidator != null && this.singleInvalidator.owner.equals(owner)) {
                    this.pferValueIfNeeded(owner, key, this.singleInvalidator.valueForPFER, doPFER);
                    this.singleInvalidator = null;
                }
            } else {
                Invalidator invalidator = this.invalidators.remove(owner);
                if (invalidator != null) {
                    this.pferValueIfNeeded(owner, key, invalidator.valueForPFER, doPFER);
                }
            }
            this.lastInvalidationEnd = Math.max(this.lastInvalidationEnd, now);
        }

        private void pferValueIfNeeded(Object owner, Object key, Object valueForPFER, boolean doPFER) {
            if (valueForPFER != null) {
                PendingPut pendingPut = this.remove(owner);
                if (doPFER && pendingPut != null && !pendingPut.completed) {
                    PutFromLoadValidator.this.cache.putForExternalRead(key, valueForPFER);
                }
            }
        }

        public boolean canRemove() {
            return this.size() == 0 && !this.hasInvalidator() && this.lastInvalidationEnd == Long.MIN_VALUE;
        }

        public void setRemoved() {
            this.removed = true;
        }

        public boolean isRemoved() {
            return this.removed;
        }
    }

    private static class PendingPut {
        private final Object owner;
        private boolean completed;
        private long registeredTimestamp = Long.MIN_VALUE;

        private PendingPut(Object owner) {
            this.owner = owner;
        }

        public String toString() {
            return (this.completed ? "C@" : "R@") + PutFromLoadValidator.lockOwnerToString(this.owner);
        }

        public boolean invalidate(long now, long expirationPeriod) {
            this.completed = true;
            return this.gc(now, expirationPeriod);
        }

        public boolean gc(long now, long expirationPeriod) {
            if (this.registeredTimestamp == Long.MIN_VALUE) {
                this.registeredTimestamp = now;
            } else if (this.registeredTimestamp + expirationPeriod < now) {
                return true;
            }
            return false;
        }
    }

    private static class Invalidator {
        private final Object owner;
        private final long registeredTimestamp;
        private final Object valueForPFER;

        private Invalidator(Object owner, long registeredTimestamp, Object valueForPFER) {
            this.owner = owner;
            this.registeredTimestamp = registeredTimestamp;
            this.valueForPFER = valueForPFER;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            sb.append("Owner=").append(PutFromLoadValidator.lockOwnerToString(this.owner));
            sb.append(", Timestamp=").append(this.registeredTimestamp);
            sb.append('}');
            return sb.toString();
        }
    }

    public static abstract class Lock {
        private Lock() {
        }
    }
}

