/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.jboss.as.jdr.logger.JdrLogger;
import org.jboss.dmr.ModelNode;

public class JdrReport {
    public static final String JBOSS_PROPERTY_DIR = "jboss.server.data.dir";
    public static final String JDR_PROPERTY_FILE_NAME = "jdr.properties";
    public static final String UUID_NAME = "UUID";
    public static final String JDR_PROPERTIES_COMMENT = "JDR Properties";
    public static final String JBOSS_HOME_DIR = "jboss.home.dir";
    public static final String DEFAULT_PROPERTY_DIR = "standalone";
    public static final String DATA_DIR = "data";
    private Long startTime;
    private Long endTime;
    private String location;
    private String jdrUuid;
    private static DateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");

    public JdrReport() {
    }

    public JdrReport(ModelNode result) {
        this.setStartTime(result.get("start-time").asLong());
        this.setEndTime(result.get("end-time").asLong());
        this.setLocation(result.get("report-location").asString());
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public String getFormattedStartTime() {
        if (this.startTime == null) {
            return "";
        }
        return DATE_FORMAT.format(this.startTime);
    }

    public void setStartTime(Date date) {
        this.startTime = date.getTime();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setStartTime() {
        this.setStartTime(System.currentTimeMillis());
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public String getFormattedEndTime() {
        if (this.endTime == null) {
            return "";
        }
        return DATE_FORMAT.format(this.endTime);
    }

    public void setEndTime(Date date) {
        this.endTime = date.getTime();
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setEndTime() {
        this.setEndTime(System.currentTimeMillis());
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setJdrUuid(String jdrUuid) {
        Path jbossConfigPath;
        this.jdrUuid = jdrUuid;
        String jbossConfig = System.getProperty(JBOSS_PROPERTY_DIR);
        if (jbossConfig == null) {
            String jbossHome = System.getProperty(JBOSS_HOME_DIR);
            Path defaultDir = new File(jbossHome, DEFAULT_PROPERTY_DIR).toPath();
            if (Files.notExists(defaultDir, new LinkOption[0])) {
                JdrLogger.ROOT_LOGGER.couldNotFindJDRPropertiesFile();
            }
            jbossConfigPath = defaultDir.resolve(DATA_DIR);
        } else {
            jbossConfigPath = new File(jbossConfig).toPath();
        }
        Path jdrPropertiesFilePath = jbossConfigPath.resolve("jdr").resolve(JDR_PROPERTY_FILE_NAME);
        Properties jdrProperties = new Properties();
        try {
            Files.createDirectories(jdrPropertiesFilePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            JdrLogger.ROOT_LOGGER.couldNotCreateJDRPropertiesFile(e, jdrPropertiesFilePath);
        }
        if (jdrUuid == null && Files.exists(jdrPropertiesFilePath, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(jdrPropertiesFilePath, new OpenOption[0]);){
                jdrProperties.load(in);
                this.jdrUuid = jdrProperties.getProperty(UUID_NAME);
            }
            catch (IOException e) {
                JdrLogger.ROOT_LOGGER.couldNotFindJDRPropertiesFile();
            }
        } else {
            try (OutputStream fileOut = Files.newOutputStream(jdrPropertiesFilePath, StandardOpenOption.CREATE);){
                jdrProperties.setProperty(UUID_NAME, jdrUuid);
                jdrProperties.store(fileOut, JDR_PROPERTIES_COMMENT);
            }
            catch (IOException e) {
                JdrLogger.ROOT_LOGGER.couldNotCreateJDRPropertiesFile(e, jdrPropertiesFilePath);
            }
        }
    }

    public String getJdrUuid() {
        return this.jdrUuid;
    }
}

