/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.FieldMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;

public class TypedEnumMarshaller<E extends Enum<E>>
implements FieldMarshaller<E> {
    private static final int DEFAULT_ORDINAL = 0;
    private final ScalarMarshaller<Class<?>> type;

    public TypedEnumMarshaller(ScalarMarshaller<Class<?>> type) {
        this.type = type;
    }

    @Override
    public E readFrom(ProtoStreamReader reader) throws IOException {
        Class enumClass = (Class)this.type.readFrom(reader);
        Enum result = ((Enum[])enumClass.getEnumConstants())[0];
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index == AnyField.ANY.getIndex()) {
                result = reader.readEnum(enumClass);
                continue;
            }
            reader.skipField(tag);
        }
        return (E)result;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, E value) throws IOException {
        Class enumClass = ((Enum)value).getDeclaringClass();
        this.type.writeTo(writer, enumClass);
        if (((Enum)value).ordinal() != 0) {
            writer.writeEnum(AnyField.ANY.getIndex(), value);
        }
    }

    @Override
    public Class<? extends E> getJavaClass() {
        return Enum.class;
    }

    @Override
    public WireType getWireType() {
        return this.type.getWireType();
    }
}

