/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.util.function.Predicate;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.scheduler.LocalScheduler;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.SortedScheduledEntries;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.expiration.AbstractExpirationScheduler;
import org.wildfly.clustering.web.cache.session.metadata.ImmutableSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class SessionExpirationScheduler<MV>
extends AbstractExpirationScheduler<String> {
    private final ImmutableSessionMetaDataFactory<MV> metaDataFactory;

    public SessionExpirationScheduler(Batcher<TransactionBatch> batcher, ImmutableSessionMetaDataFactory<MV> metaDataFactory, Remover<String> remover, Duration closeTimeout) {
        super((Scheduler)new LocalScheduler((ScheduledEntries)new SortedScheduledEntries(), (Predicate)new SessionRemoveTask(batcher, remover), closeTimeout));
        this.metaDataFactory = metaDataFactory;
    }

    public void schedule(String sessionId) {
        Object value = this.metaDataFactory.findValue((Object)sessionId);
        if (value != null) {
            ImmutableSessionMetaData metaData = this.metaDataFactory.createImmutableSessionMetaData(sessionId, value);
            this.schedule(sessionId, metaData);
        }
    }

    private static class SessionRemoveTask
    implements Predicate<String> {
        private final Batcher<TransactionBatch> batcher;
        private final Remover<String> remover;

        SessionRemoveTask(Batcher<TransactionBatch> batcher, Remover<String> remover) {
            this.batcher = batcher;
            this.remover = remover;
        }

        @Override
        public boolean test(String sessionId) {
            boolean bl;
            block10: {
                InfinispanWebLogger.ROOT_LOGGER.debugf("Expiring web session %s", sessionId);
                Batch batch = this.batcher.createBatch();
                try {
                    this.remover.remove((Object)sessionId);
                    bl = true;
                    if (batch == null) break block10;
                }
                catch (RuntimeException e) {
                    try {
                        try {
                            batch.discard();
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (batch != null) {
                                try {
                                    batch.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    catch (RuntimeException e2) {
                        InfinispanWebLogger.ROOT_LOGGER.failedToExpireSession(e2, sessionId);
                        return false;
                    }
                }
                batch.close();
            }
            return bl;
        }
    }
}

