/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.nio.ByteBuffer;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.hibernate.search.backend.lucene.lowlevel.codec.impl.HibernateSearchKnnVectorsFormat;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneVectorFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;

public class LuceneFloatVectorCodec
extends AbstractLuceneVectorFieldCodec<float[]> {
    public LuceneFloatVectorCodec(VectorSimilarityFunction vectorSimilarity, int dimension, Storage storage, Indexing indexing, float[] indexNullAsValue, HibernateSearchKnnVectorsFormat knnVectorsFormat) {
        super(vectorSimilarity, dimension, storage, indexing, indexNullAsValue, knnVectorsFormat);
    }

    @Override
    public float[] decode(IndexableField field) {
        float[] result = new float[field.binaryValue().bytes.length / 4];
        int index = 0;
        ByteBuffer buffer = ByteBuffer.wrap(field.binaryValue().bytes);
        while (buffer.hasRemaining()) {
            result[index++] = buffer.getFloat();
        }
        return result;
    }

    @Override
    public byte[] encode(float[] value) {
        ByteBuffer buffer = ByteBuffer.allocate(4 * value.length);
        for (float element : value) {
            buffer.putFloat(element);
        }
        return buffer.array();
    }

    @Override
    protected IndexableField createIndexField(String absoluteFieldPath, float[] value) {
        return new KnnFloatVectorField(absoluteFieldPath, value, this.fieldType);
    }

    @Override
    protected VectorEncoding vectorEncoding() {
        return VectorEncoding.FLOAT32;
    }

    @Override
    public Class<?> vectorElementsType() {
        return Float.TYPE;
    }
}

