/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import org.projectodd.vdx.core.ErrorHandler;
import org.projectodd.vdx.core.handlers.DuplicateAttributeHandler;
import org.projectodd.vdx.core.handlers.DuplicateElementHandler;
import org.projectodd.vdx.core.handlers.InvalidAttributeValueHandler;
import org.projectodd.vdx.core.handlers.RequiredAttributeMissingHandler;
import org.projectodd.vdx.core.handlers.RequiredElementMissingHandler;
import org.projectodd.vdx.core.handlers.RequiredElementsMissingHandler;
import org.projectodd.vdx.core.handlers.UnexpectedAttributeHandler;
import org.projectodd.vdx.core.handlers.UnexpectedElementHandler;
import org.projectodd.vdx.core.handlers.UnknownErrorHandler;
import org.projectodd.vdx.core.handlers.UnsupportedElementHandler;

public enum ErrorType {
    DUPLICATE_ATTRIBUTE(DuplicateAttributeHandler.class),
    DUPLICATE_ELEMENT(DuplicateElementHandler.class),
    INVALID_ATTRIBUTE_VALUE(InvalidAttributeValueHandler.class),
    REQUIRED_ATTRIBUTE_MISSING(RequiredAttributeMissingHandler.class),
    REQUIRED_ELEMENT_MISSING(RequiredElementMissingHandler.class),
    REQUIRED_ELEMENTS_MISSING(RequiredElementsMissingHandler.class),
    UNEXPECTED_ATTRIBUTE(UnexpectedAttributeHandler.class),
    UNEXPECTED_ELEMENT(UnexpectedElementHandler.class),
    UNKNOWN_ERROR(UnknownErrorHandler.class),
    UNSUPPORTED_ELEMENT(UnsupportedElementHandler.class);

    private final Class<? extends ErrorHandler> handlerClass;

    public ErrorHandler handler() {
        try {
            Optional<Constructor> ctor = Arrays.stream(this.handlerClass.getConstructors()).filter(c -> c.getGenericParameterTypes().length == 0).findFirst();
            if (!ctor.isPresent()) {
                throw new RuntimeException("Class " + this.handlerClass.getCanonicalName() + " has no 0-arity constructor");
            }
            return (ErrorHandler)ctor.get().newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private ErrorType(Class<? extends ErrorHandler> handlerClass) {
        this.handlerClass = handlerClass;
    }
}

