/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.management;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class AuthorizedAddress {
    private static final String HIDDEN = "<hidden>";
    private static final Set<Action.ActionEffect> ADDRESS_EFFECT = EnumSet.of(Action.ActionEffect.ADDRESS);
    private final ModelNode address;
    private final boolean elided;

    AuthorizedAddress(ModelNode address, boolean elided) {
        this.address = address;
        this.elided = elided;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.address);
        hash = 37 * hash + (this.elided ? 1 : 0);
        return hash;
    }

    public String toString() {
        return "AuthorizedAddress{address=" + this.address + ", elided=" + this.elided + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizedAddress other = (AuthorizedAddress)obj;
        if (!Objects.equals(this.address, other.address)) {
            return false;
        }
        return this.elided == other.elided;
    }

    public ModelNode getAddress() {
        return this.address;
    }

    public boolean isElided() {
        return this.elided;
    }

    public static AuthorizedAddress authorizeAddress(OperationContext context, ModelNode operation) {
        ModelNode address = operation.get("address");
        ModelNode testOp = new ModelNode();
        testOp.get("operation").set("read-resource");
        testOp.get("address").set(address);
        AuthorizationResult authResult = context.authorize(testOp, ADDRESS_EFFECT);
        if (authResult.getDecision() == AuthorizationResult.Decision.PERMIT) {
            return new AuthorizedAddress(address, false);
        }
        ModelNode partialAddress = new ModelNode().setEmptyList();
        ModelNode elidedAddress = new ModelNode().setEmptyList();
        for (Property prop : address.asPropertyList()) {
            partialAddress.add(prop);
            testOp.get("address").set(partialAddress);
            authResult = context.authorize(testOp, ADDRESS_EFFECT);
            if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
                elidedAddress.add(prop.getName(), HIDDEN);
                return new AuthorizedAddress(elidedAddress, true);
            }
            elidedAddress.add(prop);
        }
        ModelNode strange = new ModelNode();
        strange.add(HIDDEN, HIDDEN);
        return new AuthorizedAddress(strange, true);
    }
}

