/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedListJoin<O, T, S extends T>
extends SqmListJoin<O, S>
implements SqmTreatedPath<T, S> {
    private final SqmListJoin<O, T> wrappedPath;
    private final EntityDomainType<S> treatTarget;

    public SqmTreatedListJoin(SqmListJoin<O, T> wrappedPath, EntityDomainType<S> treatTarget, String alias) {
        this(wrappedPath, treatTarget, alias, false);
    }

    public SqmTreatedListJoin(SqmListJoin<O, T> wrappedPath, EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), wrappedPath.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()).treatAs(treatTarget.getHibernateEntityName(), alias), wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    private SqmTreatedListJoin(NavigablePath navigablePath, SqmListJoin<O, T> wrappedPath, EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), navigablePath, wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public SqmTreatedListJoin<O, T, S> copy(SqmCopyContext context) {
        SqmTreatedListJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedListJoin<O, T, S> path = context.registerCopy(this, new SqmTreatedListJoin<O, T, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias(), this.isFetched()));
        this.copyTo(path, context);
        return path;
    }

    public SqmListJoin<O, T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public EntityDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType<S> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<?> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        return this.getWrappedPath().resolveIndexedAccess(selector, isTerminal, creationState);
    }

    @Override
    public SqmAttributeJoin<O, S> makeCopy(SqmCreationProcessingState creationProcessingState) {
        return new SqmTreatedListJoin<O, T, S>(this.wrappedPath, this.treatTarget, this.getAlias());
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getName());
        sb.append(')');
    }
}

