/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.UndertowExtension;

public class ByteBufferPoolDefinition
extends PersistentResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"byte-buffer-pool");
    static final RuntimeCapability<Void> UNDERTOW_BUFFER_POOL_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.byte-buffer-pool", (boolean)true, ByteBufferPool.class).build();
    private static final int defaultBufferSize;
    private static final boolean defaultDirectBuffers;
    protected static final SimpleAttributeDefinition BUFFER_SIZE;
    protected static final SimpleAttributeDefinition MAX_POOL_SIZE;
    protected static final SimpleAttributeDefinition DIRECT;
    protected static final SimpleAttributeDefinition THREAD_LOCAL_CACHE_SIZE;
    protected static final SimpleAttributeDefinition LEAK_DETECTION_PERCENT;
    static final List<AttributeDefinition> ATTRIBUTES;

    ByteBufferPoolDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, (ResourceDescriptionResolver)UndertowExtension.getResolver(PATH_ELEMENT.getKey())).setAddHandler((OperationStepHandler)new BufferPoolAdd()).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).addCapabilities(new RuntimeCapability[]{UNDERTOW_BUFFER_POOL_RUNTIME_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory < 0x4000000L) {
            defaultDirectBuffers = false;
            defaultBufferSize = 512;
        } else if (maxMemory < 0x8000000L) {
            defaultDirectBuffers = true;
            defaultBufferSize = 1024;
        } else {
            defaultDirectBuffers = true;
            defaultBufferSize = 16384;
        }
        BUFFER_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("buffer-size", ModelType.INT).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)new IntRangeValidator(0, true, true))).setAllowExpression(true)).build();
        MAX_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-pool-size", ModelType.INT).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)new IntRangeValidator(0, true, true))).setAllowExpression(true)).build();
        DIRECT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("direct", ModelType.BOOLEAN).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).build();
        THREAD_LOCAL_CACHE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("thread-local-cache-size", ModelType.INT).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)new IntRangeValidator(0, true, true))).setAllowExpression(true)).setDefaultValue(new ModelNode(12))).build();
        LEAK_DETECTION_PERCENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("leak-detection-percent", ModelType.INT).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)new IntRangeValidator(0, true, true))).setAllowExpression(true)).setDefaultValue(ModelNode.ZERO)).build();
        ATTRIBUTES = Arrays.asList(BUFFER_SIZE, MAX_POOL_SIZE, DIRECT, THREAD_LOCAL_CACHE_SIZE, LEAK_DETECTION_PERCENT);
    }

    private static class BufferPoolAdd
    extends AbstractAddStepHandler {
        private BufferPoolAdd() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ModelNode bufferSizeModel = BUFFER_SIZE.resolveModelAttribute(context, model);
            ModelNode maxPoolSizeModel = MAX_POOL_SIZE.resolveModelAttribute(context, model);
            ModelNode directModel = DIRECT.resolveModelAttribute(context, model);
            int threadLocalCacheSize = THREAD_LOCAL_CACHE_SIZE.resolveModelAttribute(context, model).asInt();
            int leakDetectionPercent = LEAK_DETECTION_PERCENT.resolveModelAttribute(context, model).asInt();
            int bufferSize = bufferSizeModel.asInt(defaultBufferSize);
            int maxPoolSize = maxPoolSizeModel.asInt(-1);
            boolean direct = directModel.asBoolean(defaultDirectBuffers);
            ByteBufferPoolService service = new ByteBufferPoolService(direct, bufferSize, maxPoolSize, threadLocalCacheSize, leakDetectionPercent);
            context.getCapabilityServiceTarget().addCapability(UNDERTOW_BUFFER_POOL_RUNTIME_CAPABILITY).setInstance((Service)service).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }

    private static final class ByteBufferPoolService
    implements org.jboss.msc.service.Service<ByteBufferPool> {
        private final boolean direct;
        private final int size;
        private final int maxSize;
        private final int threadLocalCacheSize;
        private final int leakDetectionPercent;
        private volatile ByteBufferPool pool;

        private ByteBufferPoolService(boolean direct, int size, int maxSize, int threadLocalCacheSize, int leakDetectionPercent) {
            this.direct = direct;
            this.size = size;
            this.maxSize = maxSize;
            this.threadLocalCacheSize = threadLocalCacheSize;
            this.leakDetectionPercent = leakDetectionPercent;
        }

        public void start(StartContext startContext) throws StartException {
            this.pool = new DefaultByteBufferPool(this.direct, this.size, this.maxSize, this.threadLocalCacheSize, this.leakDetectionPercent);
        }

        public void stop(StopContext stopContext) {
            this.pool.close();
            this.pool = null;
        }

        public ByteBufferPool getValue() throws IllegalStateException, IllegalArgumentException {
            return this.pool;
        }
    }
}

