/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.wildfly.clustering.ee.cache.offset.Offset;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionCreationMetaDataEntry;
import org.wildfly.common.function.Functions;

public class DefaultSessionCreationMetaDataEntry<C>
implements SessionCreationMetaDataEntry<C> {
    private final Instant creationTime;
    private volatile Duration timeout = Duration.ZERO;
    private final AtomicReference<C> context = new AtomicReference();

    public DefaultSessionCreationMetaDataEntry() {
        this(Instant.now().truncatedTo(ChronoUnit.MILLIS));
    }

    public DefaultSessionCreationMetaDataEntry(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public C getContext(Supplier<C> factory) {
        return this.context.updateAndGet(context -> Optional.ofNullable(context).orElseGet(factory));
    }

    public SessionCreationMetaDataEntry<C> remap(Supplier<Offset<Duration>> timeoutOffset) {
        DefaultSessionCreationMetaDataEntry<C> result = new DefaultSessionCreationMetaDataEntry<C>(this.creationTime);
        result.setTimeout((Duration)timeoutOffset.get().apply((Object)this.timeout));
        result.getContext(Functions.constantSupplier(this.context.get()));
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append(" { ");
        builder.append("created = ").append(this.creationTime);
        builder.append(", timeout = ").append(this.timeout);
        return builder.append(" }").toString();
    }
}

