/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v62.impl;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.v62.impl.DomainDataRegionImpl;

abstract class AbstractAccess {
    private final AccessType accessType;
    final AccessDelegate delegate;
    final DomainDataRegionImpl region;

    AbstractAccess(AccessType accessType, AccessDelegate delegate, DomainDataRegionImpl region) {
        this.accessType = accessType;
        this.delegate = delegate;
        this.region = region;
    }

    public void evict(Object key) throws CacheException {
        this.delegate.evict(key);
    }

    public void evictAll() throws CacheException {
        this.delegate.evictAll();
    }

    public void removeAll(SharedSessionContractImplementor session) throws CacheException {
        this.delegate.removeAll();
    }

    public SoftLock lockRegion() throws CacheException {
        this.delegate.lockAll();
        return null;
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
        this.delegate.unlockAll();
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public DomainDataRegion getRegion() {
        return this.region;
    }

    public boolean contains(Object key) {
        return this.delegate.get(null, key, Long.MAX_VALUE) != null;
    }
}

