/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene99;

import java.io.IOException;
import org.apache.lucene.store.DataInput;

public class GroupVIntReader {
    public static void readValues(DataInput in, long[] docs, int limit) throws IOException {
        int i;
        for (i = 0; i <= limit - 4; i += 4) {
            int flag = in.readByte() & 0xFF;
            int n1Minus1 = flag >> 6;
            int n2Minus1 = flag >> 4 & 3;
            int n3Minus1 = flag >> 2 & 3;
            int n4Minus1 = flag & 3;
            docs[i] = GroupVIntReader.readLong(in, n1Minus1);
            docs[i + 1] = GroupVIntReader.readLong(in, n2Minus1);
            docs[i + 2] = GroupVIntReader.readLong(in, n3Minus1);
            docs[i + 3] = GroupVIntReader.readLong(in, n4Minus1);
        }
        while (i < limit) {
            docs[i] = in.readVInt();
            ++i;
        }
    }

    private static long readLong(DataInput in, int numBytesMinus1) throws IOException {
        switch (numBytesMinus1) {
            case 0: {
                return (long)in.readByte() & 0xFFL;
            }
            case 1: {
                return (long)in.readShort() & 0xFFFFL;
            }
            case 2: {
                return (long)in.readShort() & 0xFFFFL | ((long)in.readByte() & 0xFFL) << 16;
            }
        }
        return (long)in.readInt() & 0xFFFFFFFFL;
    }
}

