/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.engine.search.predicate.spi.CommonQueryStringPredicateBuilder;

public final class ElasticsearchCommonQueryStringPredicateBuilderFieldState
implements CommonQueryStringPredicateBuilder.FieldState {
    private static final String BOOST_OPERATOR = "^";
    private final ElasticsearchSearchIndexValueFieldContext<String> field;
    private Float boost;

    private ElasticsearchCommonQueryStringPredicateBuilderFieldState(ElasticsearchSearchIndexValueFieldContext<String> field) {
        this.field = field;
    }

    public void boost(float boost) {
        this.boost = Float.valueOf(boost);
    }

    public ElasticsearchSearchIndexValueFieldContext<String> field() {
        return this.field;
    }

    public void checkAnalyzerOrNormalizerCompatibleAcrossIndexes() {
        this.field.type().searchAnalyzerName();
        this.field.type().normalizerName();
    }

    public JsonPrimitive build() {
        StringBuilder sb = new StringBuilder(this.field.absolutePath());
        if (this.boost != null) {
            sb.append(BOOST_OPERATOR).append(this.boost);
        }
        return new JsonPrimitive(sb.toString());
    }

    public static class Factory
    extends AbstractElasticsearchValueFieldSearchQueryElementFactory<ElasticsearchCommonQueryStringPredicateBuilderFieldState, String> {
        @Override
        public ElasticsearchCommonQueryStringPredicateBuilderFieldState create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<String> field) {
            return new ElasticsearchCommonQueryStringPredicateBuilderFieldState(field);
        }
    }
}

