/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.deployment;

import java.util.Arrays;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.xml.VersionedFeature;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagementConfiguration;
import org.wildfly.clustering.web.service.routing.RouteLocatorServiceConfiguratorFactory;
import org.wildfly.clustering.web.session.DistributableSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentSchema;
import org.wildfly.extension.clustering.web.deployment.MutableDistributableWebDeploymentConfiguration;
import org.wildfly.extension.clustering.web.deployment.MutableHotRodSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.deployment.MutableInfinispanSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.deployment.MutableRankedRoutingConfiguration;
import org.wildfly.extension.clustering.web.deployment.MutableSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.routing.LocalRouteLocatorServiceConfiguratorFactory;
import org.wildfly.extension.clustering.web.routing.NullRouteLocatorServiceConfiguratorFactory;
import org.wildfly.extension.clustering.web.routing.infinispan.PrimaryOwnerRouteLocatorServiceConfiguratorFactory;
import org.wildfly.extension.clustering.web.routing.infinispan.RankedRouteLocatorServiceConfiguratorFactory;
import org.wildfly.extension.clustering.web.session.hotrod.HotRodSessionManagementProvider;
import org.wildfly.extension.clustering.web.session.infinispan.InfinispanSessionManagementProvider;

public class DistributableWebDeploymentXMLReader
implements XMLElementReader<MutableDistributableWebDeploymentConfiguration> {
    private static final String SESSION_MANAGEMENT = "session-management";
    private static final String NAME = "name";
    private static final String HOTROD_SESSION_MANAGEMENT = "hotrod-session-management";
    private static final String INFINISPAN_SESSION_MANAGEMENT = "infinispan-session-management";
    private static final String REMOTE_CACHE_CONTAINER = "remote-cache-container";
    private static final String CACHE_CONFIGURATION = "cache-configuration";
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String CACHE = "cache";
    private static final String GRANULARITY = "granularity";
    private static final String MARSHALLER = "marshaller";
    private static final String NO_AFFINITY = "no-affinity";
    private static final String LOCAL_AFFINITY = "local-affinity";
    private static final String PRIMARY_OWNER_AFFINITY = "primary-owner-affinity";
    private static final String RANKED_AFFINITY = "ranked-affinity";
    private static final String DELIMITER = "delimiter";
    private static final String MAX_ROUTES = "max-routes";
    private static final String IMMUTABLE_CLASS = "immutable-class";
    private static final String EXPIRATION_THREAD_POOL_SIZE = "expiration-thread-pool-size";
    private final DistributableWebDeploymentSchema schema;

    public DistributableWebDeploymentXMLReader(DistributableWebDeploymentSchema schema) {
        this.schema = schema;
    }

    public void readElement(XMLExtendedStreamReader reader, MutableDistributableWebDeploymentConfiguration configuration) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        TreeSet<String> names = new TreeSet<String>();
        names.add(SESSION_MANAGEMENT);
        names.add(HOTROD_SESSION_MANAGEMENT);
        names.add(INFINISPAN_SESSION_MANAGEMENT);
        if (!reader.hasNext() || reader.nextTag() == 2) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, names);
        }
        switch (reader.getLocalName()) {
            case "session-management": {
                this.readSessionManagement(reader, configuration);
                break;
            }
            case "hotrod-session-management": {
                MutableHotRodSessionManagementConfiguration config = new MutableHotRodSessionManagementConfiguration(configuration);
                configuration.setSessionManagement(new HotRodSessionManagementProvider(config));
                this.readHotRodSessionManagement(reader, config);
                break;
            }
            case "infinispan-session-management": {
                MutableInfinispanSessionManagementConfiguration config = new MutableInfinispanSessionManagementConfiguration(configuration);
                RouteLocatorServiceConfiguratorFactory<InfinispanSessionManagementConfiguration<DeploymentUnit>> factory = this.readInfinispanSessionManagement(reader, config, configuration);
                configuration.setSessionManagement(new InfinispanSessionManagementProvider(config, factory));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader, names);
            }
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readSessionManagement(XMLExtendedStreamReader reader, MutableDistributableWebDeploymentConfiguration configuration) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            switch (name) {
                case "name": {
                    configuration.setSessionManagementName(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.readImmutability(reader, configuration);
    }

    private void readSessionManagementAttribute(XMLExtendedStreamReader reader, int index, MutableSessionManagementConfiguration configuration) throws XMLStreamException {
        String value = reader.getAttributeValue(index);
        switch (reader.getAttributeLocalName(index)) {
            case "granularity": {
                try {
                    configuration.setSessionGranularity(value);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
                }
            }
            case "marshaller": {
                try {
                    configuration.setMarshallerFactory(value);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
                }
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private RouteLocatorServiceConfiguratorFactory<InfinispanSessionManagementConfiguration<DeploymentUnit>> readInfinispanSessionManagement(XMLExtendedStreamReader reader, MutableInfinispanSessionManagementConfiguration configuration, Consumer<String> accumulator) throws XMLStreamException {
        TreeSet<String> required = new TreeSet<String>(Arrays.asList(CACHE_CONTAINER, GRANULARITY));
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            required.remove(name);
            switch (name) {
                case "cache-container": {
                    configuration.setContainerName(value);
                    continue block8;
                }
                case "cache": {
                    configuration.setCacheName(value);
                    continue block8;
                }
                default: {
                    this.readSessionManagementAttribute(reader, i, configuration);
                }
            }
        }
        if (!required.isEmpty()) {
            ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])required.toArray(new String[required.size()]));
        }
        RouteLocatorServiceConfiguratorFactory<InfinispanSessionManagementConfiguration<DeploymentUnit>> affinityFactory = this.readInfinispanAffinity(reader);
        this.readImmutability(reader, accumulator);
        return affinityFactory;
    }

    private RouteLocatorServiceConfiguratorFactory<InfinispanSessionManagementConfiguration<DeploymentUnit>> readInfinispanAffinity(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (!reader.hasNext() || reader.nextTag() == 2) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, new TreeSet<String>(Arrays.asList(NO_AFFINITY, LOCAL_AFFINITY, PRIMARY_OWNER_AFFINITY)));
        }
        switch (reader.getLocalName()) {
            case "primary-owner-affinity": {
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return new PrimaryOwnerRouteLocatorServiceConfiguratorFactory<InfinispanSessionManagementConfiguration<DeploymentUnit>>();
            }
            case "ranked-affinity": {
                if (!this.schema.since((VersionedFeature)DistributableWebDeploymentSchema.VERSION_2_0)) break;
                MutableRankedRoutingConfiguration config = new MutableRankedRoutingConfiguration();
                block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    String value = reader.getAttributeValue(i);
                    switch (reader.getAttributeLocalName(i)) {
                        case "delimiter": {
                            config.setDelimiter(value);
                            continue block16;
                        }
                        case "max-routes": {
                            config.setMaxRoutes(Integer.parseInt(value));
                            continue block16;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return new RankedRouteLocatorServiceConfiguratorFactory<InfinispanSessionManagementConfiguration<DeploymentUnit>>(config);
            }
        }
        return this.readAffinity(reader);
    }

    private RouteLocatorServiceConfiguratorFactory<DistributableSessionManagementConfiguration<DeploymentUnit>> readHotRodSessionManagement(XMLExtendedStreamReader reader, MutableHotRodSessionManagementConfiguration configuration) throws XMLStreamException {
        TreeSet<String> required = new TreeSet<String>(Arrays.asList(REMOTE_CACHE_CONTAINER, GRANULARITY));
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String localName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            required.remove(localName);
            switch (localName) {
                case "remote-cache-container": {
                    configuration.setContainerName(value);
                    continue block10;
                }
                case "cache-configuration": {
                    configuration.setConfigurationName(value);
                    continue block10;
                }
                case "expiration-thread-pool-size": {
                    if (this.schema.since((VersionedFeature)DistributableWebDeploymentSchema.VERSION_4_0)) {
                        configuration.setExpirationThreadPoolSize(Integer.parseInt(value));
                        continue block10;
                    }
                }
                default: {
                    this.readSessionManagementAttribute(reader, i, configuration);
                }
            }
        }
        if (!required.isEmpty()) {
            ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])required.toArray(new String[required.size()]));
        }
        if (!reader.hasNext() || reader.nextTag() == 2) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, new TreeSet<String>(Arrays.asList(NO_AFFINITY, LOCAL_AFFINITY)));
        }
        return this.readAffinity(reader);
    }

    private <C> RouteLocatorServiceConfiguratorFactory<C> readAffinity(XMLExtendedStreamReader reader) throws XMLStreamException {
        switch (reader.getLocalName()) {
            case "no-affinity": {
                ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return new NullRouteLocatorServiceConfiguratorFactory();
            }
            case "local-affinity": {
                ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return new LocalRouteLocatorServiceConfiguratorFactory();
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private void readImmutability(XMLExtendedStreamReader reader, Consumer<String> accumulator) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (reader.getLocalName()) {
                case "immutable-class": {
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    accumulator.accept(reader.getElementText());
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

