/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.el.cache.FactoryFinderCache;
import org.jboss.modules.Module;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class EECleanUpProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        deploymentUnit.removeAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        deploymentUnit.removeAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        deploymentUnit.removeAttachment(Attachments.EE_MODULE_CONFIGURATION);
        deploymentUnit.removeAttachment(Attachments.EE_MODULE_DESCRIPTION);
        deploymentUnit.removeAttachment(Attachments.MODULE_DEPLOYMENT_DESCRIPTOR_ENVIRONMENT);
    }

    public void undeploy(DeploymentUnit context) {
        final Module module = (Module)context.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        ServiceName deploymentService = context.getServiceName();
        final ServiceController controller = context.getServiceRegistry().getRequiredService(deploymentService);
        controller.addListener(new LifecycleListener(){

            public void handleEvent(ServiceController<?> serviceController, LifecycleEvent lifecycleEvent) {
                if (lifecycleEvent == LifecycleEvent.DOWN) {
                    EECleanUpProcessor.this.clearFactoryFinderCache(module);
                    controller.removeListener((LifecycleListener)this);
                }
            }
        });
    }

    private void clearFactoryFinderCache(Module module) {
        try {
            FactoryFinderCache.clearClassLoader((ClassLoader)module.getClassLoader());
        }
        catch (NoClassDefFoundError e) {
            EeLogger.ROOT_LOGGER.debugf("Cannot load FactoryFinderCache class -- cache clearing will not be performed", new Object[0]);
        }
    }
}

