/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentOverlayDeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.MountedDeploymentOverlay;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class DeferredDeploymentOverlayDeploymentUnitProcessor
extends DeploymentOverlayDeploymentUnitProcessor {
    public DeferredDeploymentOverlayDeploymentUnitProcessor(ContentRepository contentRepository) {
        super(contentRepository);
    }

    @Override
    protected void handleEntryWithFileParent(Map<String, byte[]> deferred, Map.Entry<String, byte[]> entry, String path, VirtualFile parent) {
        ServerLogger.DEPLOYMENT_LOGGER.couldNotMountOverlay(path, parent);
    }

    @Override
    protected void handleExplodedEntryWithDirParent(DeploymentUnit deploymentUnit, VirtualFile content, VirtualFile mountPoint, Map<String, MountedDeploymentOverlay> mounts, String overLayPath) throws IOException {
        Closeable handle = VFS.mountReal((File)content.getPhysicalFile(), (VirtualFile)mountPoint);
        MountedDeploymentOverlay mounted = new MountedDeploymentOverlay(handle, content.getPhysicalFile(), mountPoint, TempFileProviderService.provider());
        deploymentUnit.addToAttachmentList(MOUNTED_FILES, mounted);
        mounts.put(overLayPath, mounted);
    }

    @Override
    protected Map<String, byte[]> getDeferredAttachment(DeploymentUnit deploymentUnit) {
        return (Map)deploymentUnit.getAttachment(DEFERRED_OVERLAYS);
    }

    @Override
    protected Map<String, MountedDeploymentOverlay> getMountsAttachment(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getAttachment(Attachments.DEPLOYMENT_OVERLAY_LOCATIONS);
    }

    @Override
    protected Map<String, byte[]> getOverlays(DeploymentUnit deploymentUnit) {
        return (Map)deploymentUnit.getAttachment(DEFERRED_OVERLAYS);
    }
}

