/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.fine;

import java.time.Duration;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionAccessMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionAccessMetaDataEntryOffsets;

public class DefaultSessionAccessMetaDataEntry
implements SessionAccessMetaDataEntry {
    private volatile Duration sinceCreation = Duration.ZERO;
    private volatile Duration lastAccess = Duration.ZERO;

    @Override
    public boolean isNew() {
        return this.getLastAccessDuration().isZero();
    }

    @Override
    public Duration getSinceCreationDuration() {
        return this.sinceCreation;
    }

    @Override
    public Duration getLastAccessDuration() {
        return this.lastAccess;
    }

    @Override
    public void setLastAccessDuration(Duration sinceCreation, Duration lastAccess) {
        this.sinceCreation = sinceCreation;
        this.lastAccess = lastAccess;
    }

    public SessionAccessMetaDataEntry remap(SessionAccessMetaDataEntryOffsets delta) {
        DefaultSessionAccessMetaDataEntry result = new DefaultSessionAccessMetaDataEntry();
        result.setLastAccessDuration((Duration)delta.getSinceCreationOffset().apply((Object)this.sinceCreation), (Duration)delta.getLastAccessOffset().apply((Object)this.lastAccess));
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append(" { ");
        builder.append("since-creation = ").append(this.sinceCreation);
        builder.append(", last-access = ").append(this.lastAccess);
        return builder.append("}").toString();
    }
}

