/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import io.undertow.server.handlers.ChannelUpgradeHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.net.ssl.SSLContext;
import javax.sql.DataSource;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerPolicy;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.ActiveMQBroker;
import org.wildfly.extension.messaging.activemq.ActiveMQServerResource;
import org.wildfly.extension.messaging.activemq.ActiveMQServerService;
import org.wildfly.extension.messaging.activemq.AddressSettingAdd;
import org.wildfly.extension.messaging.activemq.BridgeDefinition;
import org.wildfly.extension.messaging.activemq.BroadcastGroupAdd;
import org.wildfly.extension.messaging.activemq.Capabilities;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.ConfigurationHelper;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.HTTPAcceptorDefinition;
import org.wildfly.extension.messaging.activemq.JGroupsBroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.JGroupsDiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.PathDefinition;
import org.wildfly.extension.messaging.activemq.QueueService;
import org.wildfly.extension.messaging.activemq.SecurityRoleDefinition;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastCommandDispatcherFactory;
import org.wildfly.extension.messaging.activemq.ha.HAPolicyConfigurationBuilder;
import org.wildfly.extension.messaging.activemq.jms.JMSService;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.manager.WildFlySecurityManager;

class ServerAdd
extends AbstractAddStepHandler {
    private static final String ARTEMIS_BROKER_CONFIG_NODEMANAGER_STORE_TABLE_NAME = "brokerconfig.storeConfiguration.nodeManagerStoreTableName";
    private static final String ARTEMIS_BROKER_CONFIG_JBDC_LOCK_RENEW_PERIOD_MILLIS = "brokerconfig.storeConfiguration.jdbcLockRenewPeriodMillis";
    private static final String ARTEMIS_BROKER_CONFIG_JBDC_LOCK_EXPIRATION_MILLIS = "brokerconfig.storeConfiguration.jdbcLockExpirationMillis";
    private static final String ARTEMIS_BROKER_CONFIG_JDBC_LOCK_ACQUISITION_TIMEOUT_MILLIS = "brokerconfig.storeConfiguration.jdbcLockAcquisitionTimeoutMillis";
    final BiConsumer<OperationContext, String> broadcastCommandDispatcherFactoryInstaller;

    ServerAdd(BiConsumer<OperationContext, String> broadcastCommandDispatcherFactoryInstaller) {
        super(ServerDefinition.ATTRIBUTES);
        this.broadcastCommandDispatcherFactoryInstaller = broadcastCommandDispatcherFactoryInstaller;
    }

    protected Resource createResource(OperationContext context) {
        ActiveMQServerResource resource = new ActiveMQServerResource();
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
        return resource;
    }

    protected void populateModel(OperationContext context, ModelNode operation, final Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel().get(ServerDefinition.CREDENTIAL_REFERENCE.getName()), (String)ServerDefinition.CREDENTIAL_REFERENCE.getName());
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode model = Resource.Tools.readModel((Resource)resource);
                for (String path : PathDefinition.PATHS.keySet()) {
                    if (model.get("path").hasDefined(path)) continue;
                    PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"path", (String)path)});
                    context.createResource(pathAddress);
                }
            }
        }, OperationContext.Stage.MODEL);
        context.addStep((operationContext, model) -> {
            if (ServerDefinition.JOURNAL_DATASOURCE.resolveModelAttribute(context, model).isDefined()) {
                this.checkNoAttributesIsDefined(ServerDefinition.JOURNAL_DATASOURCE.getName(), operationContext.getCurrentAddress(), model, new AttributeDefinition[]{ServerDefinition.JOURNAL_TYPE, ServerDefinition.JOURNAL_BUFFER_TIMEOUT, ServerDefinition.JOURNAL_BUFFER_SIZE, ServerDefinition.JOURNAL_SYNC_TRANSACTIONAL, ServerDefinition.JOURNAL_SYNC_NON_TRANSACTIONAL, ServerDefinition.LOG_JOURNAL_WRITE_RATE, ServerDefinition.JOURNAL_FILE_SIZE, ServerDefinition.JOURNAL_MIN_FILES, ServerDefinition.JOURNAL_POOL_FILES, ServerDefinition.JOURNAL_FILE_OPEN_TIMEOUT, ServerDefinition.JOURNAL_COMPACT_PERCENTAGE, ServerDefinition.JOURNAL_COMPACT_MIN_FILES, ServerDefinition.JOURNAL_MAX_IO, ServerDefinition.CREATE_BINDINGS_DIR, ServerDefinition.CREATE_JOURNAL_DIR});
            }
        }, OperationContext.Stage.MODEL);
    }

    private void checkNoAttributesIsDefined(String definedAttributeName, PathAddress address, ModelNode model, AttributeDefinition ... attrs) throws OperationFailedException {
        ArrayList<String> definedAttributes = new ArrayList<String>();
        for (AttributeDefinition attr : attrs) {
            if (!model.get(attr.getName()).isDefined()) continue;
            definedAttributes.add(attr.getName());
        }
        if (!definedAttributes.isEmpty()) {
            MessagingLogger.ROOT_LOGGER.invalidConfiguration(address, definedAttributeName, definedAttributes);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        context.addStep((OperationStepHandler)new InstallServerHandler(resource), OperationContext.Stage.RUNTIME);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)ServerDefinition.CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
    }

    private class InstallServerHandler
    implements OperationStepHandler {
        private final Resource resource;

        private InstallServerHandler(Resource resource) {
            this.resource = resource;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Supplier groupBinding;
            ServiceName groupBindingServiceName;
            String clusterName;
            String channelName;
            String key;
            String name;
            CapabilityServiceTarget capabilityServiceTarget = context.getCapabilityServiceTarget();
            String serverName = context.getCurrentAddressValue();
            ModelNode model = Resource.Tools.readModel((Resource)this.resource);
            Configuration configuration = this.transformConfig(context, serverName, model);
            String bindingsPath = PathDefinition.PATHS.get("bindings-directory").resolveModelAttribute(context, model.get(new String[]{"path", "bindings-directory"})).asString();
            String bindingsRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "bindings-directory"})).asString();
            String journalPath = PathDefinition.PATHS.get("journal-directory").resolveModelAttribute(context, model.get(new String[]{"path", "journal-directory"})).asString();
            String journalRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "journal-directory"})).asString();
            String largeMessagePath = PathDefinition.PATHS.get("large-messages-directory").resolveModelAttribute(context, model.get(new String[]{"path", "large-messages-directory"})).asString();
            String largeMessageRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "large-messages-directory"})).asString();
            String pagingPath = PathDefinition.PATHS.get("paging-directory").resolveModelAttribute(context, model.get(new String[]{"path", "paging-directory"})).asString();
            String pagingRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "paging-directory"})).asString();
            ServiceName activeMQServiceName = MessagingServices.getActiveMQServiceName(serverName);
            CapabilityServiceBuilder serviceBuilder = capabilityServiceTarget.addCapability(Capabilities.ACTIVEMQ_SERVER_CAPABILITY);
            Supplier pathManager = serviceBuilder.requiresCapability("org.wildfly.management.path-manager", PathManager.class, new String[0]);
            Optional<Supplier<DataSource>> dataSource = Optional.empty();
            String dataSourceName = ServerDefinition.JOURNAL_DATASOURCE.resolveModelAttribute(context, model).asStringOrNull();
            if (dataSourceName != null) {
                dataSource = Optional.of(serviceBuilder.requiresCapability("org.wildfly.data-source", DataSource.class, new String[]{dataSourceName}));
            }
            Optional<Supplier<MBeanServer>> mbeanServer = Optional.empty();
            if (context.hasOptionalCapability("org.wildfly.management.jmx", Capabilities.ACTIVEMQ_SERVER_CAPABILITY.getDynamicName(serverName), null)) {
                ServiceName jmxCapability = context.getCapabilityServiceName("org.wildfly.management.jmx", MBeanServer.class);
                mbeanServer = Optional.of(serviceBuilder.requires(jmxCapability));
            }
            Optional<Supplier<SecurityDomain>> elytronSecurityDomain = Optional.empty();
            if (configuration.isSecurityEnabled()) {
                String elytronSecurityDomainName = ServerDefinition.ELYTRON_DOMAIN.resolveModelAttribute(context, model).asStringOrNull();
                if (elytronSecurityDomainName != null) {
                    elytronSecurityDomain = Optional.of(serviceBuilder.requiresCapability("org.wildfly.security.security-domain", SecurityDomain.class, new String[]{elytronSecurityDomainName}));
                } else {
                    String legacySecurityDomain = ServerDefinition.SECURITY_DOMAIN.resolveModelAttribute(context, model).asStringOrNull();
                    if (legacySecurityDomain == null) {
                        throw MessagingLogger.ROOT_LOGGER.securityEnabledWithoutDomain();
                    }
                    throw MessagingLogger.ROOT_LOGGER.legacySecurityUnsupported();
                }
            }
            List<Interceptor> incomingInterceptors = this.processInterceptors(CommonAttributes.INCOMING_INTERCEPTORS.resolveModelAttribute(context, operation));
            List<Interceptor> outgoingInterceptors = this.processInterceptors(CommonAttributes.OUTGOING_INTERCEPTORS.resolveModelAttribute(context, operation));
            HashSet<String> socketBindingNames = new HashSet<String>();
            HashMap<String, String> sslContextNames = new HashMap<String, String>();
            TransportConfigOperationHandlers.processAcceptors(context, configuration, model, socketBindingNames, sslContextNames);
            HashMap<String, Supplier<SocketBinding>> socketBindings = new HashMap<String, Supplier<SocketBinding>>();
            for (String socketBindingName : socketBindingNames) {
                Supplier socketBinding = serviceBuilder.requiresCapability("org.wildfly.network.socket-binding", SocketBinding.class, new String[]{socketBindingName});
                socketBindings.put(socketBindingName, socketBinding);
            }
            HashSet<String> connectorsSocketBindings = new HashSet<String>();
            configuration.setConnectorConfigurations(TransportConfigOperationHandlers.processConnectors(context, configuration.getName(), model, connectorsSocketBindings, sslContextNames));
            HashMap<String, Supplier<SSLContext>> sslContexts = new HashMap<String, Supplier<SSLContext>>();
            for (Map.Entry entry : sslContextNames.entrySet()) {
                Supplier sslContext = serviceBuilder.requiresCapability("org.wildfly.security.ssl-context", SSLContext.class, new String[]{(String)entry.getValue()});
                sslContexts.put((String)entry.getValue(), sslContext);
            }
            HashMap<String, Supplier<OutboundSocketBinding>> outboundSocketBindings = new HashMap<String, Supplier<OutboundSocketBinding>>();
            Map<String, Boolean> map = TransportConfigOperationHandlers.listOutBoundSocketBinding(context, connectorsSocketBindings);
            for (String string : connectorsSocketBindings) {
                if (map.get(string).booleanValue()) {
                    ServiceName outboundSocketName = Capabilities.OUTBOUND_SOCKET_BINDING_CAPABILITY.getCapabilityServiceName(new String[]{string});
                    Supplier outboundSocketBinding = serviceBuilder.requiresCapability("org.wildfly.network.outbound-socket-binding", OutboundSocketBinding.class, new String[]{string});
                    outboundSocketBindings.put(string, outboundSocketBinding);
                    continue;
                }
                if (socketBindings.containsKey(string)) continue;
                Supplier socketBinding = serviceBuilder.requiresCapability("org.wildfly.network.socket-binding", SocketBinding.class, new String[]{string});
                socketBindings.put(string, socketBinding);
            }
            HashSet<String> httpListeners = new HashSet<String>();
            if (model.hasDefined("http-acceptor")) {
                for (Property property : model.get("http-acceptor").asPropertyList()) {
                    String httpListener = HTTPAcceptorDefinition.HTTP_LISTENER.resolveModelAttribute(context, property.getValue()).asString();
                    httpListeners.add(httpListener);
                }
            }
            for (String httpListener : httpListeners) {
                serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.undertow.listener.http-upgrade-registry", httpListener, ChannelUpgradeHandler.class));
            }
            BroadcastGroupAdd.addBroadcastGroupConfigs(context, configuration.getBroadcastGroupConfigurations(), configuration.getConnectorConfigurations().keySet(), model);
            List list = configuration.getBroadcastGroupConfigurations();
            Map discoveryGroupConfigurations = configuration.getDiscoveryGroupConfigurations();
            HashMap<String, String> clusterNames = new HashMap<String, String>();
            HashMap<String, Supplier<BroadcastCommandDispatcherFactory>> commandDispatcherFactories = new HashMap<String, Supplier<BroadcastCommandDispatcherFactory>>();
            HashMap<String, Supplier<SocketBinding>> groupBindings = new HashMap<String, Supplier<SocketBinding>>();
            HashMap<ServiceName, Supplier> groupBindingServices = new HashMap<ServiceName, Supplier>();
            if (list != null) {
                for (BroadcastGroupConfiguration config : list) {
                    name = config.getName();
                    key = "broadcast" + name;
                    if (model.hasDefined(new String[]{"jgroups-broadcast-group", name})) {
                        ModelNode broadcastGroupModel = model.get(new String[]{"jgroups-broadcast-group", name});
                        channelName = JGroupsBroadcastGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, broadcastGroupModel).asStringOrNull();
                        ServerAdd.this.broadcastCommandDispatcherFactoryInstaller.accept(context, channelName);
                        commandDispatcherFactories.put(key, serviceBuilder.requires(MessagingServices.getBroadcastCommandDispatcherFactoryServiceName(channelName)));
                        clusterName = CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, broadcastGroupModel).asString();
                        clusterNames.put(key, clusterName);
                        continue;
                    }
                    groupBindingServiceName = GroupBindingService.getBroadcastBaseServiceName(activeMQServiceName).append(new String[]{name});
                    if (!groupBindingServices.containsKey(groupBindingServiceName)) {
                        groupBinding = serviceBuilder.requires(groupBindingServiceName);
                        groupBindingServices.put(groupBindingServiceName, groupBinding);
                    }
                    groupBindings.put(key, (Supplier)groupBindingServices.get(groupBindingServiceName));
                }
            }
            if (discoveryGroupConfigurations != null) {
                for (BroadcastGroupConfiguration config : discoveryGroupConfigurations.values()) {
                    name = config.getName();
                    key = "discovery" + name;
                    if (model.hasDefined(new String[]{"jgroups-discovery-group", name})) {
                        ModelNode discoveryGroupModel = model.get(new String[]{"jgroups-discovery-group", name});
                        channelName = JGroupsDiscoveryGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, discoveryGroupModel).asStringOrNull();
                        ServerAdd.this.broadcastCommandDispatcherFactoryInstaller.accept(context, channelName);
                        commandDispatcherFactories.put(key, serviceBuilder.requires(MessagingServices.getBroadcastCommandDispatcherFactoryServiceName(channelName)));
                        clusterName = CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, discoveryGroupModel).asString();
                        clusterNames.put(key, clusterName);
                        continue;
                    }
                    groupBindingServiceName = GroupBindingService.getDiscoveryBaseServiceName(activeMQServiceName).append(new String[]{name});
                    if (!groupBindingServices.containsKey(groupBindingServiceName)) {
                        groupBinding = serviceBuilder.requires(groupBindingServiceName);
                        groupBindingServices.put(groupBindingServiceName, groupBinding);
                    }
                    groupBindings.put(key, (Supplier)groupBindingServices.get(groupBindingServiceName));
                }
            }
            ActiveMQServerService serverService = new ActiveMQServerService(configuration, new ActiveMQServerService.PathConfig(bindingsPath, bindingsRelativeToPath, journalPath, journalRelativeToPath, largeMessagePath, largeMessageRelativeToPath, pagingPath, pagingRelativeToPath), pathManager, incomingInterceptors, outgoingInterceptors, socketBindings, outboundSocketBindings, groupBindings, commandDispatcherFactories, clusterNames, elytronSecurityDomain, mbeanServer, dataSource, sslContexts);
            this.addBridgeCredentialStoreReference(serverService, configuration, BridgeDefinition.CREDENTIAL_REFERENCE, context, model, (ServiceBuilder<?>)serviceBuilder);
            this.addClusterCredentialStoreReference(serverService, ServerDefinition.CREDENTIAL_REFERENCE, context, model, (ServiceBuilder<?>)serviceBuilder);
            ServiceController activeMQServerServiceController = serviceBuilder.setInstance((Service)serverService).install();
            if (model.hasDefined("queue")) {
                ModelNode coreQueues = model.get("queue");
                for (CoreQueueConfiguration queueConfiguration : configuration.getQueueConfigurations()) {
                    if (!coreQueues.has(queueConfiguration.getName())) continue;
                    ServiceName queueServiceName = activeMQServiceName.append(new String[]{queueConfiguration.getName()});
                    ServiceBuilder sb = context.getServiceTarget().addService(queueServiceName);
                    sb.requires(ActiveMQActivationService.getServiceName(activeMQServiceName));
                    Supplier serverSupplier = sb.requires(activeMQServiceName);
                    QueueService queueService = new QueueService(serverSupplier, queueConfiguration, false, false);
                    sb.setInitialMode(ServiceController.Mode.PASSIVE);
                    sb.setInstance((Service)queueService);
                    sb.install();
                }
            }
            ((ActiveMQServerResource)this.resource).setActiveMQServerServiceController((ServiceController<ActiveMQBroker>)activeMQServerServiceController);
            boolean overrideInVMSecurity = ServerDefinition.OVERRIDE_IN_VM_SECURITY.resolveModelAttribute(context, operation).asBoolean();
            JMSService.addService((ServiceTarget)capabilityServiceTarget, activeMQServiceName, overrideInVMSecurity);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }

        private void processStorageConfiguration(OperationContext context, ModelNode model, Configuration configuration) throws OperationFailedException {
            ModelNode journalDataSource = ServerDefinition.JOURNAL_DATASOURCE.resolveModelAttribute(context, model);
            if (!journalDataSource.isDefined()) {
                return;
            }
            DatabaseStorageConfiguration storageConfiguration = new DatabaseStorageConfiguration();
            storageConfiguration.setBindingsTableName(ServerDefinition.JOURNAL_BINDINGS_TABLE.resolveModelAttribute(context, model).asString());
            storageConfiguration.setMessageTableName(ServerDefinition.JOURNAL_MESSAGES_TABLE.resolveModelAttribute(context, model).asString());
            storageConfiguration.setLargeMessageTableName(ServerDefinition.JOURNAL_LARGE_MESSAGES_TABLE.resolveModelAttribute(context, model).asString());
            storageConfiguration.setPageStoreTableName(ServerDefinition.JOURNAL_PAGE_STORE_TABLE.resolveModelAttribute(context, model).asString());
            long networkTimeout = TimeUnit.SECONDS.toMillis(ServerDefinition.JOURNAL_JDBC_NETWORK_TIMEOUT.resolveModelAttribute(context, model).asInt());
            storageConfiguration.setJdbcNetworkTimeout((int)networkTimeout);
            String nodeManagerStoreTableName = model.hasDefined(ServerDefinition.JOURNAL_NODE_MANAGER_STORE_TABLE.getName()) ? ServerDefinition.JOURNAL_NODE_MANAGER_STORE_TABLE.resolveModelAttribute(context, model).asString() : (WildFlySecurityManager.getSystemPropertiesPrivileged().containsKey(ServerAdd.ARTEMIS_BROKER_CONFIG_NODEMANAGER_STORE_TABLE_NAME) ? WildFlySecurityManager.getSystemPropertiesPrivileged().getProperty(ServerAdd.ARTEMIS_BROKER_CONFIG_NODEMANAGER_STORE_TABLE_NAME) : ServerDefinition.JOURNAL_NODE_MANAGER_STORE_TABLE.getDefaultValue().asString());
            WildFlySecurityManager.getSystemPropertiesPrivileged().remove(ServerAdd.ARTEMIS_BROKER_CONFIG_NODEMANAGER_STORE_TABLE_NAME);
            storageConfiguration.setNodeManagerStoreTableName(nodeManagerStoreTableName);
            long lockExpirationInMillis = model.hasDefined(ServerDefinition.JOURNAL_JDBC_LOCK_EXPIRATION.getName()) ? TimeUnit.SECONDS.toMillis(ServerDefinition.JOURNAL_JDBC_LOCK_EXPIRATION.resolveModelAttribute(context, model).asInt()) : (WildFlySecurityManager.getSystemPropertiesPrivileged().containsKey(ServerAdd.ARTEMIS_BROKER_CONFIG_JBDC_LOCK_EXPIRATION_MILLIS) ? Long.parseLong(WildFlySecurityManager.getSystemPropertiesPrivileged().getProperty(ServerAdd.ARTEMIS_BROKER_CONFIG_JBDC_LOCK_EXPIRATION_MILLIS)) : TimeUnit.SECONDS.toMillis(ServerDefinition.JOURNAL_JDBC_LOCK_EXPIRATION.getDefaultValue().asInt()));
            WildFlySecurityManager.getSystemPropertiesPrivileged().remove(ServerAdd.ARTEMIS_BROKER_CONFIG_JBDC_LOCK_EXPIRATION_MILLIS);
            storageConfiguration.setJdbcLockExpirationMillis(lockExpirationInMillis);
            long lockRenewPeriodInMillis = model.hasDefined(ServerDefinition.JOURNAL_JDBC_LOCK_RENEW_PERIOD.getName()) ? TimeUnit.SECONDS.toMillis(ServerDefinition.JOURNAL_JDBC_LOCK_RENEW_PERIOD.resolveModelAttribute(context, model).asInt()) : (WildFlySecurityManager.getSystemPropertiesPrivileged().containsKey(ServerAdd.ARTEMIS_BROKER_CONFIG_JBDC_LOCK_RENEW_PERIOD_MILLIS) ? Long.parseLong(WildFlySecurityManager.getSystemPropertiesPrivileged().getProperty(ServerAdd.ARTEMIS_BROKER_CONFIG_JBDC_LOCK_RENEW_PERIOD_MILLIS)) : TimeUnit.SECONDS.toMillis(ServerDefinition.JOURNAL_JDBC_LOCK_RENEW_PERIOD.getDefaultValue().asInt()));
            WildFlySecurityManager.getSystemPropertiesPrivileged().remove(ServerAdd.ARTEMIS_BROKER_CONFIG_JBDC_LOCK_RENEW_PERIOD_MILLIS);
            storageConfiguration.setJdbcLockRenewPeriodMillis(lockRenewPeriodInMillis);
            long jdbcLockAcquisitionTimeoutMillis = WildFlySecurityManager.getSystemPropertiesPrivileged().containsKey(ServerAdd.ARTEMIS_BROKER_CONFIG_JDBC_LOCK_ACQUISITION_TIMEOUT_MILLIS) ? Long.parseLong(WildFlySecurityManager.getSystemPropertiesPrivileged().getProperty(ServerAdd.ARTEMIS_BROKER_CONFIG_JDBC_LOCK_ACQUISITION_TIMEOUT_MILLIS)) : -1L;
            WildFlySecurityManager.getSystemPropertiesPrivileged().remove(ServerAdd.ARTEMIS_BROKER_CONFIG_JDBC_LOCK_ACQUISITION_TIMEOUT_MILLIS);
            storageConfiguration.setJdbcLockAcquisitionTimeoutMillis(jdbcLockAcquisitionTimeoutMillis);
            configuration.setStoreConfiguration((StoreConfiguration)storageConfiguration);
        }

        private Configuration transformConfig(OperationContext context, String serverName, ModelNode model) throws OperationFailedException {
            ConfigurationImpl configuration = new ConfigurationImpl();
            configuration.setName(serverName);
            configuration.setConfigurationFileRefreshPeriod(-1L);
            configuration.setAddressQueueScanPeriod(ServerDefinition.ADDRESS_QUEUE_SCAN_PERIOD.resolveModelAttribute(context, model).asLong());
            configuration.setEnabledAsyncConnectionExecution(ServerDefinition.ASYNC_CONNECTION_EXECUTION_ENABLED.resolveModelAttribute(context, model).asBoolean());
            configuration.setClusterPassword(ServerDefinition.CLUSTER_PASSWORD.resolveModelAttribute(context, model).asString());
            configuration.setClusterUser(ServerDefinition.CLUSTER_USER.resolveModelAttribute(context, model).asString());
            configuration.setConnectionTTLOverride((long)ServerDefinition.CONNECTION_TTL_OVERRIDE.resolveModelAttribute(context, model).asInt());
            configuration.setCreateBindingsDir(ServerDefinition.CREATE_BINDINGS_DIR.resolveModelAttribute(context, model).asBoolean());
            configuration.setCreateJournalDir(ServerDefinition.CREATE_JOURNAL_DIR.resolveModelAttribute(context, model).asBoolean());
            configuration.setGlobalMaxSize(ServerDefinition.GLOBAL_MAX_MEMORY_SIZE.resolveModelAttribute(context, model).asLong());
            configuration.setMaxDiskUsage(ServerDefinition.GLOBAL_MAX_DISK_USAGE.resolveModelAttribute(context, model).asInt());
            configuration.setDiskScanPeriod(ServerDefinition.DISK_SCAN_PERIOD.resolveModelAttribute(context, model).asInt());
            configuration.setIDCacheSize(ServerDefinition.ID_CACHE_SIZE.resolveModelAttribute(context, model).asInt());
            configuration.setJMXDomain(ServerDefinition.JMX_DOMAIN.resolveModelAttribute(context, model).asString());
            configuration.setJMXManagementEnabled(ServerDefinition.JMX_MANAGEMENT_ENABLED.resolveModelAttribute(context, model).asBoolean());
            JournalType journalType = JournalType.valueOf((String)ServerDefinition.JOURNAL_TYPE.resolveModelAttribute(context, model).asString());
            configuration.setJournalType(journalType);
            ModelNode value = ServerDefinition.JOURNAL_BUFFER_SIZE.resolveModelAttribute(context, model);
            if (value.isDefined()) {
                configuration.setJournalBufferSize_AIO(value.asInt());
                configuration.setJournalBufferSize_NIO(value.asInt());
            }
            if ((value = ServerDefinition.JOURNAL_BUFFER_TIMEOUT.resolveModelAttribute(context, model)).isDefined()) {
                configuration.setJournalBufferTimeout_AIO(value.asInt());
                configuration.setJournalBufferTimeout_NIO(value.asInt());
            }
            if ((value = ServerDefinition.JOURNAL_MAX_IO.resolveModelAttribute(context, model)).isDefined()) {
                configuration.setJournalMaxIO_AIO(value.asInt());
                configuration.setJournalMaxIO_NIO(value.asInt());
            }
            configuration.setJournalCompactMinFiles(ServerDefinition.JOURNAL_COMPACT_MIN_FILES.resolveModelAttribute(context, model).asInt());
            configuration.setJournalCompactPercentage(ServerDefinition.JOURNAL_COMPACT_PERCENTAGE.resolveModelAttribute(context, model).asInt());
            configuration.setJournalFileSize(ServerDefinition.JOURNAL_FILE_SIZE.resolveModelAttribute(context, model).asInt());
            configuration.setJournalMinFiles(ServerDefinition.JOURNAL_MIN_FILES.resolveModelAttribute(context, model).asInt());
            configuration.setJournalPoolFiles(ServerDefinition.JOURNAL_POOL_FILES.resolveModelAttribute(context, model).asInt());
            configuration.setJournalFileOpenTimeout(ServerDefinition.JOURNAL_FILE_OPEN_TIMEOUT.resolveModelAttribute(context, model).asInt());
            configuration.setJournalSyncNonTransactional(ServerDefinition.JOURNAL_SYNC_NON_TRANSACTIONAL.resolveModelAttribute(context, model).asBoolean());
            configuration.setJournalSyncTransactional(ServerDefinition.JOURNAL_SYNC_TRANSACTIONAL.resolveModelAttribute(context, model).asBoolean());
            configuration.setJournalMaxAtticFiles(ServerDefinition.JOURNAL_MAX_ATTIC_FILES.resolveModelAttribute(context, model).asInt());
            configuration.setLogJournalWriteRate(ServerDefinition.LOG_JOURNAL_WRITE_RATE.resolveModelAttribute(context, model).asBoolean());
            configuration.setManagementAddress(SimpleString.toSimpleString((String)ServerDefinition.MANAGEMENT_ADDRESS.resolveModelAttribute(context, model).asString()));
            configuration.setManagementNotificationAddress(SimpleString.toSimpleString((String)ServerDefinition.MANAGEMENT_NOTIFICATION_ADDRESS.resolveModelAttribute(context, model).asString()));
            configuration.setMemoryMeasureInterval(ServerDefinition.MEMORY_MEASURE_INTERVAL.resolveModelAttribute(context, model).asLong());
            configuration.setMemoryWarningThreshold(ServerDefinition.MEMORY_WARNING_THRESHOLD.resolveModelAttribute(context, model).asInt());
            configuration.setMessageCounterEnabled(ServerDefinition.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean());
            configuration.setMessageCounterSamplePeriod((long)ServerDefinition.MESSAGE_COUNTER_SAMPLE_PERIOD.resolveModelAttribute(context, model).asInt());
            configuration.setMessageCounterMaxDayHistory(ServerDefinition.MESSAGE_COUNTER_MAX_DAY_HISTORY.resolveModelAttribute(context, model).asInt());
            configuration.setMessageExpiryScanPeriod(ServerDefinition.MESSAGE_EXPIRY_SCAN_PERIOD.resolveModelAttribute(context, model).asLong());
            configuration.setMessageExpiryThreadPriority(ServerDefinition.MESSAGE_EXPIRY_THREAD_PRIORITY.resolveModelAttribute(context, model).asInt());
            configuration.setPersistDeliveryCountBeforeDelivery(ServerDefinition.PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY.resolveModelAttribute(context, model).asBoolean());
            configuration.setPageMaxConcurrentIO(ServerDefinition.PAGE_MAX_CONCURRENT_IO.resolveModelAttribute(context, model).asInt());
            configuration.setPersistenceEnabled(ServerDefinition.PERSISTENCE_ENABLED.resolveModelAttribute(context, model).asBoolean());
            configuration.setPersistIDCache(ServerDefinition.PERSIST_ID_CACHE.resolveModelAttribute(context, model).asBoolean());
            configuration.setScheduledThreadPoolMaxSize(ServerDefinition.SCHEDULED_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
            configuration.setSecurityEnabled(ServerDefinition.SECURITY_ENABLED.resolveModelAttribute(context, model).asBoolean());
            configuration.setSecurityInvalidationInterval(ServerDefinition.SECURITY_INVALIDATION_INTERVAL.resolveModelAttribute(context, model).asLong());
            configuration.setServerDumpInterval(ServerDefinition.SERVER_DUMP_INTERVAL.resolveModelAttribute(context, model).asLong());
            configuration.setThreadPoolMaxSize(ServerDefinition.THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
            configuration.setTransactionTimeout(ServerDefinition.TRANSACTION_TIMEOUT.resolveModelAttribute(context, model).asLong());
            configuration.setTransactionTimeoutScanPeriod(ServerDefinition.TRANSACTION_TIMEOUT_SCAN_PERIOD.resolveModelAttribute(context, model).asLong());
            configuration.getWildcardConfiguration().setRoutingEnabled(ServerDefinition.WILD_CARD_ROUTING_ENABLED.resolveModelAttribute(context, model).asBoolean());
            if (model.hasDefined(ServerDefinition.NETWORK_CHECK_NIC.getName()) || model.hasDefined(ServerDefinition.NETWORK_CHECK_PERIOD.getName()) || model.hasDefined(ServerDefinition.NETWORK_CHECK_TIMEOUT.getName()) || model.hasDefined(ServerDefinition.NETWORK_CHECK_LIST.getName()) || model.hasDefined(ServerDefinition.NETWORK_CHECK_URL_LIST.getName()) || model.hasDefined(ServerDefinition.NETWORK_CHECK_PING_COMMAND.getName()) || model.hasDefined(ServerDefinition.NETWORK_CHECK_PING6_COMMAND.getName())) {
                configuration.setNetworCheckNIC(ServerDefinition.NETWORK_CHECK_NIC.resolveModelAttribute(context, model).asStringOrNull());
                configuration.setNetworkCheckList(ServerDefinition.NETWORK_CHECK_LIST.resolveModelAttribute(context, model).asStringOrNull());
                configuration.setNetworkCheckPeriod(ServerDefinition.NETWORK_CHECK_PERIOD.resolveModelAttribute(context, model).asLong());
                configuration.setNetworkCheckPing6Command(ServerDefinition.NETWORK_CHECK_PING6_COMMAND.resolveModelAttribute(context, model).asString());
                configuration.setNetworkCheckPingCommand(ServerDefinition.NETWORK_CHECK_PING_COMMAND.resolveModelAttribute(context, model).asString());
                configuration.setNetworkCheckTimeout(ServerDefinition.NETWORK_CHECK_TIMEOUT.resolveModelAttribute(context, model).asInt());
                configuration.setNetworkCheckURLList(ServerDefinition.NETWORK_CHECK_URL_LIST.resolveModelAttribute(context, model).asStringOrNull());
            }
            configuration.setCriticalAnalyzer(ServerDefinition.CRITICAL_ANALYZER_ENABLED.resolveModelAttribute(context, model).asBoolean());
            configuration.setCriticalAnalyzerCheckPeriod(ServerDefinition.CRITICAL_ANALYZER_CHECK_PERIOD.resolveModelAttribute(context, model).asLong());
            configuration.setCriticalAnalyzerPolicy(CriticalAnalyzerPolicy.valueOf((String)ServerDefinition.CRITICAL_ANALYZER_POLICY.resolveModelAttribute(context, model).asString()));
            configuration.setCriticalAnalyzerTimeout(ServerDefinition.CRITICAL_ANALYZER_TIMEOUT.resolveModelAttribute(context, model).asLong());
            this.processStorageConfiguration(context, model, (Configuration)configuration);
            HAPolicyConfigurationBuilder.getInstance().addHAPolicyConfiguration(context, (Configuration)configuration, model);
            this.processAddressSettings(context, (Configuration)configuration, model);
            this.processSecuritySettings(context, (Configuration)configuration, model);
            ConfigurationHelper.addGroupingHandlerConfiguration(context, (Configuration)configuration, model);
            configuration.setDiscoveryGroupConfigurations(ConfigurationHelper.addDiscoveryGroupConfigurations(context, model));
            ConfigurationHelper.addDivertConfigurations(context, (Configuration)configuration, model);
            ConfigurationHelper.addQueueConfigurations(context, (Configuration)configuration, model);
            ConfigurationHelper.addBridgeConfigurations(context, (Configuration)configuration, model);
            ConfigurationHelper.addClusterConnectionConfigurations(context, (Configuration)configuration, model);
            ConfigurationHelper.addConnectorServiceConfigurations(context, (Configuration)configuration, model);
            return configuration;
        }

        private void processAddressSettings(OperationContext context, Configuration configuration, ModelNode params) throws OperationFailedException {
            boolean merged = false;
            if (params.hasDefined("address-setting")) {
                for (Property property : params.get("address-setting").asPropertyList()) {
                    String match = property.getName();
                    ModelNode config = property.getValue();
                    boolean isRootAddressMatch = configuration.getWildcardConfiguration().getAnyWordsString().equals(match);
                    AddressSettings settings = AddressSettingAdd.createSettings(context, config, isRootAddressMatch);
                    if (!merged && isRootAddressMatch) {
                        settings.merge(AddressSettingAdd.createDefaulAddressSettings());
                        merged = true;
                    }
                    configuration.addAddressSetting(match, settings);
                }
                if (!merged) {
                    configuration.addAddressSetting(configuration.getWildcardConfiguration().getAnyWordsString(), AddressSettingAdd.createDefaulAddressSettings());
                }
            }
        }

        private List<Class> unwrapClasses(List<ModelNode> classesModel) throws OperationFailedException {
            ArrayList<Class> classes = new ArrayList<Class>();
            for (ModelNode classModel : classesModel) {
                Class clazz = this.unwrapClass(classModel);
                classes.add(clazz);
            }
            return classes;
        }

        private Class unwrapClass(ModelNode classModel) throws OperationFailedException {
            String className = classModel.get("name").asString();
            String moduleName = classModel.get("module").asString();
            try {
                ModuleIdentifier moduleID = ModuleIdentifier.fromString((String)moduleName);
                Module module = Module.getCallerModuleLoader().loadModule(moduleID);
                Class clazz = module.getClassLoader().loadClass(className);
                return clazz;
            }
            catch (Exception e) {
                throw MessagingLogger.ROOT_LOGGER.unableToLoadClassFromModule(className, moduleName);
            }
        }

        private List<Interceptor> processInterceptors(ModelNode model) throws OperationFailedException {
            if (!model.isDefined()) {
                return Collections.emptyList();
            }
            ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
            List interceptorModels = model.asList();
            for (Class clazz : this.unwrapClasses(interceptorModels)) {
                try {
                    Interceptor interceptor = (Interceptor)Interceptor.class.cast(clazz.newInstance());
                    interceptors.add(interceptor);
                }
                catch (Exception e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
            return interceptors;
        }

        private void processSecuritySettings(OperationContext context, Configuration configuration, ModelNode params) throws OperationFailedException {
            if (params.get("security-setting").isDefined()) {
                for (Property property : params.get("security-setting").asPropertyList()) {
                    String match = property.getName();
                    ModelNode config = property.getValue();
                    if (!config.hasDefined("role")) continue;
                    HashSet<Role> roles = new HashSet<Role>();
                    for (Property role : config.get("role").asPropertyList()) {
                        roles.add(SecurityRoleDefinition.transform(context, role.getName(), role.getValue()));
                    }
                    configuration.getSecurityRoles().put(match, roles);
                }
            }
        }

        private void addBridgeCredentialStoreReference(ActiveMQServerService amqService, Configuration configuration, ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition, OperationContext context, ModelNode model, ServiceBuilder<?> serviceBuilder) throws OperationFailedException {
            for (BridgeConfiguration bridgeConfiguration : configuration.getBridgeConfigurations()) {
                ModelNode value;
                String name = bridgeConfiguration.getName();
                InjectedValue<ExceptionSupplier<CredentialSource, Exception>> injector = amqService.getBridgeCredentialSourceSupplierInjector(name);
                String[] modelFilter = new String[]{"bridge", name};
                ModelNode filteredModelNode = model;
                if (modelFilter != null && modelFilter.length > 0) {
                    for (String path : modelFilter) {
                        if (!filteredModelNode.get(path).isDefined()) break;
                        filteredModelNode = filteredModelNode.get(path);
                    }
                }
                if (!(value = credentialReferenceAttributeDefinition.resolveModelAttribute(context, filteredModelNode)).isDefined()) continue;
                injector.inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)credentialReferenceAttributeDefinition, (ModelNode)filteredModelNode, serviceBuilder));
            }
        }

        private void addClusterCredentialStoreReference(ActiveMQServerService amqService, ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition, OperationContext context, ModelNode model, ServiceBuilder<?> serviceBuilder) throws OperationFailedException {
            ModelNode value = credentialReferenceAttributeDefinition.resolveModelAttribute(context, model);
            if (value.isDefined()) {
                amqService.getClusterCredentialSourceSupplierInjector().inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)credentialReferenceAttributeDefinition, (ModelNode)model, serviceBuilder));
            }
        }
    }
}

