/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LoginConfig;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.web.container.SecurityDomainSingleSignOnManagementConfiguration;
import org.wildfly.clustering.web.container.SecurityDomainSingleSignOnManagementProvider;
import org.wildfly.elytron.web.undertow.server.servlet.AuthenticationManager;
import org.wildfly.extension.undertow.ApplicationSecurityDomainSingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnManagerServiceNameProvider;
import org.wildfly.extension.undertow.SingleSignOnSessionFactoryServiceConfigurator;
import org.wildfly.extension.undertow.SingleSignOnSessionFactoryServiceNameProvider;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.security.jacc.JACCAuthorizationManager;
import org.wildfly.extension.undertow.sso.elytron.NonDistributableSingleSignOnManagementProvider;
import org.wildfly.extension.undertow.sso.elytron.SingleSignOnIdentifierFactory;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.basic.BasicMechanismFactory;
import org.wildfly.security.http.bearer.BearerMechanismFactory;
import org.wildfly.security.http.cert.ClientCertMechanismFactory;
import org.wildfly.security.http.digest.DigestMechanismFactory;
import org.wildfly.security.http.external.ExternalMechanismFactory;
import org.wildfly.security.http.form.FormMechanismFactory;
import org.wildfly.security.http.spnego.SpnegoMechanismFactory;
import org.wildfly.security.http.util.AggregateServerMechanismFactory;
import org.wildfly.security.http.util.FilterServerMechanismFactory;
import org.wildfly.security.http.util.sso.ProgrammaticSingleSignOnCache;
import org.wildfly.security.http.util.sso.SingleSignOnConfiguration;
import org.wildfly.security.http.util.sso.SingleSignOnServerMechanismFactory;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ApplicationSecurityDomainDefinition
extends PersistentResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"application-security-domain");
    private static final Predicate<String> SERVLET_MECHANISM;
    static final RuntimeCapability<Void> APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY;
    static final SimpleAttributeDefinition HTTP_AUTHENTICATION_FACTORY;
    static final SimpleAttributeDefinition OVERRIDE_DEPLOYMENT_CONFIG;
    static final SimpleAttributeDefinition SECURITY_DOMAIN;
    private static final StringListAttributeDefinition REFERENCING_DEPLOYMENTS;
    static final SimpleAttributeDefinition ENABLE_JACC;
    static final SimpleAttributeDefinition ENABLE_JASPI;
    static final SimpleAttributeDefinition INTEGRATED_JASPI;
    static final Collection<AttributeDefinition> ATTRIBUTES;
    private static final OperationContext.AttachmentKey<KnownDeploymentsApi> KNOWN_DEPLOYMENTS_KEY;
    private final Set<String> knownApplicationSecurityDomains;

    ApplicationSecurityDomainDefinition(Set<String> knownApplicationSecurityDomains) {
        this(knownApplicationSecurityDomains, new AddHandler(knownApplicationSecurityDomains));
    }

    private ApplicationSecurityDomainDefinition(Set<String> knownApplicationSecurityDomains, AbstractAddStepHandler addHandler) {
        super(((SimpleResourceDefinition.Parameters)new SimpleResourceDefinition.Parameters(PATH_ELEMENT, (ResourceDescriptionResolver)UndertowExtension.getResolver(PATH_ELEMENT.getKey())).setCapabilities(new RuntimeCapability[]{APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY}).addAccessConstraints(new AccessConstraintDefinition[]{new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("undertow", "application-security-domain", false, false, false)), new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("undertow", "application-security-domain"))})).setAddHandler((OperationStepHandler)addHandler).setRemoveHandler((OperationStepHandler)new RemoveHandler(knownApplicationSecurityDomains, addHandler)));
        this.knownApplicationSecurityDomains = knownApplicationSecurityDomains;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        if (resourceRegistration.getProcessType().isServer()) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)REFERENCING_DEPLOYMENTS, (OperationStepHandler)new ReferencingDeploymentsHandler());
        }
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Collections.singletonList(new ApplicationSecurityDomainSingleSignOnDefinition());
    }

    private static HttpAuthenticationFactory toHttpAuthenticationFactory(SecurityDomain securityDomain, String realmName) {
        FilterServerMechanismFactory mechanismFactory = new FilterServerMechanismFactory((HttpServerAuthenticationMechanismFactory)new AggregateServerMechanismFactory(new HttpServerAuthenticationMechanismFactory[]{new BasicMechanismFactory(), new BearerMechanismFactory(), new ClientCertMechanismFactory(), new DigestMechanismFactory(), new ExternalMechanismFactory(), new FormMechanismFactory(), new SpnegoMechanismFactory()}), SERVLET_MECHANISM);
        return HttpAuthenticationFactory.builder().setFactory((HttpServerAuthenticationMechanismFactory)mechanismFactory).setSecurityDomain(securityDomain).setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)(realmName == null ? MechanismConfiguration.EMPTY : MechanismConfiguration.builder().addMechanismRealm(MechanismRealmConfiguration.builder().setRealmName(realmName).build()).build()))).build();
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    Predicate<String> getKnownSecurityDomainPredicate() {
        return this.knownApplicationSecurityDomains::contains;
    }

    static {
        HashSet<String> defaultMechanisms = new HashSet<String>(4);
        defaultMechanisms.add("BASIC");
        defaultMechanisms.add("CLIENT_CERT");
        defaultMechanisms.add("DIGEST");
        defaultMechanisms.add("FORM");
        SERVLET_MECHANISM = defaultMechanisms::contains;
        APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.application-security-domain", (boolean)true, BiFunction.class).build();
        HTTP_AUTHENTICATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-authentication-factory", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.http-authentication-factory")).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.AUTHENTICATION_FACTORY_REF})).setAlternatives(new String[]{"security-domain"})).build();
        OVERRIDE_DEPLOYMENT_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("override-deployment-config", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).setRestartAllServices()).setRequires(new String[]{"http-authentication-factory"})).build();
        SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.security-domain")).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.ELYTRON_SECURITY_DOMAIN_REF})).setAlternatives(new String[]{"http-authentication-factory"})).build();
        REFERENCING_DEPLOYMENTS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("referencing-deployments").setStorageRuntime()).build();
        ENABLE_JACC = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-jacc", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).setMinSize(1)).setRestartAllServices()).build();
        ENABLE_JASPI = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-jaspi", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).setRestartAllServices()).build();
        INTEGRATED_JASPI = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("integrated-jaspi", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).setRestartAllServices()).build();
        ATTRIBUTES = List.of(SECURITY_DOMAIN, HTTP_AUTHENTICATION_FACTORY, OVERRIDE_DEPLOYMENT_CONFIG, ENABLE_JACC, ENABLE_JASPI, INTEGRATED_JASPI);
        KNOWN_DEPLOYMENTS_KEY = OperationContext.AttachmentKey.create(KnownDeploymentsApi.class);
    }

    private static class AddHandler
    extends AbstractAddStepHandler {
        private final Set<String> knownApplicationSecurityDomains;
        private final SecurityDomainSingleSignOnManagementProvider provider;

        private AddHandler(Set<String> knownApplicationSecurityDomains) {
            this.knownApplicationSecurityDomains = knownApplicationSecurityDomains;
            Iterator<SecurityDomainSingleSignOnManagementProvider> providers = ServiceLoader.load(SecurityDomainSingleSignOnManagementProvider.class, SecurityDomainSingleSignOnManagementProvider.class.getClassLoader()).iterator();
            this.provider = providers.hasNext() ? providers.next() : NonDistributableSingleSignOnManagementProvider.INSTANCE;
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            this.knownApplicationSecurityDomains.add(context.getCurrentAddressValue());
        }

        protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.recordCapabilitiesAndRequirements(context, operation, resource);
            KnownDeploymentsApi knownDeployments = new KnownDeploymentsApi();
            context.registerCapability(RuntimeCapability.Builder.of((String)"org.wildfly.undertow.application-security-domain.known-deployments", (boolean)true, (Object)knownDeployments).build().fromBaseCapability(context.getCurrentAddressValue()));
            context.attach(KNOWN_DEPLOYMENTS_KEY, (Object)knownDeployments);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            Supplier<UnaryOperator<HttpServerAuthenticationMechanismFactory>> transformerSupplier;
            BiFunction<HttpExchangeSpi, String, IdentityCache> identityCacheSupplier;
            Supplier securityDomainSupplier;
            Supplier httpAuthenticationFactorySupplier;
            ModelNode model = resource.getModel();
            CapabilityServiceTarget target = context.getCapabilityServiceTarget();
            String securityDomain = SECURITY_DOMAIN.resolveModelAttribute(context, model).asStringOrNull();
            String httpServerMechanismFactory = HTTP_AUTHENTICATION_FACTORY.resolveModelAttribute(context, model).asStringOrNull();
            boolean overrideDeploymentConfig = OVERRIDE_DEPLOYMENT_CONFIG.resolveModelAttribute(context, model).asBoolean();
            boolean enableJacc = ENABLE_JACC.resolveModelAttribute(context, model).asBoolean();
            boolean enableJaspi = ENABLE_JASPI.resolveModelAttribute(context, model).asBoolean();
            boolean integratedJaspi = INTEGRATED_JASPI.resolveModelAttribute(context, model).asBoolean();
            final String securityDomainName = context.getCurrentAddressValue();
            ServiceName applicationSecurityDomainName = APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress());
            ServiceName securityDomainServiceName = applicationSecurityDomainName.append(new String[]{"security-domain"});
            CapabilityServiceBuilder serviceBuilder = target.addService(applicationSecurityDomainName).setInitialMode(ServiceController.Mode.LAZY);
            if (httpServerMechanismFactory != null) {
                httpAuthenticationFactorySupplier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.http-authentication-factory", HttpAuthenticationFactory.class, new String[]{httpServerMechanismFactory}));
                securityDomainSupplier = null;
            } else {
                securityDomainSupplier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.security-domain", SecurityDomain.class, new String[]{securityDomain}));
                httpAuthenticationFactorySupplier = null;
            }
            if (resource.hasChild(SingleSignOnDefinition.PATH_ELEMENT)) {
                ModelNode ssoModel = resource.getChild(SingleSignOnDefinition.PATH_ELEMENT).getModel();
                String cookieName = SingleSignOnDefinition.Attribute.COOKIE_NAME.resolveModelAttribute((ExpressionResolver)context, ssoModel).asString();
                String domain = null;
                if (SingleSignOnDefinition.Attribute.DOMAIN.resolveModelAttribute((ExpressionResolver)context, ssoModel).isDefined()) {
                    domain = SingleSignOnDefinition.Attribute.DOMAIN.resolveModelAttribute((ExpressionResolver)context, ssoModel).asString();
                }
                String path = SingleSignOnDefinition.Attribute.PATH.resolveModelAttribute((ExpressionResolver)context, ssoModel).asString();
                boolean httpOnly = SingleSignOnDefinition.Attribute.HTTP_ONLY.resolveModelAttribute((ExpressionResolver)context, ssoModel).asBoolean();
                boolean secure = SingleSignOnDefinition.Attribute.SECURE.resolveModelAttribute((ExpressionResolver)context, ssoModel).asBoolean();
                SingleSignOnConfiguration singleSignOnConfiguration = new SingleSignOnConfiguration(cookieName, domain, path, httpOnly, secure);
                ServiceName managerServiceName = new SingleSignOnManagerServiceNameProvider(securityDomainName).getServiceName();
                final SingleSignOnIdentifierFactory generator = new SingleSignOnIdentifierFactory();
                SecurityDomainSingleSignOnManagementConfiguration configuration = new SecurityDomainSingleSignOnManagementConfiguration(){

                    public String getSecurityDomainName() {
                        return securityDomainName;
                    }

                    public Supplier<String> getIdentifierGenerator() {
                        return generator;
                    }
                };
                this.provider.getServiceConfigurator(managerServiceName, configuration).configure(context).build((ServiceTarget)target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                ServiceConfigurator factoryConfigurator = new SingleSignOnSessionFactoryServiceConfigurator(securityDomainName).configure(context, ssoModel);
                factoryConfigurator.build((ServiceTarget)target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                Supplier singleSignOnSessionFactorySupplier = serviceBuilder.requires(factoryConfigurator.getServiceName());
                UnaryOperator transformer = arg_0 -> AddHandler.lambda$performRuntime$0((Supplier)singleSignOnSessionFactorySupplier, singleSignOnConfiguration, arg_0);
                identityCacheSupplier = (arg_0, arg_1) -> AddHandler.lambda$performRuntime$1((Supplier)singleSignOnSessionFactorySupplier, singleSignOnConfiguration, arg_0, arg_1);
                transformerSupplier = () -> transformer;
            } else {
                identityCacheSupplier = null;
                transformerSupplier = () -> null;
            }
            Consumer deploymentConsumer = serviceBuilder.provides(new ServiceName[]{applicationSecurityDomainName});
            Consumer securityDomainConsumer = serviceBuilder.provides(new ServiceName[]{securityDomainServiceName});
            ApplicationSecurityDomainService service = new ApplicationSecurityDomainService(overrideDeploymentConfig, enableJacc, enableJaspi, integratedJaspi, httpAuthenticationFactorySupplier, securityDomainSupplier, transformerSupplier, identityCacheSupplier, deploymentConsumer, securityDomainConsumer);
            serviceBuilder.setInstance((Service)service);
            serviceBuilder.install();
            KnownDeploymentsApi knownDeploymentsApi = (KnownDeploymentsApi)context.getAttachment(KNOWN_DEPLOYMENTS_KEY);
            knownDeploymentsApi.setApplicationSecurityDomainService(service);
        }

        private static /* synthetic */ IdentityCache lambda$performRuntime$1(Supplier singleSignOnSessionFactorySupplier, SingleSignOnConfiguration singleSignOnConfiguration, HttpExchangeSpi httpExchangeSpi, String mechanismName) {
            return ProgrammaticSingleSignOnCache.newInstance((HttpExchangeSpi)httpExchangeSpi, (String)mechanismName, (SingleSignOnSessionFactory)((SingleSignOnSessionFactory)singleSignOnSessionFactorySupplier.get()), (SingleSignOnConfiguration)singleSignOnConfiguration);
        }

        private static /* synthetic */ HttpServerAuthenticationMechanismFactory lambda$performRuntime$0(Supplier singleSignOnSessionFactorySupplier, SingleSignOnConfiguration singleSignOnConfiguration, HttpServerAuthenticationMechanismFactory factory) {
            return new SingleSignOnServerMechanismFactory(factory, (SingleSignOnSessionFactory)singleSignOnSessionFactorySupplier.get(), singleSignOnConfiguration);
        }
    }

    private static class RemoveHandler
    extends ServiceRemoveStepHandler {
        private final Set<String> knownApplicationSecurityDomains;

        protected RemoveHandler(Set<String> knownApplicationSecurityDomains, AbstractAddStepHandler addOperation) {
            super(addOperation);
            this.knownApplicationSecurityDomains = knownApplicationSecurityDomains;
        }

        protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRemove(context, operation, model);
            this.knownApplicationSecurityDomains.remove(context.getCurrentAddressValue());
        }

        protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.recordCapabilitiesAndRequirements(context, operation, resource);
            context.deregisterCapability(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.undertow.application-security-domain.known-deployments", (String)context.getCurrentAddressValue()));
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
            super.performRuntime(context, operation, model);
            if (context.isResourceServiceRestartAllowed()) {
                String securityDomainName = context.getCurrentAddressValue();
                context.removeService(new SingleSignOnManagerServiceNameProvider(securityDomainName).getServiceName());
                context.removeService(new SingleSignOnSessionFactoryServiceNameProvider(securityDomainName).getServiceName());
            }
        }

        protected ServiceName serviceName(String name) {
            RuntimeCapability dynamicCapability = APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(name);
            return dynamicCapability.getCapabilityServiceName(BiFunction.class);
        }
    }

    private static class ReferencingDeploymentsHandler
    implements OperationStepHandler {
        private ReferencingDeploymentsHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isDefaultRequiresRuntime()) {
                context.addStep((ctx, op) -> {
                    KnownDeploymentsApi knownDeploymentsApi = (KnownDeploymentsApi)context.getCapabilityRuntimeAPI("org.wildfly.undertow.application-security-domain.known-deployments", ctx.getCurrentAddressValue(), KnownDeploymentsApi.class);
                    ModelNode deploymentList = new ModelNode();
                    for (String current : knownDeploymentsApi.getKnownDeployments()) {
                        deploymentList.add(current);
                    }
                    context.getResult().set(deploymentList);
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }

    private static class KnownDeploymentsApi {
        private volatile ApplicationSecurityDomainService service;

        private KnownDeploymentsApi() {
        }

        List<String> getKnownDeployments() {
            return this.service != null ? this.service.getDeployments() : Collections.emptyList();
        }

        void setApplicationSecurityDomainService(ApplicationSecurityDomainService service) {
            this.service = service;
        }
    }

    public static interface Registration {
        public void cancel();
    }

    private static class ApplicationSecurityDomainService
    implements Service,
    BiFunction<DeploymentInfo, Function<String, RunAsIdentityMetaData>, Registration> {
        private final Supplier<HttpAuthenticationFactory> httpAuthenticationFactorySupplier;
        private final Supplier<SecurityDomain> securityDomainSupplier;
        private final Supplier<UnaryOperator<HttpServerAuthenticationMechanismFactory>> singleSignOnTransformerSupplier;
        private final BiFunction<HttpExchangeSpi, String, IdentityCache> identityCacheSupplier;
        private final Consumer<BiFunction<DeploymentInfo, Function<String, RunAsIdentityMetaData>, Registration>> deploymentConsumer;
        private final Consumer<SecurityDomain> securityDomainConsumer;
        private final boolean overrideDeploymentConfig;
        private final Set<RegistrationImpl> registrations = new HashSet<RegistrationImpl>();
        private final boolean enableJacc;
        private final boolean enableJaspi;
        private final boolean integratedJaspi;
        private volatile HttpAuthenticationFactory httpAuthenticationFactory;
        private volatile SecurityDomain securityDomain;

        private ApplicationSecurityDomainService(boolean overrideDeploymentConfig, boolean enableJacc, boolean enableJaspi, boolean integratedJaspi, Supplier<HttpAuthenticationFactory> httpAuthenticationFactorySupplier, Supplier<SecurityDomain> securityDomainSupplier, Supplier<UnaryOperator<HttpServerAuthenticationMechanismFactory>> singleSignOnTransformerSupplier, BiFunction<HttpExchangeSpi, String, IdentityCache> identityCacheSupplier, Consumer<BiFunction<DeploymentInfo, Function<String, RunAsIdentityMetaData>, Registration>> deploymentConsumer, Consumer<SecurityDomain> securityDomainConsumer) {
            this.overrideDeploymentConfig = overrideDeploymentConfig;
            this.enableJacc = enableJacc;
            this.enableJaspi = enableJaspi;
            this.integratedJaspi = integratedJaspi;
            this.httpAuthenticationFactorySupplier = httpAuthenticationFactorySupplier;
            this.securityDomainSupplier = securityDomainSupplier;
            this.singleSignOnTransformerSupplier = singleSignOnTransformerSupplier;
            this.identityCacheSupplier = identityCacheSupplier;
            this.deploymentConsumer = deploymentConsumer;
            this.securityDomainConsumer = securityDomainConsumer;
        }

        public void start(StartContext context) throws StartException {
            this.deploymentConsumer.accept(this);
            if (this.httpAuthenticationFactorySupplier != null) {
                this.httpAuthenticationFactory = this.httpAuthenticationFactorySupplier.get();
                this.securityDomain = this.httpAuthenticationFactory.getSecurityDomain();
            } else {
                this.securityDomain = this.securityDomainSupplier.get();
            }
            this.securityDomainConsumer.accept(this.securityDomain);
        }

        public void stop(StopContext context) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Registration apply(DeploymentInfo deploymentInfo, Function<String, RunAsIdentityMetaData> runAsMapper) {
            HttpAuthenticationFactory httpAuthenticationFactory = this.httpAuthenticationFactory != null ? this.httpAuthenticationFactory : ApplicationSecurityDomainDefinition.toHttpAuthenticationFactory(this.securityDomain, this.getRealmName(deploymentInfo));
            AuthenticationManager.Builder builder = AuthenticationManager.builder().setHttpAuthenticationFactory(httpAuthenticationFactory).setOverrideDeploymentConfig(this.overrideDeploymentConfig).setHttpAuthenticationFactoryTransformer(this.singleSignOnTransformerSupplier.get()).setIdentityCacheSupplier(this.identityCacheSupplier).setRunAsMapper(runAsMapper).setEnableJaspi(this.enableJaspi).setIntegratedJaspi(this.integratedJaspi);
            if (this.enableJacc) {
                builder.setAuthorizationManager(JACCAuthorizationManager.INSTANCE);
            }
            AuthenticationManager authenticationManager = builder.build();
            authenticationManager.configure(deploymentInfo);
            RegistrationImpl registration = new RegistrationImpl(deploymentInfo);
            Set<RegistrationImpl> set = this.registrations;
            synchronized (set) {
                this.registrations.add(registration);
            }
            return registration;
        }

        private String getRealmName(DeploymentInfo deploymentInfo) {
            LoginConfig loginConfig = deploymentInfo.getLoginConfig();
            return loginConfig != null ? loginConfig.getRealmName() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> getDeployments() {
            Set<RegistrationImpl> set = this.registrations;
            synchronized (set) {
                ArrayList<String> deployments = new ArrayList<String>(this.registrations.size());
                for (RegistrationImpl registration : this.registrations) {
                    deployments.add(registration.deploymentInfo.getDeploymentName());
                }
                return deployments;
            }
        }

        private class RegistrationImpl
        implements Registration {
            final DeploymentInfo deploymentInfo;

            private RegistrationImpl(DeploymentInfo deploymentInfo) {
                this.deploymentInfo = deploymentInfo;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                if (WildFlySecurityManager.isChecking()) {
                    AccessController.doPrivileged(() -> {
                        SecurityDomain.unregisterClassLoader((ClassLoader)this.deploymentInfo.getClassLoader());
                        return null;
                    });
                } else {
                    SecurityDomain.unregisterClassLoader((ClassLoader)this.deploymentInfo.getClassLoader());
                }
                Set<RegistrationImpl> set = ApplicationSecurityDomainService.this.registrations;
                synchronized (set) {
                    ApplicationSecurityDomainService.this.registrations.remove(this);
                }
            }
        }
    }
}

