/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.suspend;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.jboss.as.controller.notification.NotificationHandlerRegistry;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.CountingRequestCountCallback;
import org.jboss.as.server.suspend.OperationListener;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.Assert;

public class SuspendController
implements Service<SuspendController> {
    private Timer timer;
    private State state = State.SUSPENDED;
    private final NavigableMap<Integer, List<ServerActivity>> activitiesByGroup = new TreeMap<Integer, List<ServerActivity>>();
    private final List<OperationListener> operationListeners = new ArrayList<OperationListener>();
    private final InjectedValue<NotificationHandlerRegistry> notificationHandlerRegistry = new InjectedValue();
    private int groupsCount;
    private boolean startSuspended = false;
    private final ServerActivityCallback listener = this::activityPaused;

    public void setStartSuspended(boolean startSuspended) {
        this.startSuspended = startSuspended;
        this.state = State.SUSPENDED;
    }

    public synchronized void suspend(long timeoutMillis) {
        if (this.state == State.SUSPENDED) {
            return;
        }
        if (timeoutMillis > 0L) {
            ServerLogger.ROOT_LOGGER.suspendingServer(timeoutMillis);
        } else if (timeoutMillis < 0L) {
            ServerLogger.ROOT_LOGGER.suspendingServerWithNoTimeout();
        } else {
            ServerLogger.ROOT_LOGGER.suspendingServer();
        }
        this.state = State.PRE_SUSPEND;
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.suspendStarted();
        }
        this.groupsCount = this.activitiesByGroup.size();
        if (this.groupsCount == 0) {
            this.handlePause();
        } else {
            CountingRequestCountCallback preSuspendGroupCallBack = new CountingRequestCountCallback(this.groupsCount, () -> {
                this.state = State.SUSPENDING;
                this.processGroups(this.activitiesByGroup.values().iterator(), (executionGroup, cb) -> {
                    for (ServerActivity activity : executionGroup) {
                        activity.suspended((ServerActivityCallback)cb);
                    }
                }, this.listener);
            });
            this.processGroups(this.activitiesByGroup.values().iterator(), (executionGroup, cb) -> {
                for (ServerActivity activity : executionGroup) {
                    activity.preSuspend((ServerActivityCallback)cb);
                }
            }, preSuspendGroupCallBack);
            if (timeoutMillis > 0L) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SuspendController.this.timeout();
                    }
                }, timeoutMillis);
            } else if (timeoutMillis == 0L) {
                this.timeout();
            }
        }
    }

    public void nonGracefulStart() {
        this.resume(false);
    }

    public void resume() {
        this.resume(true);
    }

    private synchronized void resume(boolean gracefulStart) {
        if (this.state == State.RUNNING) {
            return;
        }
        if (!gracefulStart) {
            ServerLogger.ROOT_LOGGER.startingNonGraceful();
        } else {
            ServerLogger.ROOT_LOGGER.resumingServer();
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.cancelled();
        }
        for (List executionGroup : this.activitiesByGroup.descendingMap().values()) {
            for (ServerActivity activity : executionGroup) {
                try {
                    activity.resume();
                }
                catch (Exception e) {
                    ServerLogger.ROOT_LOGGER.failedToResume(activity, e);
                }
            }
        }
        this.state = State.RUNNING;
    }

    public synchronized void registerActivity(ServerActivity activity) {
        Assert.checkNotNullParam((String)"activity", (Object)activity);
        Assert.checkMinimumParameter((String)"activity.getExecutionGroup()", (int)1, (int)activity.getExecutionGroup());
        Assert.checkMaximumParameter((String)"activity.getExecutionGroup()", (int)10, (int)activity.getExecutionGroup());
        List executionGroup = this.activitiesByGroup.computeIfAbsent(activity.getExecutionGroup(), ArrayList::new);
        executionGroup.add(activity);
        if (this.state != State.RUNNING) {
            activity.suspended(() -> {});
        }
    }

    public synchronized void unRegisterActivity(ServerActivity activity) {
        List executionGroup = (List)this.activitiesByGroup.get(activity.getExecutionGroup());
        if (executionGroup != null) {
            executionGroup.remove(activity);
            if (executionGroup.isEmpty()) {
                this.activitiesByGroup.remove(activity.getExecutionGroup());
            }
        }
    }

    public synchronized void start(StartContext startContext) throws StartException {
        if (this.startSuspended) {
            ServerLogger.AS_ROOT_LOGGER.startingServerSuspended();
        }
    }

    public synchronized void stop(StopContext stopContext) {
    }

    public State getState() {
        return this.state;
    }

    private synchronized void activityPaused() {
        --this.groupsCount;
        this.handlePause();
    }

    private void handlePause() {
        if (this.groupsCount == 0) {
            this.state = State.SUSPENDED;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
                listener.complete();
            }
        }
    }

    private synchronized void timeout() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.timeout();
        }
    }

    public synchronized void addListener(OperationListener listener) {
        this.operationListeners.add(listener);
    }

    public synchronized void removeListener(OperationListener listener) {
        this.operationListeners.remove(listener);
    }

    public SuspendController getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<NotificationHandlerRegistry> getNotificationHandlerRegistry() {
        return this.notificationHandlerRegistry;
    }

    private void processGroups(Iterator<List<ServerActivity>> iterator, BiConsumer<List<ServerActivity>, ServerActivityCallback> groupFunction, ServerActivityCallback groupsCallback) {
        if (iterator.hasNext()) {
            List<ServerActivity> activityList = iterator.next();
            CountingRequestCountCallback cb = new CountingRequestCountCallback(activityList.size(), () -> {
                this.processGroups(iterator, groupFunction, groupsCallback);
                groupsCallback.done();
            });
            groupFunction.accept(activityList, cb);
        }
    }

    public static enum State {
        RUNNING,
        PRE_SUSPEND,
        SUSPENDING,
        SUSPENDED;

    }
}

