/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.job.repository;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.jberet.repository.JdbcRepository;
import org.jberet.repository.JobRepository;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.job.repository.JobRepositoryService;

public class JdbcJobRepositoryService
extends JobRepositoryService
implements Service<JobRepository> {
    private final Supplier<DataSource> dataSourceSupplier;
    private final Supplier<ExecutorService> executorSupplier;
    private volatile JdbcRepository jobRepository;

    public JdbcJobRepositoryService(Consumer<JobRepository> jobRepositoryConsumer, Supplier<DataSource> dataSourceSupplier, Supplier<ExecutorService> executorSupplier, Integer executionRecordsLimit) {
        super(jobRepositoryConsumer, executionRecordsLimit);
        this.dataSourceSupplier = dataSourceSupplier;
        this.executorSupplier = executorSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startJobRepository(StartContext context) throws StartException {
        ExecutorService service = this.executorSupplier.get();
        Runnable task = () -> {
            try {
                this.jobRepository = new JdbcRepository(this.dataSourceSupplier.get());
                context.complete();
            }
            catch (Exception e) {
                context.failed(BatchLogger.LOGGER.failedToCreateJobRepository(e, "JDBC"));
            }
        };
        try {
            service.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    @Override
    public void stopJobRepository(StopContext context) {
        this.jobRepository = null;
    }

    @Override
    protected JobRepository getDelegate() {
        return this.jobRepository;
    }
}

