/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi.impl;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.jaspi._private.ElytronEEMessages;

class ThreadLocalCallbackHandler
implements CallbackHandler {
    private static final ThreadLocalCallbackHandler INSTANCE = new ThreadLocalCallbackHandler();
    private final ThreadLocal<CallbackHandler> delegateLocal = new ThreadLocal();

    ThreadLocalCallbackHandler() {
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        CallbackHandler delegate = this.delegateLocal.get();
        if (delegate == null) {
            throw ElytronEEMessages.eeLog.noThreadLocalCallbackHandler();
        }
        delegate.handle(callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R, E extends Exception> R get(ExceptionSupplier<R, E> supplier, CallbackHandler realHandler) throws E {
        CallbackHandler original = this.delegateLocal.get();
        try {
            this.delegateLocal.set(realHandler);
            Object object = supplier.get();
            return (R)object;
        }
        finally {
            this.delegateLocal.set(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(Runnable runnable, CallbackHandler realHandler) {
        CallbackHandler original = this.delegateLocal.get();
        try {
            this.delegateLocal.set(realHandler);
            runnable.run();
        }
        finally {
            this.delegateLocal.set(original);
        }
    }

    static ThreadLocalCallbackHandler getInstance() {
        return INSTANCE;
    }
}

