/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3._private;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Locale;
import javax.security.sasl.SaslException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.remoting3.ChannelBusyException;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3._private.Messages;
import org.wildfly.security.auth.AuthenticationException;

public class Messages_$logger
extends DelegatingBasicLogger
implements Messages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Messages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void connectionError(IOException cause) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.connectionError$str(), (Object)cause);
    }

    protected String connectionError$str() {
        return "JBREM000200: Remote connection failed: %s";
    }

    protected String invalidMessage$str() {
        return "JBREM000201: Received invalid message on %s";
    }

    @Override
    public final IOException invalidMessage(Object connection) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidMessage$str(), connection));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String abruptClose$str() {
        return "JBREM000202: Abrupt close on %s";
    }

    @Override
    public final IOException abruptClose(Object connection) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.abruptClose$str(), connection));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void bufferUnderflowRaw() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.bufferUnderflowRaw$str(), new Object[0]);
    }

    protected String bufferUnderflowRaw$str() {
        return "JBREM000203: Message missing protocol byte";
    }

    @Override
    public final void bufferUnderflow(int id) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.bufferUnderflow$str(), (Object)id);
    }

    protected String bufferUnderflow$str() {
        return "JBREM000204: Buffer underflow parsing message with protocol ID %02x";
    }

    @Override
    public final void failedToAccept(Exception e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.failedToAccept$str(), (Object)e);
    }

    protected String failedToAccept$str() {
        return "JBREM000205: Failed to accept a connection: %s";
    }

    protected String channelNotOpen$str() {
        return "JBREM000206: Channel is not open";
    }

    @Override
    public final NotOpenException channelNotOpen() {
        NotOpenException result = new NotOpenException(String.format(this.getLoggingLocale(), this.channelNotOpen$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String channelBusy$str() {
        return "JBREM000207: Failed to send a message (channel is busy)";
    }

    @Override
    public final ChannelBusyException channelBusy() {
        ChannelBusyException result = new ChannelBusyException(String.format(this.getLoggingLocale(), this.channelBusy$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String writeInterrupted$str() {
        return "JBREM000208: Write operation interrupted";
    }

    @Override
    public final InterruptedIOException writeInterrupted() {
        InterruptedIOException result = new InterruptedIOException(String.format(this.getLoggingLocale(), this.writeInterrupted$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void exceptionInUserHandler(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.exceptionInUserHandler$str(), new Object[0]);
    }

    protected String exceptionInUserHandler$str() {
        return "JBREM000209: An exception occurred in a message handler";
    }

    @Override
    public final void duplicateMessageId(short messageId, SocketAddress peerAddress) {
        this.log.logf(FQCN, Logger.Level.FATAL, null, this.duplicateMessageId$str(), (Object)messageId, (Object)peerAddress);
    }

    protected String duplicateMessageId$str() {
        return "JBREM000210: Internal Error: received a message with duplicate ID %d from %s";
    }

    protected String duplicateMessageIdException$str() {
        return "Internal Error: received a message with a duplicate ID";
    }

    @Override
    public final IOException duplicateMessageIdException() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.duplicateMessageIdException$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidWorker$str() {
        return "JBREM000211: Invalid XNIO worker; the worker must match the Remoting Endpoint worker";
    }

    @Override
    public final IllegalArgumentException invalidWorker() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidWorker$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToConfigureSslContext$str() {
        return "JBREM000212: Failed to configure SSL context";
    }

    @Override
    public final IOException failedToConfigureSslContext(Throwable cause) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.failedToConfigureSslContext$str(), new Object[0]), cause);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unknownProtocolId(int id) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.unknownProtocolId$str(), (Object)id);
    }

    protected String unknownProtocolId$str() {
        return "Message with unknown protocol ID %d received";
    }

    @Override
    public final void rejectedInvalidMechanism(String name) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.rejectedInvalidMechanism$str(), (Object)name);
    }

    protected String rejectedInvalidMechanism$str() {
        return "Rejected invalid SASL mechanism %s";
    }

    protected String authenticationExceptionIo$str() {
        return "JBREM000300: Authentication failed due to I/O error";
    }

    @Override
    public final AuthenticationException authenticationExceptionIo(IOException e) {
        AuthenticationException result = new AuthenticationException(String.format(this.getLoggingLocale(), this.authenticationExceptionIo$str(), new Object[0]), (Throwable)e);
        Messages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String mechanismNameTooLong$str() {
        return "JBREM000301: Mechanism name \"%s\" is too long";
    }

    @Override
    public final IOException mechanismNameTooLong(String mechName) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.mechanismNameTooLong$str(), mechName));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String authenticationMessageTooLarge$str() {
        return "JBREM000302: Authentication message too large";
    }

    @Override
    public final IOException authenticationMessageTooLarge() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.authenticationMessageTooLarge$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String authenticationExtraResponse$str() {
        return "JBREM000303: Authentication protocol failed (extra response)";
    }

    @Override
    public final AuthenticationException authenticationExtraResponse() {
        AuthenticationException result = new AuthenticationException(String.format(this.getLoggingLocale(), this.authenticationExtraResponse$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String serverRejectedAuthentication$str() {
        return "JBREM000304: Server rejected authentication";
    }

    @Override
    public final AuthenticationException serverRejectedAuthentication() {
        AuthenticationException result = new AuthenticationException(String.format(this.getLoggingLocale(), this.serverRejectedAuthentication$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String authenticationExceptionClosed$str() {
        return "JBREM000305: Authentication failed (connection closed)";
    }

    @Override
    public final AuthenticationException authenticationExceptionClosed() {
        AuthenticationException result = new AuthenticationException(String.format(this.getLoggingLocale(), this.authenticationExceptionClosed$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String authenticationNoSaslClient$str() {
        return "JBREM000306: Authentication failed (SASL client construction failure)";
    }

    @Override
    public final AuthenticationException authenticationNoSaslClient(SaslException e) {
        AuthenticationException result = new AuthenticationException(String.format(this.getLoggingLocale(), this.authenticationNoSaslClient$str(), new Object[0]), (Throwable)e);
        Messages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String authenticationInterrupted$str() {
        return "JBREM000307: Authentication interrupted";
    }

    @Override
    public final AuthenticationException authenticationInterrupted() {
        AuthenticationException result = new AuthenticationException(String.format(this.getLoggingLocale(), this.authenticationInterrupted$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noAuthMechanismsLeft$str() {
        return "JBREM000308: Authentication failed (no mechanisms left), tried: %s";
    }

    @Override
    public final AuthenticationException noAuthMechanismsLeft(String triedStr) {
        AuthenticationException result = new AuthenticationException(String.format(this.getLoggingLocale(), this.noAuthMechanismsLeft$str(), triedStr));
        Messages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String authenticationNotSupported$str() {
        return "JBREM000309: Authentication not supported for this peer";
    }

    @Override
    public final AuthenticationException authenticationNotSupported() {
        AuthenticationException result = new AuthenticationException(String.format(this.getLoggingLocale(), this.authenticationNotSupported$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

