/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote.metadata;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.function.Functions;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheEntryComputer;
import org.wildfly.clustering.server.offset.OffsetValue;
import org.wildfly.clustering.server.offset.Value;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.session.cache.metadata.fine.CompositeImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.CompositeSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.MutableSessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.MutableSessionAccessMetaDataOffsetValues;
import org.wildfly.clustering.session.cache.metadata.fine.MutableSessionAccessMetaDataValues;
import org.wildfly.clustering.session.cache.metadata.fine.MutableSessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaDataEntryFunction;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntryFunction;
import org.wildfly.clustering.session.cache.metadata.fine.SessionMetaDataEntry;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionAccessMetaDataKey;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionCreationMetaDataKey;

public class HotRodSessionMetaDataFactory<C>
implements SessionMetaDataFactory<SessionMetaDataEntry<C>>,
BiFunction<SessionCreationMetaDataEntry<C>, SessionAccessMetaDataEntry, SessionMetaDataEntry<C>> {
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<C>> creationMetaDataCache;
    private final RemoteCache<SessionAccessMetaDataKey, SessionAccessMetaDataEntry> accessMetaDataCache;
    private final Flag[] ignoreReturnFlags;

    public HotRodSessionMetaDataFactory(RemoteCacheConfiguration configuration) {
        this.creationMetaDataCache = configuration.getCache();
        this.accessMetaDataCache = configuration.getCache();
        this.ignoreReturnFlags = configuration.getIgnoreReturnFlags();
    }

    public CompletionStage<SessionMetaDataEntry<C>> createValueAsync(String id, Duration defaultTimeout) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        DefaultSessionCreationMetaDataEntry creationMetaData = new DefaultSessionCreationMetaDataEntry();
        creationMetaData.setTimeout(defaultTimeout);
        DefaultSessionAccessMetaDataEntry accessMetaData = new DefaultSessionAccessMetaDataEntry();
        CompletableFuture creationStage = this.creationMetaDataCache.withFlags(this.ignoreReturnFlags).putAsync((Object)creationMetaDataKey, (Object)creationMetaData);
        CompletableFuture accessStage = this.accessMetaDataCache.withFlags(this.ignoreReturnFlags).putAsync((Object)accessMetaDataKey, (Object)accessMetaData, 0L, TimeUnit.SECONDS, defaultTimeout.getSeconds(), TimeUnit.SECONDS);
        return CompletableFuture.allOf(creationStage, accessStage).thenApply(Functions.constantFunction((Object)new DefaultSessionMetaDataEntry((SessionCreationMetaDataEntry)creationMetaData, (SessionAccessMetaDataEntry)accessMetaData)));
    }

    public CompletionStage<SessionMetaDataEntry<C>> findValueAsync(String id) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        return this.creationMetaDataCache.getAsync((Object)creationMetaDataKey).thenCombine((CompletionStage)this.accessMetaDataCache.getAsync((Object)accessMetaDataKey), (BiFunction)this);
    }

    @Override
    public SessionMetaDataEntry<C> apply(SessionCreationMetaDataEntry<C> creationMetaData, SessionAccessMetaDataEntry accessMetaData) {
        return creationMetaData != null && accessMetaData != null ? new DefaultSessionMetaDataEntry(creationMetaData, accessMetaData) : null;
    }

    public CompletionStage<Void> removeAsync(String id) {
        CompletableFuture creationMetaData = this.creationMetaDataCache.withFlags(this.ignoreReturnFlags).removeAsync((Object)new SessionCreationMetaDataKey(id));
        CompletableFuture accessMetaData = this.accessMetaDataCache.withFlags(this.ignoreReturnFlags).removeAsync((Object)new SessionAccessMetaDataKey(id));
        return CompletableFuture.allOf(creationMetaData, accessMetaData).thenAccept(org.wildfly.common.function.Functions.discardingConsumer());
    }

    public InvalidatableSessionMetaData createSessionMetaData(String id, SessionMetaDataEntry<C> entry) {
        final OffsetValue timeoutOffset = OffsetValue.from((Duration)entry.getCreationMetaDataEntry().getTimeout());
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData((ImmutableSessionCreationMetaData)entry.getCreationMetaDataEntry(), (Value)timeoutOffset);
        MutableSessionAccessMetaDataOffsetValues values = MutableSessionAccessMetaDataOffsetValues.from((ImmutableSessionAccessMetaData)entry.getAccessMetaDataEntry());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData((ImmutableSessionAccessMetaData)entry.getAccessMetaDataEntry(), (MutableSessionAccessMetaDataValues)values);
        RemoteCacheEntryComputer creationMetaDataMutator = new RemoteCacheEntryComputer(this.creationMetaDataCache, this.ignoreReturnFlags, (Object)new SessionCreationMetaDataKey(id), (BiFunction)new SessionCreationMetaDataEntryFunction(timeoutOffset));
        RemoteCacheEntryComputer accessMetaDataMutator = new RemoteCacheEntryComputer(this.accessMetaDataCache, this.ignoreReturnFlags, (Object)new SessionAccessMetaDataKey(id), (BiFunction)new SessionAccessMetaDataEntryFunction(values), () -> ((SessionCreationMetaData)creationMetaData).getTimeout());
        CacheEntryMutator mutator = new CacheEntryMutator(){
            final /* synthetic */ CacheEntryMutator val$creationMetaDataMutator;
            final /* synthetic */ CacheEntryMutator val$accessMetaDataMutator;
            final /* synthetic */ HotRodSessionMetaDataFactory this$0;
            {
                this.val$creationMetaDataMutator = cacheEntryMutator;
                this.val$accessMetaDataMutator = cacheEntryMutator2;
                this.this$0 = this$0;
            }

            public CompletionStage<Void> mutateAsync() {
                CompletionStage stage = !timeoutOffset.getOffset().isZero() ? this.val$creationMetaDataMutator.mutateAsync() : CompletableFuture.completedStage(null);
                return stage.thenAcceptBoth(this.val$accessMetaDataMutator.mutateAsync(), org.wildfly.common.function.Functions.discardingBiConsumer());
            }
        };
        return new CompositeSessionMetaData((SessionCreationMetaData)creationMetaData, (SessionAccessMetaData)accessMetaData, mutator);
    }

    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, SessionMetaDataEntry<C> entry) {
        return new CompositeImmutableSessionMetaData((ImmutableSessionCreationMetaData)entry.getCreationMetaDataEntry(), (ImmutableSessionAccessMetaData)entry.getAccessMetaDataEntry());
    }

    public void close() {
    }
}

