/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.NoSuchElementException;
import java.util.function.Function;
import org.infinispan.commons.util.CloseableIterator;

public final class MappingIterator<S, T>
implements CloseableIterator<T> {
    private final CloseableIterator<S> iterator;
    private final Function<? super S, ? extends T> mapper;
    private long skip = 0L;
    private long max = -1L;
    private T current;
    private long index;

    public MappingIterator(CloseableIterator<S> iterator, Function<? super S, ? extends T> mapper) {
        this.iterator = iterator;
        this.mapper = mapper;
    }

    public MappingIterator(CloseableIterator<S> iterator) {
        this.iterator = iterator;
        this.mapper = null;
    }

    public boolean hasNext() {
        this.updateNext();
        return this.current != null;
    }

    public T next() {
        if (this.hasNext()) {
            T element = this.current;
            this.current = null;
            return element;
        }
        throw new NoSuchElementException();
    }

    private void updateNext() {
        while (this.current == null && this.iterator.hasNext()) {
            T mapped = this.transform(this.iterator.next());
            if (mapped != null) {
                ++this.index;
            }
            if (this.index <= this.skip || this.max != -1L && this.index > this.skip + this.max) continue;
            this.current = mapped;
        }
    }

    private T transform(S s) {
        if (s == null) {
            return null;
        }
        if (this.mapper == null) {
            return (T)s;
        }
        return this.mapper.apply(s);
    }

    public MappingIterator<S, T> skip(long skip) {
        this.skip = skip;
        return this;
    }

    public MappingIterator<S, T> limit(long max) {
        this.max = max;
        return this;
    }

    public void close() {
        this.iterator.close();
    }
}

