/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.highlighter.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.highlighter.dsl.HighlighterEncoder;
import org.hibernate.search.engine.search.highlighter.dsl.HighlighterFragmenter;
import org.hibernate.search.engine.search.highlighter.dsl.HighlighterTagSchema;
import org.hibernate.search.engine.search.highlighter.spi.BoundaryScannerType;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;

public abstract class SearchHighlighterBuilder {
    protected SearchHighlighterType type;
    protected char[] boundaryChars;
    protected Integer boundaryMaxScan;
    protected Integer fragmentSize;
    protected Integer noMatchSize;
    protected Integer numberOfFragments;
    protected Boolean orderByScore;
    protected List<String> preTags;
    protected List<String> postTags;
    protected BoundaryScannerType boundaryScannerType = BoundaryScannerType.DEFAULT;
    protected Locale boundaryScannerLocale;
    protected HighlighterFragmenter fragmenterType;
    protected Integer phraseLimit;
    protected HighlighterEncoder encoder;
    protected HighlighterTagSchema tagSchema;

    public SearchHighlighterBuilder type(SearchHighlighterType type) {
        this.type = type;
        return this;
    }

    public SearchHighlighterBuilder boundaryChars(String boundaryChars) {
        if (boundaryChars == null) {
            this.boundaryChars = null;
        } else {
            this.boundaryChars = new char[boundaryChars.length()];
            for (int i = 0; i < boundaryChars.length(); ++i) {
                this.boundaryChars[i] = boundaryChars.charAt(i);
            }
        }
        return this;
    }

    public SearchHighlighterBuilder boundaryChars(char[] boundaryChars) {
        this.boundaryChars = boundaryChars;
        return this;
    }

    public SearchHighlighterBuilder boundaryMaxScan(Integer boundaryMaxScan) {
        this.boundaryMaxScan = boundaryMaxScan;
        return this;
    }

    public SearchHighlighterBuilder fragmentSize(Integer fragmentSize) {
        this.fragmentSize = fragmentSize;
        return this;
    }

    public SearchHighlighterBuilder noMatchSize(Integer noMatchSize) {
        this.noMatchSize = noMatchSize;
        return this;
    }

    public SearchHighlighterBuilder numberOfFragments(Integer numberOfFragments) {
        this.numberOfFragments = numberOfFragments;
        return this;
    }

    public SearchHighlighterBuilder orderByScore(Boolean orderByScore) {
        this.orderByScore = orderByScore;
        return this;
    }

    public SearchHighlighterBuilder boundaryScannerType(BoundaryScannerType boundaryScannerType) {
        this.boundaryScannerType = boundaryScannerType;
        return this;
    }

    public SearchHighlighterBuilder boundaryScannerLocale(Locale boundaryScannerLocale) {
        this.boundaryScannerLocale = boundaryScannerLocale;
        return this;
    }

    public SearchHighlighterBuilder fragmenter(HighlighterFragmenter type) {
        this.fragmenterType = type;
        return this;
    }

    public SearchHighlighterBuilder phraseLimit(Integer phraseLimit) {
        this.phraseLimit = phraseLimit;
        return this;
    }

    public SearchHighlighterBuilder tag(String preTag, String postTag) {
        if (this.preTags == null) {
            this.preTags = new ArrayList<String>();
        }
        this.preTags.add(preTag);
        if (this.postTags == null) {
            this.postTags = new ArrayList<String>();
        }
        this.postTags.add(postTag);
        return this;
    }

    public SearchHighlighterBuilder tags(Collection<String> preTags, String postTag) {
        for (String preTag : preTags) {
            this.tag(preTag, postTag);
        }
        return this;
    }

    public SearchHighlighterBuilder tags(Collection<String> preTags, Collection<String> postTags) {
        Iterator<String> pre = preTags.iterator();
        Iterator<String> post = postTags.iterator();
        while (pre.hasNext() && post.hasNext()) {
            this.tag(pre.next(), post.next());
        }
        return this;
    }

    public void clearTags() {
        this.clearIfNotNull(this.preTags);
        this.clearIfNotNull(this.postTags);
        this.tagSchema(null);
    }

    private void clearIfNotNull(List<String> tags) {
        if (tags != null) {
            tags.clear();
        }
    }

    public SearchHighlighterBuilder tagSchema(HighlighterTagSchema tagSchema) {
        this.tagSchema = tagSchema;
        return this;
    }

    public SearchHighlighterBuilder encoder(HighlighterEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public SearchHighlighterType type() {
        return this.type;
    }

    public char[] boundaryChars() {
        return this.boundaryChars;
    }

    public String boundaryCharsAsString() {
        if (this.boundaryChars == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        char[] cArray = this.boundaryChars;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            result.append(character.charValue());
        }
        return result.toString();
    }

    public Integer boundaryMaxScan() {
        return this.boundaryMaxScan;
    }

    public Integer fragmentSize() {
        return this.fragmentSize;
    }

    public Integer noMatchSize() {
        return this.noMatchSize;
    }

    public Integer numberOfFragments() {
        return this.numberOfFragments;
    }

    public Boolean orderByScore() {
        return this.orderByScore;
    }

    public List<String> preTags() {
        return this.preTags;
    }

    public List<String> postTags() {
        return this.postTags;
    }

    public BoundaryScannerType boundaryScannerType() {
        return this.boundaryScannerType;
    }

    public Locale boundaryScannerLocale() {
        return this.boundaryScannerLocale;
    }

    public HighlighterFragmenter fragmenterType() {
        return this.fragmenterType;
    }

    public Integer phraseLimit() {
        return this.phraseLimit;
    }

    public HighlighterTagSchema tagSchema() {
        return this.tagSchema;
    }

    public HighlighterEncoder encoder() {
        return this.encoder;
    }

    public abstract SearchHighlighter build();
}

