/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;

final class PageSyncTimer
extends ActiveMQScheduledComponent {
    private final PagingStore store;
    private final ScheduledExecutorService scheduledExecutor;
    private boolean pendingSync;
    private final long timeSync;
    private final Runnable runnable = this::tick;
    private final List<OperationContext> syncOperations = new LinkedList<OperationContext>();

    PageSyncTimer(PagingStore store, ScheduledExecutorService scheduledExecutor, Executor executor, long timeSync) {
        super(scheduledExecutor, executor, timeSync, TimeUnit.NANOSECONDS, true);
        this.store = store;
        this.scheduledExecutor = scheduledExecutor;
        this.timeSync = timeSync;
    }

    synchronized void addSync(OperationContext ctx) {
        ctx.pageSyncLineUp();
        if (!this.pendingSync) {
            this.pendingSync = true;
            this.delay();
        }
        this.syncOperations.add(ctx);
    }

    public void run() {
        this.tick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        OperationContext[] operationContextArray = this;
        synchronized (this) {
            block10: {
                this.pendingSync = false;
                OperationContext[] pendingSyncsArray = new OperationContext[this.syncOperations.size()];
                pendingSyncsArray = this.syncOperations.toArray(pendingSyncsArray);
                this.syncOperations.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                try {
                    if (pendingSyncsArray.length == 0) break block10;
                    this.store.ioSync();
                }
                catch (Exception e) {
                    for (OperationContext ctx : pendingSyncsArray) {
                        ctx.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getClass() + " during ioSync for paging on " + this.store.getStoreName() + ": " + e.getMessage());
                    }
                }
                finally {
                    for (OperationContext ctx : pendingSyncsArray) {
                        ctx.pageSyncDone();
                    }
                }
            }
            return;
        }
    }
}

