/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.PathAddressFilter;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadConfigAsFeaturesOperationHandler
implements OperationStepHandler {
    private static final String ID = "id";
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-config-as-features", ControllerResolver.getResolver("subsystem")).addAccessConstraint(SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG).setReadOnly().withFlag(OperationEntry.Flag.HIDDEN).setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).addParameter(((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("nested", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.TRUE)).build()).build();
    private final String operationName;
    private final PathAddressFilter addressFilter;

    public ReadConfigAsFeaturesOperationHandler() {
        this(null);
    }

    public ReadConfigAsFeaturesOperationHandler(PathAddressFilter addressFilter) {
        this.operationName = "read-config-as-features";
        this.addressFilter = addressFilter;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        if (this.addressFilter != null && !this.addressFilter.accepts(address)) {
            return;
        }
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        if (registration.isAlias() || registration.isRemote() || registration.isRuntimeOnly()) {
            return;
        }
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        if (resource.isProxy() || resource.isRuntime()) {
            return;
        }
        final ModelNode result = context.getResult();
        result.setEmptyList();
        final ModelNode results = new ModelNode().setEmptyList();
        final AtomicReference<ModelNode> failureRef = new AtomicReference<ModelNode>();
        final boolean nest = operation.hasDefined("nested") ? operation.get("nested").asBoolean() : true;
        final ModelNode feature = registration.isFeature() ? this.readAsFeature(resource, registration, operation, address, context, results, nest) : null;
        context.addStep(new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                boolean failed = false;
                if (failureRef.get() != null) {
                    context.getFailureDescription().set((ModelNode)failureRef.get());
                    failed = true;
                }
                if (!failed) {
                    List children = results.asList();
                    if (feature == null) {
                        for (ModelNode child : children) {
                            result.add(child);
                        }
                    } else if (nest) {
                        if (!children.isEmpty()) {
                            ModelNode nested = feature.get("children").setEmptyList();
                            for (ModelNode childRsp : children) {
                                nested.add(childRsp);
                            }
                        }
                        result.add(feature);
                    } else {
                        result.add(feature);
                        if (!children.isEmpty()) {
                            for (ModelNode childRsp : children) {
                                result.add(childRsp);
                            }
                        }
                    }
                    context.getResult().set(result);
                }
            }
        }, OperationContext.Stage.MODEL, true);
        this.describeChildren(resource, registration, address, context, failureRef, results, operation, nest);
    }

    private void describeChildren(Resource resource, ImmutableManagementResourceRegistration registration, PathAddress address, OperationContext context, AtomicReference<ModelNode> failureRef, ModelNode results, ModelNode operation, Boolean nest) {
        for (String childType : resource.getChildTypes()) {
            for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                if (this.addressFilter != null && !this.addressFilter.accepts(address.append(entry.getPathElement()))) continue;
                ImmutableManagementResourceRegistration childRegistration = registration.getSubModel(PathAddress.EMPTY_ADDRESS.append(entry.getPathElement()));
                if (childRegistration == null) {
                    ControllerLogger.ROOT_LOGGER.debugf("Couldn't find a registration for %s at %s for resource %s at %s", new Object[]{entry.getPathElement().toString(), registration.getPathAddress().toCLIStyleString(), resource, address.toCLIStyleString()});
                    continue;
                }
                if (childRegistration.isRuntimeOnly() || childRegistration.isRemote() || childRegistration.isAlias()) continue;
                this.describeChildResource(entry, registration, address, context, failureRef, results, operation, nest);
            }
        }
    }

    private ModelNode readAsFeature(Resource resource, ImmutableManagementResourceRegistration registration, ModelNode operation, PathAddress address, OperationContext context, ModelNode results, boolean nest) throws OperationFailedException {
        Set<String> idParamNames;
        ImmutableManagementResourceRegistration registry = context.getRootResourceRegistration().getSubModel(address);
        ModelNode featureNode = new ModelNode();
        featureNode.get("spec").set(registry.getFeature());
        ModelNode idParams = featureNode.get(ID);
        int addrSize = address.size();
        if (addrSize > 0) {
            idParamNames = new HashSet(addrSize);
            if (addrSize > 1) {
                int i = 0;
                while (i < addrSize - 1) {
                    PathElement elt = address.getElement(i++);
                    String paramName = elt.getKey();
                    idParamNames.add(paramName);
                    if (nest) continue;
                    idParams.get(paramName).set(elt.getValue());
                }
            }
            PathElement lastElt = address.getLastElement();
            String paramName = lastElt.getKey();
            idParams.get(paramName).set(lastElt.getValue());
            idParamNames.add(paramName);
        } else {
            idParamNames = Collections.emptySet();
        }
        DescriptionProvider addDescr = registration.getOperationDescription(PathAddress.EMPTY_ADDRESS, "add");
        ModelNode addProps = addDescr == null ? null : addDescr.getModelDescription(null).get("request-properties");
        List<Object> children = Collections.emptyList();
        ModelNode params = null;
        ModelNode model = resource.getModel();
        try (Stream attrs = registration.getAttributeNames(PathAddress.EMPTY_ADDRESS).stream();){
            Iterator iterator = attrs.iterator();
            while (iterator.hasNext()) {
                ModelType attrType;
                AttributeAccess attrAccess;
                String attrName = (String)iterator.next();
                if (!model.hasDefined(attrName) || (attrAccess = registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attrName)).getStorageType() != AttributeAccess.Storage.CONFIGURATION || !attrAccess.getAccessType().equals((Object)AttributeAccess.AccessType.READ_WRITE) && (addProps == null || !addProps.has(attrName))) continue;
                AttributeDefinition attrDef = attrAccess.getAttributeDefinition();
                if ((!attrDef.isRequired() || addProps == null || !addProps.hasDefined(attrName)) && (attrType = attrDef.getType()).equals((Object)ModelType.OBJECT) && ObjectTypeAttributeDefinition.class.isAssignableFrom(attrDef.getClass())) {
                    ModelNode child = this.readObjectAttributeAsFeature(registration, (ObjectTypeAttributeDefinition)attrDef, idParams, idParamNames, model.get(attrName), nest);
                    if (children.isEmpty()) {
                        children = Collections.singletonList(child);
                        continue;
                    }
                    if (children.size() == 1) {
                        List<Object> tmp = children;
                        children = new ArrayList(2);
                        children.add((ModelNode)tmp.get(0));
                    }
                    children.add(child);
                    continue;
                }
                Object paramName = attrName;
                if (idParamNames.contains(attrName) || ("profile".equals(attrName) || "host".equals(attrName)) && ReadConfigAsFeaturesOperationHandler.isSubsystem(address)) {
                    paramName = attrName + "-feature";
                }
                if (params == null) {
                    params = featureNode.get("params");
                }
                params.get((String)paramName).set(model.get(attrName));
            }
        }
        if (!children.isEmpty()) {
            for (ModelNode modelNode : children) {
                results.add(modelNode);
            }
        }
        return featureNode;
    }

    private ModelNode readObjectAttributeAsFeature(ImmutableManagementResourceRegistration registration, ObjectTypeAttributeDefinition attrDef, ModelNode idParams, Set<String> idParamNames, ModelNode objectValue, boolean nest) {
        AttributeDefinition[] attrs;
        ModelNode featureNode = new ModelNode();
        featureNode.get("spec").set(registration.getFeature() + "." + attrDef.getName());
        if (!nest) {
            featureNode.get(ID).set(idParams.clone());
        }
        ModelNode params = featureNode.get("params");
        for (AttributeDefinition attr : attrs = attrDef.getValueTypes()) {
            Object attrName = attr.getName();
            if (!objectValue.hasDefined((String)attrName)) continue;
            ModelNode attrValue = objectValue.get((String)attrName);
            if (idParamNames.contains(attrName)) {
                attrName = (String)attrName + "-feature";
            }
            params.get((String)attrName).set(attrValue);
        }
        return featureNode;
    }

    private static boolean isSubsystem(PathAddress address) {
        for (PathElement elt : address) {
            if (!"subsystem".equals(elt.getKey())) continue;
            return true;
        }
        return false;
    }

    private void describeChildResource(Resource.ResourceEntry entry, ImmutableManagementResourceRegistration registration, final PathAddress address, OperationContext context, final AtomicReference<ModelNode> failureRef, final ModelNode results, ModelNode operation, Boolean nest) {
        final ModelNode childRsp = new ModelNode();
        context.addStep(new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (failureRef.get() == null) {
                    if (childRsp.hasDefined("failure-description")) {
                        failureRef.set(childRsp.get("failure-description"));
                    } else if (childRsp.hasDefined("result")) {
                        ReadConfigAsFeaturesOperationHandler.this.addChildOperation(address, childRsp.require("result").asList(), results);
                    }
                }
            }
        }, OperationContext.Stage.MODEL, true);
        ModelNode childOperation = operation.clone();
        childOperation.get("operation").set(this.operationName);
        if (nest != null) {
            childOperation.get("nested").set(nest.booleanValue());
        }
        PathElement childPE = entry.getPathElement();
        childOperation.get("address").set(address.append(childPE).toModelNode());
        ImmutableManagementResourceRegistration childRegistration = registration.getSubModel(PathAddress.EMPTY_ADDRESS.append(childPE));
        OperationStepHandler stepHandler = childRegistration.getOperationHandler(PathAddress.EMPTY_ADDRESS, this.operationName);
        context.addStep(childRsp, childOperation, stepHandler, OperationContext.Stage.MODEL, true);
    }

    protected void addChildOperation(PathAddress parent, List<ModelNode> operations, ModelNode results) {
        for (ModelNode operation : operations) {
            results.add(operation);
        }
    }
}

