/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.security.Provider;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.wildfly.common.Assert;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.OneTimeSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ConfiguredSSLContextSpi;
import org.wildfly.security.ssl.DelegatingSSLContext;
import org.wildfly.security.ssl.ElytronMessages;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLConfiguratorImpl;
import org.wildfly.security.ssl.SSLUtils;
import org.wildfly.security.ssl.SecurityDomainTrustManager;

public final class SSLContextBuilder {
    private SecurityDomain securityDomain;
    private CipherSuiteSelector cipherSuiteSelector = CipherSuiteSelector.openSslDefault();
    private ProtocolSelector protocolSelector = ProtocolSelector.DEFAULT_SELECTOR;
    private boolean useCipherSuitesOrder = true;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private boolean authenticationOptional;
    private boolean clientMode;
    private int sessionCacheSize;
    private int sessionTimeout;
    private SecurityFactory<X509ExtendedKeyManager> keyManagerSecurityFactory;
    private SecurityFactory<X509TrustManager> trustManagerSecurityFactory = SSLUtils.getDefaultX509TrustManagerSecurityFactory();
    private Supplier<Provider[]> providerSupplier = ProviderUtil.INSTALLED_PROVIDERS;
    private String providerName;
    private boolean wrap = true;
    private MechanismConfigurationSelector mechanismConfigurationSelector;

    public SSLContextBuilder setSecurityDomain(SecurityDomain securityDomain) {
        if (securityDomain != null && securityDomain.getEvidenceVerifySupport(X509PeerCertificateChainEvidence.class).isNotSupported()) {
            throw ElytronMessages.tls.securityDomainOfSSLContextDoesNotSupportX509();
        }
        this.securityDomain = securityDomain;
        return this;
    }

    public SSLContextBuilder setCipherSuiteSelector(CipherSuiteSelector cipherSuiteSelector) {
        Assert.checkNotNullParam("cipherSuiteSelector", cipherSuiteSelector);
        this.cipherSuiteSelector = cipherSuiteSelector;
        return this;
    }

    public SSLContextBuilder setProtocolSelector(ProtocolSelector protocolSelector) {
        Assert.checkNotNullParam("protocolSelector", protocolSelector);
        this.protocolSelector = protocolSelector;
        return this;
    }

    public SSLContextBuilder setUseCipherSuitesOrder(boolean useCipherSuitesOrder) {
        Assert.checkNotNullParam("useCipherSuitesOrder", useCipherSuitesOrder);
        this.useCipherSuitesOrder = useCipherSuitesOrder;
        return this;
    }

    public SSLContextBuilder setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
        return this;
    }

    public SSLContextBuilder setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public SSLContextBuilder setAuthenticationOptional(boolean authenticationOptional) {
        this.authenticationOptional = authenticationOptional;
        return this;
    }

    public SSLContextBuilder setSessionCacheSize(int sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
        return this;
    }

    public SSLContextBuilder setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public SSLContextBuilder setKeyManagerSecurityFactory(SecurityFactory<X509ExtendedKeyManager> keyManagerSecurityFactory) {
        Assert.checkNotNullParam("keyManagerSecurityFactory", keyManagerSecurityFactory);
        this.keyManagerSecurityFactory = keyManagerSecurityFactory;
        return this;
    }

    public SSLContextBuilder setKeyManager(X509ExtendedKeyManager keyManager) {
        Assert.checkNotNullParam("keyManager", keyManager);
        this.keyManagerSecurityFactory = new FixedSecurityFactory<X509ExtendedKeyManager>(keyManager);
        return this;
    }

    public SSLContextBuilder setTrustManagerSecurityFactory(SecurityFactory<X509TrustManager> trustManagerSecurityFactory) {
        this.trustManagerSecurityFactory = Assert.checkNotNullParam("trustManagerSecurityFactory", trustManagerSecurityFactory);
        return this;
    }

    public SSLContextBuilder setTrustManager(X509TrustManager trustManager) {
        Assert.checkNotNullParam("trustManager", trustManager);
        this.trustManagerSecurityFactory = new FixedSecurityFactory<X509TrustManager>(trustManager);
        return this;
    }

    public SSLContextBuilder setProviderSupplier(Supplier<Provider[]> providerSupplier) {
        Assert.checkNotNullParam("providerSupplier", providerSupplier);
        this.providerSupplier = providerSupplier;
        return this;
    }

    public SSLContextBuilder setProviderName(String name) {
        this.providerName = name;
        return this;
    }

    public SSLContextBuilder setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
        return this;
    }

    public SSLContextBuilder setWrap(boolean wrap) {
        this.wrap = wrap;
        return this;
    }

    public SSLContextBuilder setMechanismConfigurationSelector(MechanismConfigurationSelector mechanismConfigurationSelector) {
        this.mechanismConfigurationSelector = mechanismConfigurationSelector;
        return this;
    }

    public SecurityFactory<SSLContext> build() {
        SecurityDomain securityDomain = this.securityDomain;
        CipherSuiteSelector cipherSuiteSelector = this.cipherSuiteSelector;
        ProtocolSelector protocolSelector = this.protocolSelector;
        SecurityFactory<X509TrustManager> trustManagerSecurityFactory = this.trustManagerSecurityFactory;
        SecurityFactory<X509ExtendedKeyManager> keyManagerSecurityFactory = this.keyManagerSecurityFactory;
        Supplier<Provider[]> providerSupplier = this.providerSupplier;
        boolean clientMode = this.clientMode;
        boolean authenticationOptional = this.authenticationOptional;
        int sessionCacheSize = this.sessionCacheSize;
        int sessionTimeout = this.sessionTimeout;
        boolean wantClientAuth = this.wantClientAuth;
        boolean needClientAuth = this.needClientAuth;
        boolean useCipherSuitesOrder = this.useCipherSuitesOrder;
        boolean wrap = this.wrap;
        MechanismConfigurationSelector mechanismConfigurationSelector = this.mechanismConfigurationSelector != null ? this.mechanismConfigurationSelector : MechanismConfigurationSelector.constantSelector(MechanismConfiguration.EMPTY);
        return new OneTimeSecurityFactory<SSLContext>(() -> {
            SSLSessionContext sessionContext;
            KeyManager[] keyManagerArray;
            boolean canAuthPeers;
            SecurityFactory<SSLContext> sslContextFactory = SSLUtils.createSslContextFactory(protocolSelector, providerSupplier, this.providerName);
            SSLContext sslContext = sslContextFactory.create();
            X509KeyManager x509KeyManager = keyManagerSecurityFactory == null ? null : (X509KeyManager)keyManagerSecurityFactory.create();
            X509TrustManager x509TrustManager = (X509TrustManager)trustManagerSecurityFactory.create();
            boolean bl = canAuthPeers = securityDomain != null && securityDomain.getEvidenceVerifySupport(X509PeerCertificateChainEvidence.class).mayBeSupported();
            if (ElytronMessages.tls.isTraceEnabled()) {
                ElytronMessages.tls.tracef("SSLContext initialization:%n    securityDomain = %s%n    canAuthPeers = %s%n    cipherSuiteSelector = %s%n    protocolSelector = %s%n    x509TrustManager = %s%n    x509KeyManager = %s%n    providerSupplier = %s%n    clientMode = %s%n    authenticationOptional = %s%n    sessionCacheSize = %s%n    sessionTimeout = %s%n    wantClientAuth = %s%n    needClientAuth = %s%n    useCipherSuitesOrder = %s%n    wrap = %s%n", securityDomain, canAuthPeers, cipherSuiteSelector, protocolSelector, x509TrustManager, x509KeyManager, providerSupplier, clientMode, authenticationOptional, sessionCacheSize, sessionTimeout, wantClientAuth, needClientAuth, useCipherSuitesOrder, wrap);
            }
            if (x509KeyManager == null) {
                keyManagerArray = null;
            } else {
                KeyManager[] keyManagerArray2 = new KeyManager[1];
                keyManagerArray = keyManagerArray2;
                keyManagerArray2[0] = x509KeyManager;
            }
            sslContext.init(keyManagerArray, new TrustManager[]{canAuthPeers ? new SecurityDomainTrustManager(x509TrustManager, securityDomain, authenticationOptional, mechanismConfigurationSelector) : x509TrustManager}, null);
            SSLSessionContext sSLSessionContext = sessionContext = clientMode ? sslContext.getClientSessionContext() : sslContext.getServerSessionContext();
            if (sessionContext != null) {
                if (sessionCacheSize >= 0) {
                    sessionContext.setSessionCacheSize(sessionCacheSize);
                }
                if (sessionTimeout >= 0) {
                    sessionContext.setSessionTimeout(sessionTimeout);
                }
            }
            SSLConfiguratorImpl sslConfigurator = clientMode ? new SSLConfiguratorImpl(protocolSelector, cipherSuiteSelector, useCipherSuitesOrder) : new SSLConfiguratorImpl(protocolSelector, cipherSuiteSelector, wantClientAuth || canAuthPeers, needClientAuth, useCipherSuitesOrder);
            ConfiguredSSLContextSpi contextSpi = new ConfiguredSSLContextSpi(sslContext, sslConfigurator, wrap);
            return new DelegatingSSLContext(contextSpi);
        });
    }
}

