/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.client.service;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.service.HotRodServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class RemoteCacheConfigurationServiceInstallerFactory
implements Function<BinaryServiceConfiguration, ServiceInstaller> {
    private final Consumer<RemoteCacheConfigurationBuilder> configurator;

    public RemoteCacheConfigurationServiceInstallerFactory(Consumer<RemoteCacheConfigurationBuilder> configurator) {
        this.configurator = configurator;
    }

    @Override
    public ServiceInstaller apply(BinaryServiceConfiguration configuration) {
        final Consumer<RemoteCacheConfigurationBuilder> configurator = this.configurator;
        final ServiceDependency container = configuration.getServiceDependency(HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER);
        final String cacheName = configuration.getChildName();
        Supplier<RemoteCacheConfiguration> cacheConfiguration = new Supplier<RemoteCacheConfiguration>(){

            @Override
            public RemoteCacheConfiguration get() {
                return ((RemoteCacheContainer)container.get()).getConfiguration().addRemoteCache(cacheName, configurator);
            }
        };
        Consumer<RemoteCacheConfiguration> stopTask = new Consumer<RemoteCacheConfiguration>(){

            @Override
            public void accept(RemoteCacheConfiguration config) {
                ((RemoteCacheContainer)container.get()).getConfiguration().removeRemoteCache(cacheName);
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)cacheConfiguration).blocking()).onStop((Consumer)stopTask)).provides(configuration.resolveServiceName(HotRodServiceDescriptor.REMOTE_CACHE_CONFIGURATION))).requires((Consumer)container)).build();
    }
}

