/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLContext;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.security.CredentialReferenceWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.web.container.SecurityDomainSingleSignOnManagementConfiguration;
import org.wildfly.clustering.web.container.SecurityDomainSingleSignOnManagementProvider;
import org.wildfly.extension.undertow.SingleSignOnDefinition;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.sso.elytron.NonDistributableSingleSignOnManagementProvider;
import org.wildfly.extension.undertow.sso.elytron.SingleSignOnIdentifierFactory;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.http.util.sso.DefaultSingleSignOnSessionFactory;
import org.wildfly.security.http.util.sso.SingleSignOnConfiguration;
import org.wildfly.security.http.util.sso.SingleSignOnManager;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.AttributeDefinitionProvider;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class ApplicationSecurityDomainSingleSignOnDefinition
extends SingleSignOnDefinition {
    static final UnaryServiceDescriptor<SingleSignOnConfiguration> SSO_CONFIGURATION = UnaryServiceDescriptor.of((String)"org.wildfly.undertow.application-security-domain.sso.configuration", SingleSignOnConfiguration.class);
    static final UnaryServiceDescriptor<SingleSignOnSessionFactory> SSO_SESSION_FACTORY = UnaryServiceDescriptor.of((String)"org.wildfly.undertow.application-security-domain.sso.factory", SingleSignOnSessionFactory.class);
    private static final UnaryServiceDescriptor<SingleSignOnManager> SSO_MANAGER = UnaryServiceDescriptor.of((String)"org.wildfly.undertow.application-security-domain.sso.manager", SingleSignOnManager.class);
    private static final RuntimeCapability<Void> CONFIGURATION_CAPABILITY = RuntimeCapability.Builder.of(SSO_CONFIGURATION).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();
    private static final RuntimeCapability<Void> SESSION_FACTORY_CAPABILITY = RuntimeCapability.Builder.of(SSO_SESSION_FACTORY).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();
    private final SecurityDomainSingleSignOnManagementProvider provider = ServiceLoader.load(SecurityDomainSingleSignOnManagementProvider.class, SecurityDomainSingleSignOnManagementProvider.class.getClassLoader()).findFirst().orElse(NonDistributableSingleSignOnManagementProvider.INSTANCE);

    ApplicationSecurityDomainSingleSignOnDefinition(final ResourceOperationRuntimeHandler parentHandler) {
        super(ResourceDefinition::builder, new BiFunction<ResourceDescriptor.Builder, ResourceServiceConfigurator, ResourceDescriptor.Builder>(){

            @Override
            public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder, ResourceServiceConfigurator configurator) {
                return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)builder.provideAttributes(EnumSet.complementOf(EnumSet.of(Attribute.CREDENTIAL)))).addAttribute(Attribute.CREDENTIAL.get(), (OperationStepHandler)new CredentialReferenceWriteAttributeHandler(Attribute.CREDENTIAL.get()))).addCapabilities(List.of(CONFIGURATION_CAPABILITY, SESSION_FACTORY_CAPABILITY))).withRuntimeHandler(ResourceOperationRuntimeHandler.combine((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)configurator), ResourceOperationRuntimeHandler.restartParent((ResourceOperationRuntimeHandler)parentHandler)}));
            }
        });
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ResourceServiceInstaller configurationInstaller = (ResourceServiceInstaller)CapabilityServiceInstaller.builder(CONFIGURATION_CAPABILITY, (Object)this.resolve(context, model)).build();
        final String securityDomainName = context.getCurrentAddress().getParent().getLastElement().getValue();
        final SingleSignOnIdentifierFactory generator = new SingleSignOnIdentifierFactory();
        SecurityDomainSingleSignOnManagementConfiguration configuration = new SecurityDomainSingleSignOnManagementConfiguration(){

            public String getSecurityDomainName() {
                return securityDomainName;
            }

            public Supplier<String> getIdentifierGenerator() {
                return generator;
            }
        };
        ResourceServiceInstaller managerInstaller = this.provider.getServiceInstaller(context, ServiceNameFactory.resolveServiceName(SSO_MANAGER, (String)securityDomainName), configuration);
        final ServiceDependency manager = ServiceDependency.on(SSO_MANAGER, (String)securityDomainName);
        final ServiceDependency keyStore = ServiceDependency.on((UnaryServiceDescriptor)CommonServiceDescriptor.KEY_STORE, (String)Attribute.KEY_STORE.resolveModelAttribute((ExpressionResolver)context, model).asString());
        final String keyAlias = Attribute.KEY_ALIAS.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final ServiceDependency credentialSource = ServiceDependency.from((org.wildfly.service.ServiceDependency)CredentialReference.getCredentialSourceDependency((OperationContext)context, (AttributeDefinition)Attribute.CREDENTIAL.get(), (ModelNode)model));
        String sslContextName = Attribute.SSL_CONTEXT.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        final ServiceDependency sslContext = sslContextName != null ? ServiceDependency.on((UnaryServiceDescriptor)CommonServiceDescriptor.SSL_CONTEXT, (String)sslContextName) : ServiceDependency.of(null);
        Supplier<SingleSignOnSessionFactory> factory = new Supplier<SingleSignOnSessionFactory>(){

            @Override
            public SingleSignOnSessionFactory get() {
                KeyStore store = (KeyStore)keyStore.get();
                CredentialSource source = (CredentialSource)credentialSource.get();
                try {
                    if (!store.containsAlias(keyAlias)) {
                        throw UndertowLogger.ROOT_LOGGER.missingKeyStoreEntry(keyAlias);
                    }
                    if (!store.entryInstanceOf(keyAlias, KeyStore.PrivateKeyEntry.class)) {
                        throw UndertowLogger.ROOT_LOGGER.keyStoreEntryNotPrivate(keyAlias);
                    }
                    PasswordCredential credential = (PasswordCredential)source.getCredential(PasswordCredential.class);
                    if (credential == null) {
                        throw UndertowLogger.ROOT_LOGGER.missingCredential(source.toString());
                    }
                    ClearPassword password = (ClearPassword)credential.getPassword(ClearPassword.class);
                    if (password == null) {
                        throw UndertowLogger.ROOT_LOGGER.credentialNotClearPassword(credential.toString());
                    }
                    KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)store.getEntry(keyAlias, new KeyStore.PasswordProtection(password.getPassword()));
                    KeyPair keyPair = new KeyPair(entry.getCertificate().getPublicKey(), entry.getPrivateKey());
                    Optional<SSLContext> context = Optional.ofNullable((SSLContext)sslContext.get());
                    return new DefaultSingleSignOnSessionFactory((SingleSignOnManager)manager.get(), keyPair, connection -> context.ifPresent(ctx -> connection.setSSLSocketFactory(ctx.getSocketFactory())));
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        ResourceServiceInstaller factoryInstaller = (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(SESSION_FACTORY_CAPABILITY, (Supplier)factory).blocking()).requires(List.of(manager, keyStore, credentialSource, sslContext))).build();
        return ResourceServiceInstaller.combine((ResourceServiceInstaller[])new ResourceServiceInstaller[]{configurationInstaller, managerInstaller, factoryInstaller});
    }

    static enum Attribute implements AttributeDefinitionProvider
    {
        CREDENTIAL((AttributeDefinition)((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((String)"credential-reference", (String)"credential-reference", (boolean)false, (CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(CONFIGURATION_CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.CREDENTIAL_STORE).build()).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.CREDENTIAL})).build()),
        KEY_ALIAS("key-alias", ModelType.STRING, builder -> (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SSL_REF)),
        KEY_STORE("key-store", ModelType.STRING, builder -> (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(CONFIGURATION_CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.KEY_STORE).build())).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SSL_REF)),
        SSL_CONTEXT("client-ssl-context", ModelType.STRING, builder -> (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setRequired(false)).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(CONFIGURATION_CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.SSL_CONTEXT).build())).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SSL_REF}));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, UnaryOperator<SimpleAttributeDefinitionBuilder> configurator) {
            this.definition = ((SimpleAttributeDefinitionBuilder)configurator.apply((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(true))).build();
        }

        private Attribute(AttributeDefinition definition) {
            this.definition = definition;
        }

        public AttributeDefinition get() {
            return this.definition;
        }
    }
}

