/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.core.instmgr.InstMgrCustomPatchHandler;
import org.wildfly.core.instmgr.InstMgrResolver;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.installationmanager.Channel;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.Repository;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

public class InstMgrCustomPatchUploadHandler
extends InstMgrCustomPatchHandler {
    public static final String OPERATION_NAME = "upload-custom-patch";
    protected static final AttributeDefinition CUSTOM_PATCH_FILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"custom-patch-file", (ModelType)ModelType.INT).setStorageRuntime()).setRequired(true)).addArbitraryDescriptor("filesystem-path", ModelNode.TRUE)).addArbitraryDescriptor("attached-streams", ModelNode.TRUE)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("upload-custom-patch", InstMgrResolver.getResourceDescriptionResolver("custom-patch")).addParameter(CUSTOM_PATCH_FILE).addParameter(MANIFEST_GA).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY}).setRuntimeOnly().build();

    public InstMgrCustomPatchUploadHandler(InstMgrService imService, InstallationManagerFactory imf) {
        super(imService, imf);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String manifestGA = MANIFEST_GA.resolveModelAttribute(context, operation).asString();
        final int customPathIndex = CUSTOM_PATCH_FILE.resolveModelAttribute(context, operation).asInt();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.acquireControllerLock();
                try {
                    Path serverHome = InstMgrCustomPatchUploadHandler.this.imService.getHomeDir();
                    String internalManifestGA = manifestGA.replace(":", "_");
                    Path baseTargetDir = InstMgrCustomPatchUploadHandler.this.imService.getCustomPatchDir(internalManifestGA);
                    MavenOptions mavenOptions = new MavenOptions(null, false);
                    InstallationManager im = InstMgrCustomPatchUploadHandler.this.imf.create(serverHome, mavenOptions);
                    Collection channels = im.listChannels();
                    Channel foundChannel = null;
                    for (Channel channel : channels) {
                        if (!channel.getName().startsWith("custom-channel-") || !((String)channel.getManifestCoordinate().get()).equals(manifestGA)) continue;
                        foundChannel = channel;
                    }
                    if (foundChannel != null) {
                        InstMgrCustomPatchUploadHandler.this.deleteDirIfExits(baseTargetDir, true);
                    }
                    baseTargetDir.toFile().mkdirs();
                    try (InputStream is = context.getAttachmentStream(customPathIndex);){
                        InstMgrCustomPatchUploadHandler.this.unzip(is, baseTargetDir);
                    }
                    Path customPatchPath = InstMgrCustomPatchUploadHandler.this.getUploadedMvnRepoRoot(baseTargetDir);
                    Repository customPatchRepository = new Repository("id-" + internalManifestGA, customPatchPath.toUri().toURL().toExternalForm());
                    Channel customChannel = new Channel("custom-channel-" + internalManifestGA, List.of(customPatchRepository), manifestGA);
                    if (foundChannel != null) {
                        im.changeChannel(customChannel);
                    } else {
                        im.addChannel(customChannel);
                    }
                    context.getResult().set(customPatchPath.toString());
                }
                catch (ZipException e) {
                    throw new OperationFailedException(e.getLocalizedMessage());
                }
                catch (RuntimeException | OperationFailedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

