/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.service;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class ConfigurationServiceInstallerFactory
implements Function<BinaryServiceConfiguration, ServiceInstaller> {
    private final Iterable<Consumer<RequirementServiceBuilder<?>>> dependencies;
    private final Consumer<ConfigurationBuilder> configurator;

    public ConfigurationServiceInstallerFactory(Consumer<ConfigurationBuilder> configurator, Iterable<Consumer<RequirementServiceBuilder<?>>> dependencies) {
        this.configurator = configurator;
        this.dependencies = dependencies;
    }

    @Override
    public ServiceInstaller apply(BinaryServiceConfiguration configuration) {
        final ServiceDependency container = configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONTAINER);
        Supplier<Configuration> factory = new Supplier<Configuration>(){

            @Override
            public Configuration get() {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                ConfigurationServiceInstallerFactory.this.configurator.accept(builder);
                builder.simpleCache(builder.clustering().cacheMode() == CacheMode.LOCAL && builder.memory().storage() == StorageType.HEAP && !builder.transaction().transactionMode().isTransactional() && builder.persistence().stores().isEmpty() && !builder.statistics().create().enabled());
                builder.encoding().mediaType(builder.memory().storage().canStoreReferences() ? "application/x-java-object" : ((EmbeddedCacheManager)container.get()).getCacheManagerConfiguration().serialization().marshaller().mediaType().toString());
                return builder.build();
            }
        };
        final String cacheName = configuration.getChildName();
        Consumer<Configuration> startTask = new Consumer<Configuration>(){

            @Override
            public void accept(Configuration configuration) {
                ((EmbeddedCacheManager)container.get()).defineConfiguration(cacheName, configuration);
            }
        };
        Consumer<Configuration> stopTask = new Consumer<Configuration>(){

            @Override
            public void accept(Configuration configuration) {
                ((EmbeddedCacheManager)container.get()).undefineConfiguration(cacheName);
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).provides(configuration.resolveServiceName(InfinispanServiceDescriptor.CACHE_CONFIGURATION))).requires((Consumer)container)).requires(this.dependencies)).onStart((Consumer)startTask)).onStop((Consumer)stopTask)).build();
    }
}

