/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.star.client;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jbossts.star.annotation.Commit;
import org.jboss.jbossts.star.annotation.Participant;
import org.jboss.jbossts.star.annotation.Prepare;
import org.jboss.jbossts.star.annotation.Rollback;
import org.jboss.jbossts.star.annotation.Status;
import org.jboss.jbossts.star.client.InvalidSRAId;
import org.jboss.jbossts.star.client.SRAClient;
import org.jboss.jbossts.star.client.SRAStatus;

@RequestScoped
public abstract class SRAParticipant {
    @Context
    private UriInfo context;
    @Context
    private HttpServletRequest httpRequest;
    private Map<String, SRAStatus> sraParticipantStatusMap;

    protected abstract SRAStatus updateParticipantState(SRAStatus var1, String var2);

    protected String getCompensatorData(String activityId) {
        return null;
    }

    protected String getCurrentActivityId() {
        return this.httpRequest.getHeader("Short-Running-Action");
    }

    @HEAD
    @Path(value="/participant")
    @Produces(value={"application/json"})
    @Participant
    public Response getTerminator() {
        String uriPrefix = this.httpRequest.getRequestURI();
        StringBuilder linkHeaderValue = new StringBuilder();
        this.makeLink(linkHeaderValue, uriPrefix, "commit", "/commit");
        this.makeLink(linkHeaderValue, uriPrefix, "prepare", "/prepare");
        this.makeLink(linkHeaderValue, uriPrefix, "rollback", "/rollback");
        return Response.ok().header("Link", (Object)linkHeaderValue.toString()).entity((Object)linkHeaderValue.toString()).build();
    }

    private StringBuilder makeLink(StringBuilder b, String uriPrefix, String key, String value) {
        String terminationUri = uriPrefix == null ? value : String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).title(key + " URI").rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    @PUT
    @Path(value="/commit/{txid}")
    @Produces(value={"application/json"})
    @Commit
    public Response commitWork(@HeaderParam(value="Short-Running-Action") String atId, @PathParam(value="txid") String sraId) throws NotFoundException {
        return this.updateState(SRAStatus.TransactionCommitted, sraId);
    }

    @PUT
    @Path(value="/prepare/{txid}")
    @Produces(value={"application/json"})
    @Prepare
    public Response prepareWork(@PathParam(value="txid") String sraId) throws NotFoundException {
        return this.updateState(SRAStatus.TransactionPrepared, sraId);
    }

    @PUT
    @Path(value="/rollback/{txid}")
    @Produces(value={"application/json"})
    @Rollback
    public Response rollbackWork(@PathParam(value="txid") String sraId) throws NotFoundException {
        return this.updateState(SRAStatus.TransactionRolledBack, sraId);
    }

    @GET
    @Path(value="/status/{txid}")
    @Produces(value={"application/json"})
    @Status
    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public Response status(@PathParam(value="txid") String sraId) throws NotFoundException {
        if (sraId == null) {
            throw new InvalidSRAId("null", "not present on SRAParticipant#status request", null);
        }
        if (!this.sraParticipantStatusMap.containsKey(sraId)) {
            throw new InvalidSRAId(sraId, "SRAParticipant#status request: unknown sra id", null);
        }
        return this.updateState(this.sraParticipantStatusMap.get(sraId), sraId);
    }

    @PostConstruct
    public void postConstruct() {
        this.sraParticipantStatusMap = new HashMap<String, SRAStatus>();
    }

    private Response updateState(SRAStatus status, String activityId) {
        SRAStatus newStatus = this.updateParticipantState(status, activityId);
        this.sraParticipantStatusMap.put(activityId, newStatus);
        switch (newStatus) {
            case TransactionCommitted: 
            case TransactionRolledBack: {
                String data = this.getCompensatorData(activityId);
                return data == null ? Response.ok().build() : Response.ok((Object)data).build();
            }
            case TransactionPrepared: {
                return Response.status((Response.Status)Response.Status.OK).build();
            }
        }
        String statusUrl = this.getStatusUrl(activityId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)Entity.text((Object)statusUrl)).build();
    }

    private String getStatusUrl(String sraId) {
        return String.format("%s/%s/activity/status", this.context.getBaseUri(), SRAClient.getSRAId(sraId));
    }
}

