/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.verification;

import jakarta.jws.WebMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.webservices.logging.WSLogger;

public final class JwsWebServiceEndpointVerifier {
    private final DeploymentReflectionIndex deploymentReflectionIndex;
    private final Class<?> endpointClass;
    private final Class<?> endpointInterfaceClass;
    final List<VerificationFailure> verificationFailures = new LinkedList<VerificationFailure>();

    public JwsWebServiceEndpointVerifier(Class<?> endpointClass, Class<?> endpointInterfaceClass, DeploymentReflectionIndex deploymentReflectionIndex) {
        this.deploymentReflectionIndex = deploymentReflectionIndex;
        this.endpointClass = endpointClass;
        this.endpointInterfaceClass = endpointInterfaceClass;
    }

    public void verify() {
        if (this.endpointInterfaceClass != null) {
            for (Method endpointInterfaceDefinedWebMethod : this.endpointInterfaceDefinedWebMethods()) {
                this.verifyWebMethod(endpointInterfaceDefinedWebMethod);
            }
        }
        this.verifyFinalizeMethod();
    }

    public boolean failed() {
        return !this.verificationFailures.isEmpty();
    }

    public void logFailures() {
        for (VerificationFailure verificationFailure : this.verificationFailures) {
            verificationFailure.logFailure();
        }
    }

    void verifyWebMethod(Method endpointInterfaceDefinedWebMethod) {
        Method endpointImplementationMethod = this.findEndpointImplMethodMatching(endpointInterfaceDefinedWebMethod);
        if (endpointImplementationMethod != null) {
            int methodModifiers = endpointImplementationMethod.getModifiers();
            WebMethod possibleWebMethodAnnotation = endpointImplementationMethod.getAnnotation(WebMethod.class);
            if (possibleWebMethodAnnotation == null || !possibleWebMethodAnnotation.exclude()) {
                if (Modifier.isPublic(methodModifiers)) {
                    if (Modifier.isStatic(methodModifiers) || Modifier.isFinal(methodModifiers)) {
                        this.verificationFailures.add(new WebMethodIsStaticOrFinal(endpointImplementationMethod));
                    }
                } else {
                    this.verificationFailures.add(new WebMethodIsNotPublic(endpointImplementationMethod));
                }
            }
        }
    }

    void verifyFinalizeMethod() {
        ClassReflectionIndex classReflectionIndex = this.deploymentReflectionIndex.getClassIndex(this.endpointClass);
        Method finalizeMethod = classReflectionIndex.getMethod(Void.TYPE, "finalize", new Class[0]);
        if (finalizeMethod != null) {
            this.verificationFailures.add(new ImplementationHasFinalize());
        }
    }

    Collection<Method> endpointInterfaceDefinedWebMethods() {
        return this.deploymentReflectionIndex.getClassIndex(this.endpointInterfaceClass).getMethods();
    }

    Method findEndpointImplMethodMatching(Method endpointInterfaceDefinedWebMethod) {
        try {
            return this.endpointClass.getMethod(endpointInterfaceDefinedWebMethod.getName(), endpointInterfaceDefinedWebMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            try {
                return this.endpointClass.getDeclaredMethod(endpointInterfaceDefinedWebMethod.getName(), endpointInterfaceDefinedWebMethod.getParameterTypes());
            }
            catch (NoSuchMethodException e1) {
                this.verificationFailures.add(new WebServiceMethodNotFound(endpointInterfaceDefinedWebMethod));
            }
        }
        catch (SecurityException e) {
            this.verificationFailures.add(new WebServiceMethodNotAccessible(endpointInterfaceDefinedWebMethod, e));
        }
        return null;
    }

    abstract class VerificationFailure {
        VerificationFailure() {
        }

        abstract void logFailure();
    }

    final class WebMethodIsStaticOrFinal
    extends MethodVerificationFailure {
        WebMethodIsStaticOrFinal(Method failedMethod) {
            super(failedMethod);
        }

        @Override
        public void logFailure() {
            WSLogger.ROOT_LOGGER.webMethodMustNotBeStaticOrFinal(this.failedMethod);
        }
    }

    final class WebMethodIsNotPublic
    extends MethodVerificationFailure {
        WebMethodIsNotPublic(Method failedMethod) {
            super(failedMethod);
        }

        @Override
        public void logFailure() {
            WSLogger.ROOT_LOGGER.webMethodMustBePublic(this.failedMethod);
        }
    }

    final class ImplementationHasFinalize
    extends VerificationFailure {
        ImplementationHasFinalize() {
        }

        @Override
        public void logFailure() {
            WSLogger.ROOT_LOGGER.finalizeMethodNotAllowed(JwsWebServiceEndpointVerifier.this.endpointClass);
        }
    }

    final class WebServiceMethodNotFound
    extends MethodVerificationFailure {
        WebServiceMethodNotFound(Method failedMethod) {
            super(failedMethod);
        }

        @Override
        public void logFailure() {
            WSLogger.ROOT_LOGGER.webServiceMethodNotFound(JwsWebServiceEndpointVerifier.this.endpointClass, this.failedMethod);
        }
    }

    final class WebServiceMethodNotAccessible
    extends MethodVerificationFailure {
        private final SecurityException securityException;

        WebServiceMethodNotAccessible(Method failedMethod, SecurityException e) {
            super(failedMethod);
            this.securityException = e;
        }

        @Override
        public void logFailure() {
            WSLogger.ROOT_LOGGER.accessibleWebServiceMethodNotFound(JwsWebServiceEndpointVerifier.this.endpointClass, this.failedMethod, this.securityException);
        }
    }

    abstract class MethodVerificationFailure
    extends VerificationFailure {
        protected final Method failedMethod;

        protected MethodVerificationFailure(Method failedMethod) {
            this.failedMethod = failedMethod;
        }
    }
}

