/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Predicate;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.ejb.cache.timer.DefaultTimeoutMatcher;
import org.wildfly.clustering.ejb.cache.timer.ImmutableScheduleExpressionBuilder;
import org.wildfly.clustering.ejb.cache.timer.ImmutableScheduleExpressionMarshaller;
import org.wildfly.clustering.ejb.cache.timer.ScheduleTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimeoutDescriptor;
import org.wildfly.clustering.ejb.timer.ImmutableScheduleExpression;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.marshalling.protostream.FieldReadable;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Writable;

public class ScheduleTimerMetaDataEntryMarshaller
implements ProtoStreamMarshaller<ScheduleTimerMetaDataEntry<Object>> {
    private static final int INFO_INDEX = 1;
    private static final int START_INDEX = 2;
    private static final int LAST_TIMEOUT_INDEX = 3;
    private static final int TIMEOUT_DESCRIPTOR_INDEX = 4;
    private static final int SCHEDULE_EXPRESSION_INDEX = 5;

    public Class<? extends ScheduleTimerMetaDataEntry<Object>> getJavaClass() {
        return ScheduleTimerMetaDataEntry.class;
    }

    public ScheduleTimerMetaDataEntry<Object> readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader expressionReader = reader.createFieldSetReader((FieldReadable)ImmutableScheduleExpressionMarshaller.INSTANCE, 5);
        MarshalledValue context = null;
        Instant start = Instant.EPOCH;
        Duration lastTimeout = null;
        ImmutableScheduleExpressionBuilder expressionBuilder = ImmutableScheduleExpressionMarshaller.INSTANCE.createInitialValue();
        Predicate<Method> timeoutMatcher = DefaultTimeoutMatcher.INSTANCE;
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    context = (MarshalledValue)reader.readObject(ByteBufferMarshalledValue.class);
                    continue block6;
                }
                case 2: {
                    start = (Instant)reader.readObject(Instant.class);
                    continue block6;
                }
                case 3: {
                    lastTimeout = (Duration)reader.readObject(Duration.class);
                    continue block6;
                }
                case 4: {
                    timeoutMatcher = (Predicate)reader.readObject(TimeoutDescriptor.class);
                    continue block6;
                }
            }
            if (expressionReader.contains(index)) {
                expressionBuilder = (ImmutableScheduleExpressionBuilder)expressionReader.readField((Object)expressionBuilder);
                continue;
            }
            reader.skipField(tag);
        }
        ScheduleTimerMetaDataEntry<Object> entry = new ScheduleTimerMetaDataEntry<Object>(context, start, (ImmutableScheduleExpression)expressionBuilder.get(), timeoutMatcher);
        entry.setLastTimeout(lastTimeout);
        return entry;
    }

    public void writeTo(ProtoStreamWriter writer, ScheduleTimerMetaDataEntry<Object> entry) throws IOException {
        Predicate<Method> matcher;
        Duration lastTimeout;
        Instant start;
        Object context = entry.getContext();
        if (context != null) {
            writer.writeObject(1, context);
        }
        if (!(start = entry.getStart()).equals(Instant.EPOCH)) {
            writer.writeObject(2, (Object)start);
        }
        if ((lastTimeout = entry.getLastTimeout()) != null) {
            writer.writeObject(3, (Object)lastTimeout);
        }
        if ((matcher = entry.getTimeoutMatcher()) != DefaultTimeoutMatcher.INSTANCE) {
            writer.writeObject(4, matcher);
        }
        writer.createFieldSetWriter((Writable)ImmutableScheduleExpressionMarshaller.INSTANCE, 5).writeFields((Object)entry.getScheduleExpression());
    }
}

