/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.batch;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.SuspendedBatch;

public interface Batch
extends AutoCloseable {
    public SuspendedBatch suspend();

    default public BatchContext<SuspendedBatch> suspendWithContext() {
        final SuspendedBatch suspended = this.suspend();
        return new BatchContext<SuspendedBatch>(this){
            final /* synthetic */ Batch this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public SuspendedBatch get() {
                return suspended;
            }

            public void close() {
                suspended.resume();
            }
        };
    }

    public void discard();

    public boolean isActive();

    public boolean isDiscarding();

    public boolean isClosed();

    @Override
    public void close();

    public static Supplier<Batch> factory() {
        final AtomicReference<4> reference = new AtomicReference<4>();
        final BatchContext<Batch> resumedBatchContext = new BatchContext<Batch>(){

            @Override
            public Batch get() {
                return (Batch)reference.getPlain();
            }

            public void close() {
            }
        };
        final SuspendedBatch suspendedBatch = new SuspendedBatch(){

            @Override
            public Batch resume() {
                return (Batch)reference.getPlain();
            }

            @Override
            public BatchContext<Batch> resumeWithContext() {
                return resumedBatchContext;
            }
        };
        reference.setPlain(new Batch(){

            @Override
            public SuspendedBatch suspend() {
                return suspendedBatch;
            }

            @Override
            public void discard() {
            }

            @Override
            public boolean isActive() {
                return true;
            }

            @Override
            public boolean isDiscarding() {
                return false;
            }

            @Override
            public boolean isClosed() {
                return false;
            }

            @Override
            public void close() {
            }
        });
        return reference::getPlain;
    }
}

