/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Set;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.Query;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.search.mapper.orm.loading.impl.ConditionalExpressionQueryFactory;

class HqlTypeQueryFactory<E, I>
extends ConditionalExpressionQueryFactory<E, I> {
    private final Class<E> entityClass;
    private final String ormEntityName;

    HqlTypeQueryFactory(Class<E> entityClass, String ormEntityName, Class<I> uniquePropertyType, String uniquePropertyName, boolean uniquePropertyIsTheEntityId) {
        super(uniquePropertyType, uniquePropertyName, uniquePropertyIsTheEntityId);
        this.entityClass = entityClass;
        this.ormEntityName = ormEntityName;
    }

    @Override
    public Query<Long> createQueryForCount(SharedSessionContractImplementor session, Set<? extends Class<? extends E>> includedTypesFilter) {
        return this.createQueryWithTypesFilter(session, "select count(e) from " + this.ormEntityName + " e", Long.class, "e", includedTypesFilter);
    }

    @Override
    public Query<I> createQueryForIdentifierListing(SharedSessionContractImplementor session, Set<? extends Class<? extends E>> includedTypesFilter) {
        return this.createQueryWithTypesFilter(session, "select e. " + this.uniquePropertyName + " from " + this.ormEntityName + " e", this.uniquePropertyType, "e", includedTypesFilter);
    }

    @Override
    public Query<E> createQueryForLoadByUniqueProperty(SessionImplementor session, String parameterName) {
        return session.createQuery("select e from " + this.ormEntityName + " e where " + this.uniquePropertyName + " in (:" + parameterName + ")", this.entityClass);
    }

    @Override
    public MultiIdentifierLoadAccess<E> createMultiIdentifierLoadAccess(SessionImplementor session) {
        return session.byMultipleIds(this.ormEntityName);
    }

    private <T> Query<T> createQueryWithTypesFilter(SharedSessionContractImplementor session, String hql, Class<T> returnedType, String entityAlias, Set<? extends Class<? extends E>> includedTypesFilter) {
        if (!includedTypesFilter.isEmpty()) {
            hql = (String)hql + " where type(" + entityAlias + ") in (:types)";
        }
        QueryImplementor query = session.createQuery((String)hql, returnedType);
        if (!includedTypesFilter.isEmpty()) {
            query.setParameterList("types", includedTypesFilter);
        }
        return query;
    }
}

