/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.clustering.infinispan.transport.ChannelConfigurator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.JChannel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ForkChannelFactory;
import org.wildfly.clustering.jgroups.spi.ForkStackConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.server.service.CacheContainerServiceInstallerProvider;
import org.wildfly.clustering.server.service.ProvidedBiServiceInstallerProvider;
import org.wildfly.clustering.server.util.MapEntry;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReferenceRecorder;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class JGroupsTransportResourceDefinition
extends TransportResourceDefinition {
    static final PathElement PATH = JGroupsTransportResourceDefinition.pathElement("jgroups");
    static final UnaryServiceDescriptor<JChannel> TRANSPORT_CHANNEL = UnaryServiceDescriptor.of((String)"org.wildfly.clustering.infinispan.cache-container.transport.channel", JChannel.class);
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(TRANSPORT_CHANNEL).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();

    JGroupsTransportResourceDefinition() {
        super(PATH, new ResourceDescriptorConfigurator());
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress containerAddress = address.getParent();
        final String containerName = containerAddress.getLastElement().getValue();
        final long lockTimeout = Attribute.LOCK_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        String channel = Attribute.CHANNEL.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        LinkedList<ResourceServiceInstaller> installers = new LinkedList<ResourceServiceInstaller>();
        Function<ForkChannelFactory, TransportConfiguration> factory = new Function<ForkChannelFactory, TransportConfiguration>(){

            @Override
            public TransportConfiguration apply(ForkChannelFactory channelFactory) {
                Properties properties = new Properties();
                properties.put("channelConfigurator", new ChannelConfigurator((ChannelFactory)channelFactory, containerName));
                ProtocolStackConfiguration stack = channelFactory.getProtocolStackConfiguration();
                TransportConfiguration.Topology topology = stack.getTransport().getTopology();
                JChannel channel = channelFactory.getForkStackConfiguration().getChannel();
                TransportConfigurationBuilder builder = new GlobalConfigurationBuilder().transport().clusterName(channel.getClusterName()).distributedSyncTimeout(lockTimeout).nodeName(channel.getName()).transport((Transport)new JGroupsTransport()).withProperties(properties);
                if (topology != null) {
                    builder.siteId(topology.getSite()).rackId(topology.getRack()).machineId(topology.getMachine());
                }
                return builder.create();
            }
        };
        installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(TransportResourceDefinition.CAPABILITY, (ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR, (String)channel).map(ForkChannelFactory.class::cast).map((Function)factory)).build());
        installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(CAPABILITY, (ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR, (String)channel).map(ForkChannelFactory.class::cast).map(ForkChannelFactory::getForkStackConfiguration).map(ForkStackConfiguration::getChannel)).build());
        new ProvidedBiServiceInstallerProvider(CacheContainerServiceInstallerProvider.class, CacheContainerServiceInstallerProvider.class.getClassLoader()).apply(context.getCapabilityServiceSupport(), (Map.Entry)MapEntry.of((Object)containerName, (Object)channel)).forEach(installers::add);
        return ResourceServiceInstaller.combine(installers);
    }

    static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        ResourceDescriptorConfigurator() {
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return descriptor.addAttributes(Attribute.class).addCapabilities(List.of(CAPABILITY)).addResourceCapabilityReference((CapabilityReferenceRecorder)ResourceCapabilityReferenceRecorder.builder(CAPABILITY, (NullaryServiceDescriptor)ChannelFactory.DEFAULT_SERVICE_DESCRIPTOR).build());
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        CHANNEL("channel", ModelType.STRING, null){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(false)).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(CAPABILITY, (UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR).build());
            }
        }
        ,
        LOCK_TIMEOUT("lock-timeout", ModelType.LONG, new ModelNode(TimeUnit.MINUTES.toMillis(4L))){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.MILLISECONDS);
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

