/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;

final class Reflect {
    Reflect() {
    }

    static Field findField(final Class<?> sourceClass, final Class<?> fieldType) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                Class<?> type;
                Field[] fields;
                LinkedList<Field> assignableFields = new LinkedList<Field>();
                for (Field field : fields = sourceClass.getDeclaredFields()) {
                    type = field.getType();
                    if (Modifier.isStatic(field.getModifiers()) || type != fieldType) continue;
                    assignableFields.add(field);
                }
                if (assignableFields.isEmpty()) {
                    for (Field field : fields) {
                        type = field.getType();
                        if (Modifier.isStatic(field.getModifiers()) || type == Object.class || !type.isAssignableFrom(fieldType)) continue;
                        assignableFields.add(field);
                    }
                }
                if (assignableFields.size() > 1) {
                    throw new IllegalStateException(((Object)assignableFields).toString());
                }
                if (!assignableFields.isEmpty()) {
                    Field field = (Field)assignableFields.get(0);
                    field.setAccessible(true);
                    return field;
                }
                Class superClass = sourceClass.getSuperclass();
                if (superClass == null || superClass == Object.class) {
                    throw new IllegalArgumentException(fieldType.getName());
                }
                return Reflect.findField(superClass, fieldType);
            }
        });
    }

    static Object getValue(Object source, Field field) {
        return Reflect.getValue(source, field, Object.class);
    }

    static <T> T getValue(final Object source, final Field field, final Class<T> fieldType) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return fieldType.cast(field.get(source));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

