/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.ParameterisedAddress;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPLargeMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpJmsSelectorFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpNoLocalFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.SenderController;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ProtonHandler;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSenderController
implements SenderController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AMQPConnectionContext connection;
    private final AMQPSessionCallback sessionSPI;
    private final Sender protonSender;
    private final String clientId;
    private AMQPMessageWriter standardMessageWriter;
    private AMQPLargeMessageWriter largeMessageWriter;
    private boolean shared;
    private boolean global;
    private boolean multicast;
    private SimpleString queue;
    private SimpleString tempQueueName;
    private String selector;
    private RoutingType routingTypeToUse = RoutingType.ANYCAST;
    private boolean isVolatile;

    public DefaultSenderController(AMQPSessionContext session, Sender protonSender, String clientId) {
        this.connection = session.getAMQPConnectionContext();
        this.sessionSPI = session.getSessionSPI();
        this.protonSender = protonSender;
        this.clientId = clientId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Consumer init(ProtonServerSenderContext senderContext) throws Exception {
        Map.Entry<Symbol, DescribedType> filter;
        this.validateConnectionState();
        this.standardMessageWriter = new AMQPMessageWriter(senderContext);
        this.largeMessageWriter = new AMQPLargeMessageWriter(senderContext);
        Map addressParameters = Collections.EMPTY_MAP;
        Source source = (Source)this.protonSender.getRemoteSource();
        HashMap<Symbol, DescribedType> supportedFilters = new HashMap<Symbol, DescribedType>();
        this.protonSender.setSenderSettleMode(this.protonSender.getRemoteSenderSettleMode());
        this.protonSender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        if (source != null && (filter = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.JMS_SELECTOR_FILTER_IDS)) != null) {
            this.selector = filter.getValue().getDescribed().toString();
            try {
                SelectorParser.parse((String)this.selector);
            }
            catch (FilterException e) {
                throw new ActiveMQAMQPException(AmqpError.INVALID_FIELD, "Invalid filter", ActiveMQExceptionType.INVALID_FILTER_EXPRESSION);
            }
            supportedFilters.put(filter.getKey(), filter.getValue());
        }
        if (source == null) {
            String pubId = this.protonSender.getName();
            this.global = AmqpSupport.verifyDesiredCapability((Link)this.protonSender, AmqpSupport.GLOBAL);
            this.shared = AmqpSupport.verifyDesiredCapability((Link)this.protonSender, AmqpSupport.SHARED);
            this.queue = AmqpSupport.createQueueName(this.connection.isUseCoreSubscriptionNaming(), this.clientId, pubId, true, this.global, false);
            QueueQueryResult result = this.sessionSPI.queueQuery(this.queue, RoutingType.MULTICAST, false);
            this.multicast = true;
            this.routingTypeToUse = RoutingType.MULTICAST;
            if (!result.isExists()) throw new ActiveMQAMQPNotFoundException("Unknown subscription link: " + this.protonSender.getName());
            source = new Source();
            source.setAddress(this.queue.toString());
            source.setDurable(TerminusDurability.UNSETTLED_STATE);
            source.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
            source.setDistributionMode(AmqpSupport.COPY);
            source.setCapabilities(new Symbol[]{AmqpSupport.TOPIC_CAPABILITY});
            SimpleString filterString = result.getFilterString();
            if (filterString != null) {
                this.selector = filterString.toString();
                boolean noLocal = false;
                String remoteContainerId = this.protonSender.getSession().getConnection().getRemoteContainer();
                String noLocalFilter = MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + remoteContainerId + "'";
                if (this.selector.endsWith(noLocalFilter)) {
                    if (this.selector.length() > noLocalFilter.length()) {
                        noLocalFilter = " AND " + noLocalFilter;
                        this.selector = this.selector.substring(0, this.selector.length() - noLocalFilter.length());
                    } else {
                        this.selector = null;
                    }
                    noLocal = true;
                }
                if (noLocal) {
                    supportedFilters.put(AmqpSupport.NO_LOCAL_NAME, AmqpNoLocalFilter.NO_LOCAL);
                }
                if (this.selector != null && !this.selector.trim().isEmpty()) {
                    supportedFilters.put(AmqpSupport.JMS_SELECTOR_NAME, new AmqpJmsSelectorFilter(this.selector));
                }
            }
            this.protonSender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        } else if (source.getDynamic()) {
            this.tempQueueName = this.queue = SimpleString.of((String)UUID.randomUUID().toString());
            try {
                this.sessionSPI.createTemporaryQueue(this.queue, RoutingType.ANYCAST);
            }
            catch (Exception e) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
            }
            source.setAddress(this.queue.toString());
        } else {
            SimpleString matchingAnycastQueue;
            AddressQueryResult addressQueryResult;
            boolean clientDefined;
            SimpleString addressToUse;
            boolean isFQQN;
            String sourceAddress = ParameterisedAddress.extractAddress((String)source.getAddress());
            addressParameters = ParameterisedAddress.extractParameters((String)source.getAddress());
            SimpleString queueNameToUse = null;
            this.shared = AmqpSupport.verifySourceCapability(source, AmqpSupport.SHARED);
            this.global = AmqpSupport.verifySourceCapability(source, AmqpSupport.GLOBAL);
            if (CompositeAddress.isFullyQualified((String)sourceAddress)) {
                isFQQN = true;
                addressToUse = SimpleString.of((String)CompositeAddress.extractAddressName((String)sourceAddress));
                queueNameToUse = SimpleString.of((String)CompositeAddress.extractQueueName((String)sourceAddress));
            } else {
                isFQQN = false;
                addressToUse = SimpleString.of((String)sourceAddress);
            }
            boolean bl = clientDefined = AmqpSupport.verifySourceCapability(source, AmqpSupport.TOPIC_CAPABILITY) || AmqpSupport.verifySourceCapability(source, AmqpSupport.QUEUE_CAPABILITY);
            if (clientDefined) {
                this.multicast = AmqpSupport.verifySourceCapability(source, AmqpSupport.TOPIC_CAPABILITY);
                addressQueryResult = null;
                try {
                    addressQueryResult = this.sessionSPI.addressQuery(addressToUse, this.multicast ? RoutingType.MULTICAST : RoutingType.ANYCAST, true);
                }
                catch (ActiveMQSecurityException e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingConsumer(e.getMessage());
                }
                catch (ActiveMQAMQPException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
                if (!addressQueryResult.isExists()) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
                }
                Set routingTypes = addressQueryResult.getRoutingTypes();
                if (this.multicast && !routingTypes.contains(RoutingType.MULTICAST)) {
                    throw new ActiveMQAMQPIllegalStateException("Address " + addressToUse + " is not configured for topic support");
                }
                if (!this.multicast && !routingTypes.contains(RoutingType.ANYCAST) && queueNameToUse == null) {
                    throw new ActiveMQAMQPIllegalStateException("Address " + addressToUse + " is not configured for queue support");
                }
            } else {
                addressQueryResult = null;
                RoutingType routingType = this.sessionSPI.getDefaultRoutingType(addressToUse);
                this.routingTypeToUse = routingType == null ? ActiveMQDefaultConfiguration.getDefaultRoutingType() : routingType;
                try {
                    addressQueryResult = this.sessionSPI.addressQuery(addressToUse, this.routingTypeToUse, true);
                }
                catch (ActiveMQSecurityException e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingConsumer(e.getMessage());
                }
                catch (ActiveMQAMQPException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
                if (!addressQueryResult.isExists()) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
                }
                Set routingTypes = addressQueryResult.getRoutingTypes();
                this.multicast = routingTypes.contains(RoutingType.MULTICAST) && routingTypes.size() == 1;
            }
            RoutingType routingType = this.routingTypeToUse = this.multicast ? RoutingType.MULTICAST : RoutingType.ANYCAST;
            if (this.multicast) {
                Map.Entry<Symbol, DescribedType> filter2 = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.NO_LOCAL_FILTER_IDS);
                if (filter2 != null) {
                    String remoteContainerId = this.protonSender.getSession().getConnection().getRemoteContainer();
                    String noLocalFilter = MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + remoteContainerId + "'";
                    this.selector = this.selector != null ? this.selector + " AND " + noLocalFilter : noLocalFilter;
                    supportedFilters.put(filter2.getKey(), filter2.getValue());
                }
                SimpleString simpleStringSelector = SimpleString.of((String)this.selector);
                this.queue = this.getMatchingQueue(queueNameToUse, addressToUse, RoutingType.MULTICAST, simpleStringSelector, isFQQN);
                if (this.queue != null) {
                    this.multicast = false;
                } else if (TerminusDurability.UNSETTLED_STATE.equals((Object)source.getDurable()) || TerminusDurability.CONFIGURATION.equals((Object)source.getDurable())) {
                    String pubId = this.protonSender.getName();
                    this.queue = AmqpSupport.createQueueName(this.connection.isUseCoreSubscriptionNaming(), this.clientId, pubId, this.shared, this.global, false);
                    QueueQueryResult result = this.sessionSPI.queueQuery(this.queue, this.routingTypeToUse, false);
                    if (result.isExists()) {
                        if (!(result.isConfigurationManaged().booleanValue() || Objects.equals(result.getAddress(), this.sessionSPI.removePrefix(addressToUse)) && Objects.equals(result.getFilterString(), simpleStringSelector))) {
                            if (result.getConsumerCount() != 0) throw new ActiveMQAMQPIllegalStateException("Unable to recreate subscription, consumers already exist");
                            this.sessionSPI.deleteQueue(this.queue);
                            if (this.shared) {
                                this.sessionSPI.createSharedDurableQueue(addressToUse, RoutingType.MULTICAST, this.queue, simpleStringSelector);
                            } else {
                                this.sessionSPI.createUnsharedDurableQueue(addressToUse, RoutingType.MULTICAST, this.queue, simpleStringSelector);
                            }
                        }
                    } else if (this.shared) {
                        this.sessionSPI.createSharedDurableQueue(addressToUse, RoutingType.MULTICAST, this.queue, simpleStringSelector);
                    } else {
                        this.sessionSPI.createUnsharedDurableQueue(addressToUse, RoutingType.MULTICAST, this.queue, simpleStringSelector);
                    }
                } else {
                    this.isVolatile = true;
                    if (this.shared && this.protonSender.getName() != null) {
                        this.queue = AmqpSupport.createQueueName(this.connection.isUseCoreSubscriptionNaming(), this.clientId, this.protonSender.getName(), this.shared, this.global, this.isVolatile);
                        QueueQueryResult result = this.sessionSPI.queueQuery(this.queue, this.routingTypeToUse, false);
                        if (!(result.isExists() && Objects.equals(result.getAddress(), addressToUse) && Objects.equals(result.getFilterString(), simpleStringSelector) || result.isConfigurationManaged().booleanValue())) {
                            this.sessionSPI.createSharedVolatileQueue(addressToUse, RoutingType.MULTICAST, this.queue, simpleStringSelector);
                        }
                    } else {
                        this.tempQueueName = this.queue = SimpleString.of((String)UUID.randomUUID().toString());
                        try {
                            this.sessionSPI.createTemporaryQueue(addressToUse, this.queue, RoutingType.MULTICAST, simpleStringSelector);
                        }
                        catch (Exception e) {
                            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
                        }
                    }
                }
            } else if (queueNameToUse != null) {
                QueueQueryResult result = this.sessionSPI.queueQuery(CompositeAddress.toFullyQualified((SimpleString)addressToUse, (SimpleString)queueNameToUse), null, false, null);
                if (result.isExists()) {
                    this.routingTypeToUse = null;
                }
                if ((matchingAnycastQueue = this.getMatchingQueue(queueNameToUse, addressToUse, this.routingTypeToUse, null, false)) == null) throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
                this.queue = matchingAnycastQueue;
            } else {
                matchingAnycastQueue = this.sessionSPI.getMatchingQueue(addressToUse, RoutingType.ANYCAST);
                this.queue = matchingAnycastQueue != null ? matchingAnycastQueue : addressToUse;
            }
            if (this.queue == null) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressNotSet();
            }
            try {
                if (!this.sessionSPI.queueQuery(this.queue, this.routingTypeToUse, !this.multicast).isExists()) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
                }
            }
            catch (ActiveMQAMQPNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
            }
        }
        source.setFilter(supportedFilters.isEmpty() ? null : supportedFilters);
        boolean browseOnly = !this.multicast && source.getDistributionMode() != null && source.getDistributionMode().equals(AmqpSupport.COPY);
        Number consumerPriority = AmqpSupport.getReceiverPriority(this.protonSender.getRemoteProperties(), DefaultSenderController.extractConsumerPriority(addressParameters));
        if (addressParameters.isEmpty()) return this.sessionSPI.createSender(senderContext, this.queue, this.multicast ? null : this.selector, browseOnly, consumerPriority);
        String unusedParametersMessage = " Not all specified address options were applicable to the created server consumer. Check the options are spelled correctly. Unused parameters=[" + addressParameters + "].";
        logger.debug(unusedParametersMessage);
        return this.sessionSPI.createSender(senderContext, this.queue, this.multicast ? null : this.selector, browseOnly, consumerPriority);
    }

    private static Number extractConsumerPriority(Map<String, String> addressParameters) {
        String priorityString;
        if (addressParameters != null && !addressParameters.isEmpty() && (priorityString = addressParameters.remove("consumer-priority")) != null) {
            return Integer.valueOf(priorityString);
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        Source source = (Source)this.protonSender.getSource();
        String sourceAddress = DefaultSenderController.getSourceAddress(source);
        if (source != null && sourceAddress != null && this.multicast) {
            SimpleString queueName = SimpleString.of((String)sourceAddress);
            QueueQueryResult result = this.sessionSPI.queueQuery(queueName, this.routingTypeToUse, false);
            if (result.isExists() && source.getDynamic()) {
                this.sessionSPI.deleteQueue(queueName);
            } else if (source.getDurable() == TerminusDurability.NONE && this.tempQueueName != null && (source.getExpiryPolicy() == TerminusExpiryPolicy.LINK_DETACH || source.getExpiryPolicy() == TerminusExpiryPolicy.SESSION_END)) {
                this.sessionSPI.removeTemporaryQueue(this.tempQueueName);
            } else {
                SimpleString queue;
                String pubId = this.protonSender.getName();
                if (pubId.contains("|")) {
                    pubId = pubId.split("\\|")[0];
                }
                if ((result = this.sessionSPI.queueQuery(queue = AmqpSupport.createQueueName(this.connection.isUseCoreSubscriptionNaming(), this.clientId, pubId, this.shared, this.global, this.isVolatile), this.multicast ? RoutingType.MULTICAST : RoutingType.ANYCAST, false)).isExists() && !this.isVolatile && result.getConsumerCount() == 0) {
                    this.sessionSPI.deleteQueue(queue);
                }
            }
        } else if (source != null && source.getDynamic() && (source.getExpiryPolicy() == TerminusExpiryPolicy.LINK_DETACH || source.getExpiryPolicy() == TerminusExpiryPolicy.SESSION_END)) {
            try {
                this.sessionSPI.removeTemporaryQueue(SimpleString.of((String)sourceAddress));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public MessageWriter selectOutgoingMessageWriter(ProtonServerSenderContext sender, MessageReference reference) {
        MessageWriter selected = reference.getMessage() instanceof AMQPLargeMessage ? this.largeMessageWriter : this.standardMessageWriter;
        return selected;
    }

    protected SimpleString getMatchingQueue(SimpleString queueName, SimpleString address, RoutingType routingType, SimpleString filter, boolean matchFilter) throws Exception {
        if (queueName != null) {
            QueueQueryResult result = this.sessionSPI.queueQuery(CompositeAddress.toFullyQualified((SimpleString)address, (SimpleString)queueName), routingType, true, filter);
            if (!result.isExists()) {
                throw new ActiveMQAMQPNotFoundException("Queue: '" + queueName + "' does not exist");
            }
            if (!result.getAddress().equals((Object)address)) {
                throw new ActiveMQAMQPNotFoundException("Queue: '" + queueName + "' does not exist for address '" + address + "'");
            }
            if (matchFilter && filter != null && result.getFilterString() != null && !filter.equals((Object)result.getFilterString())) {
                throw new ActiveMQIllegalStateException("Queue: " + queueName + " filter mismatch [" + filter + "] is different than existing filter [" + result.getFilterString() + "]");
            }
            return this.sessionSPI.getMatchingQueue(address, queueName, routingType);
        }
        return null;
    }

    private static String getSourceAddress(Source source) {
        if (source != null && source.getAddress() != null) {
            return ParameterisedAddress.extractAddress((String)source.getAddress());
        }
        return null;
    }

    private void validateConnectionState() throws ActiveMQException {
        Connection qpidConnection;
        ProtonHandler handler = this.connection == null ? null : this.connection.getHandler();
        Connection connection = qpidConnection = handler == null ? null : handler.getConnection();
        if (qpidConnection == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("validateConnectionState:: connection={}, handler={}, qpidConnection={}", new Object[]{this.connection, handler, qpidConnection});
            }
            ActiveMQAMQPProtocolLogger.LOGGER.invalidAMQPConnectionState("null", "null");
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.invalidAMQPConnectionState("null");
        }
        if (qpidConnection.getRemoteState() == EndpointState.CLOSED) {
            ActiveMQAMQPProtocolLogger.LOGGER.invalidAMQPConnectionState(qpidConnection.getRemoteState(), this.connection.getRemoteAddress());
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.invalidAMQPConnectionState(qpidConnection.getRemoteState());
        }
    }
}

