/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.cache.CacheInfo;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheProvider;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class CacheDependenciesProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext context) {
        final DeploymentUnit unit = context.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)unit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        CapabilityServiceSupport support = (CapabilityServiceSupport)unit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
        final HashSet<ServiceDependency<StatefulSessionBeanCacheProvider>> dependencies = new HashSet<ServiceDependency<StatefulSessionBeanCacheProvider>>();
        for (ComponentDescription description : moduleDescription.getComponentDescriptions()) {
            if (!(description instanceof StatefulComponentDescription)) continue;
            StatefulComponentDescription statefulDescription = (StatefulComponentDescription)description;
            dependencies.add(CacheDependenciesProcessor.getStatefulSessionBeanCacheProviderDependency(statefulDescription));
        }
        final EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)unit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        ServiceInstaller installer = new ServiceInstaller(){

            public ServiceController<?> install(RequirementServiceTarget target) {
                Set providers = dependencies.stream().map(Supplier::get).distinct().collect(Collectors.toSet());
                for (StatefulSessionBeanCacheProvider provider : providers) {
                    for (ServiceInstaller deploymentInstaller : provider.getDeploymentServiceInstallers(unit, moduleConfiguration)) {
                        deploymentInstaller.install((ServiceTarget)target);
                    }
                }
                return null;
            }
        };
        ((ServiceInstaller)((ServiceInstaller.Builder)ServiceInstaller.builder((ServiceInstaller)installer, (CapabilityServiceSupport)support).requires(dependencies)).build()).install(context);
    }

    private static ServiceDependency<StatefulSessionBeanCacheProvider> getStatefulSessionBeanCacheProviderDependency(StatefulComponentDescription description) {
        if (!description.isPassivationApplicable()) {
            return ServiceDependency.on(StatefulSessionBeanCacheProvider.PASSIVATION_DISABLED_SERVICE_DESCRIPTOR);
        }
        CacheInfo cache = description.getCache();
        return cache != null ? ServiceDependency.on(StatefulSessionBeanCacheProvider.SERVICE_DESCRIPTOR, (String)cache.getName()) : ServiceDependency.on(StatefulSessionBeanCacheProvider.DEFAULT_SERVICE_DESCRIPTOR);
    }
}

