/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import jakarta.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.infinispan.BasicCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheContainerConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheProperties;

public interface EmbeddedCacheConfiguration
extends EmbeddedCacheContainerConfiguration,
BasicCacheConfiguration {
    public <K, V> Cache<K, V> getCache();

    default public TransactionManager getTransactionManager() {
        return this.getCache().getAdvancedCache().getTransactionManager();
    }

    @Override
    default public EmbeddedCacheManager getCacheContainer() {
        return this.getCache().getCacheManager();
    }

    default public CacheProperties getCacheProperties() {
        return new EmbeddedCacheProperties(this.getCache().getCacheConfiguration());
    }

    default public <K, V> Cache<K, V> getReadForUpdateCache() {
        return this.getCacheProperties().isLockOnRead() ? this.getCache().getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK) : this.getCache();
    }

    default public <K, V> Cache<K, V> getTryLockCache() {
        return this.getCacheProperties().isLockOnWrite() ? this.getCache().getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}) : this.getCache();
    }

    default public <K, V> Cache<K, V> getTryReadForUpdateCache() {
        return this.getCacheProperties().isLockOnRead() ? this.getCache().getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}) : this.getCache();
    }

    default public <K, V> Cache<K, V> getWriteOnlyCache() {
        return this.getCache().getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
    }

    default public <K, V> Cache<K, V> getSilentWriteCache() {
        return this.getCache().getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_LISTENER_NOTIFICATION});
    }
}

