/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;
import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.utils.BufferHelper;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class DivertConfiguration
implements Serializable,
EncodingSupport {
    private static final long serialVersionUID = 6910543740464269629L;
    private String name = null;
    private String routingName = UUIDGenerator.getInstance().generateStringUUID();
    private String address = null;
    private String forwardingAddress = null;
    private boolean exclusive = ActiveMQDefaultConfiguration.isDefaultDivertExclusive();
    private String filterString = null;
    private TransformerConfiguration transformerConfiguration = null;
    private ComponentConfigurationRoutingType routingType = ComponentConfigurationRoutingType.valueOf((String)ActiveMQDefaultConfiguration.getDefaultDivertRoutingType());

    public String getName() {
        return this.name;
    }

    public String getRoutingName() {
        return this.routingName;
    }

    public String getAddress() {
        return this.address;
    }

    public String getForwardingAddress() {
        return this.forwardingAddress;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfiguration;
    }

    public ComponentConfigurationRoutingType getRoutingType() {
        return this.routingType;
    }

    public DivertConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public DivertConfiguration setRoutingName(String routingName) {
        this.routingName = routingName == null ? UUIDGenerator.getInstance().generateStringUUID() : routingName;
        return this;
    }

    public DivertConfiguration setAddress(String address) {
        this.address = address;
        return this;
    }

    public DivertConfiguration setForwardingAddress(String forwardingAddress) {
        this.forwardingAddress = forwardingAddress;
        return this;
    }

    public DivertConfiguration setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    public DivertConfiguration setFilterString(String filterString) {
        this.filterString = filterString;
        return this;
    }

    public DivertConfiguration setTransformerConfiguration(TransformerConfiguration transformerConfiguration) {
        this.transformerConfiguration = transformerConfiguration;
        return this;
    }

    public DivertConfiguration setRoutingType(ComponentConfigurationRoutingType routingType) {
        this.routingType = routingType;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.exclusive ? 1231 : 1237);
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.forwardingAddress == null ? 0 : this.forwardingAddress.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.routingName == null ? 0 : this.routingName.hashCode());
        result = 31 * result + (this.transformerConfiguration == null ? 0 : this.transformerConfiguration.hashCode());
        result = 31 * result + (this.routingType == null ? 0 : this.routingType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DivertConfiguration other = (DivertConfiguration)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.exclusive != other.exclusive) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.forwardingAddress == null ? other.forwardingAddress != null : !this.forwardingAddress.equals(other.forwardingAddress)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.routingName == null ? other.routingName != null : !this.routingName.equals(other.routingName)) {
            return false;
        }
        if (this.transformerConfiguration == null ? other.transformerConfiguration != null : !this.transformerConfiguration.equals((Object)other.transformerConfiguration)) {
            return false;
        }
        return !(this.routingType == null ? other.routingType != null : !this.routingType.equals((Object)other.routingType));
    }

    public int getEncodeSize() {
        int transformerSize;
        if (this.transformerConfiguration != null) {
            transformerSize = BufferHelper.sizeOfNullableString((String)this.transformerConfiguration.getClassName());
            transformerSize += 4;
            for (Map.Entry entry : this.transformerConfiguration.getProperties().entrySet()) {
                transformerSize += BufferHelper.sizeOfNullableString((String)((String)entry.getKey()));
                transformerSize += BufferHelper.sizeOfNullableString((String)((String)entry.getValue()));
            }
        } else {
            transformerSize = 1;
        }
        int size = BufferHelper.sizeOfNullableString((String)this.name) + BufferHelper.sizeOfNullableString((String)this.address) + BufferHelper.sizeOfNullableString((String)this.forwardingAddress) + BufferHelper.sizeOfNullableString((String)this.routingName) + 1 + BufferHelper.sizeOfNullableString((String)this.filterString) + 1 + transformerSize;
        return size;
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeNullableString(this.name);
        buffer.writeNullableString(this.address);
        buffer.writeNullableString(this.forwardingAddress);
        buffer.writeNullableString(this.routingName);
        buffer.writeBoolean(this.exclusive);
        buffer.writeNullableString(this.filterString);
        buffer.writeByte(this.routingType != null ? this.routingType.getType() : ComponentConfigurationRoutingType.valueOf((String)ActiveMQDefaultConfiguration.getDefaultDivertRoutingType()).getType());
        if (this.transformerConfiguration != null) {
            buffer.writeNullableString(this.transformerConfiguration.getClassName());
            Map properties = this.transformerConfiguration.getProperties();
            buffer.writeInt(properties.size());
            for (Map.Entry entry : properties.entrySet()) {
                buffer.writeNullableString((String)entry.getKey());
                buffer.writeNullableString((String)entry.getValue());
            }
        } else {
            buffer.writeNullableString(null);
        }
    }

    public String toString() {
        return "DivertConfiguration{name='" + this.name + "', routingName='" + this.routingName + "', address='" + this.address + "', forwardingAddress='" + this.forwardingAddress + "', exclusive=" + this.exclusive + ", filterString='" + this.filterString + "', transformerConfiguration=" + this.transformerConfiguration + "}";
    }

    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readNullableString();
        this.address = buffer.readNullableString();
        this.forwardingAddress = buffer.readNullableString();
        this.routingName = buffer.readNullableString();
        this.exclusive = buffer.readBoolean();
        this.filterString = buffer.readNullableString();
        this.routingType = ComponentConfigurationRoutingType.getType((byte)buffer.readByte());
        String transformerClassName = buffer.readNullableString();
        if (transformerClassName != null) {
            this.transformerConfiguration = new TransformerConfiguration(transformerClassName);
            int propsSize = buffer.readInt();
            for (int i = 0; i < propsSize; ++i) {
                this.transformerConfiguration.getProperties().put(buffer.readNullableString(), buffer.readNullableString());
            }
        }
    }
}

