/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.LockedStream;
import org.infinispan.batch.BatchContainer;
import org.infinispan.cache.impl.InternalCache;
import org.infinispan.commons.api.query.ContinuousQuery;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.SpliteratorMapper;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.stats.Stats;
import org.infinispan.stream.impl.local.EntryStreamSupplier;
import org.infinispan.stream.impl.local.KeyStreamSupplier;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.util.DataContainerRemoveIterator;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Cache", description="Component that represents a simplified cache instance.")
@Scope(value=Scopes.NAMED_CACHE)
public class SimpleCacheImpl<K, V>
implements AdvancedCache<K, V>,
InternalCache<K, V> {
    private static final Log log = LogFactory.getLog(SimpleCacheImpl.class);
    private static final String NULL_KEYS_NOT_SUPPORTED = "Null keys are not supported!";
    private static final String NULL_VALUES_NOT_SUPPORTED = "Null values are not supported!";
    private static final String NULL_FUNCTION_NOT_SUPPORTED = "Null functions are not supported!";
    private static final Class<? extends Annotation>[] FIRED_EVENTS = new Class[]{CacheEntryCreated.class, CacheEntryRemoved.class, CacheEntryVisited.class, CacheEntryModified.class, CacheEntriesEvicted.class, CacheEntryInvalidated.class, CacheEntryExpired.class};
    private final String name;
    @Inject
    ComponentRegistry componentRegistry;
    @Inject
    Configuration configuration;
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    InternalDataContainer<K, V> dataContainer;
    @Inject
    CacheNotifier<K, V> cacheNotifier;
    @Inject
    TimeService timeService;
    @Inject
    KeyPartitioner keyPartitioner;
    private Metadata defaultMetadata;
    private boolean hasListeners = false;

    public SimpleCacheImpl(String cacheName) {
        this.name = cacheName;
    }

    @ManagedOperation(description="Starts the cache.", displayName="Starts cache.")
    public void start() {
        this.defaultMetadata = new EmbeddedMetadata.Builder().lifespan(this.configuration.expiration().lifespan()).maxIdle(this.configuration.expiration().maxIdle()).build();
        this.componentRegistry.start();
    }

    @Override
    @ManagedOperation(description="Stops the cache.", displayName="Stops cache.")
    public void stop() {
        if (log.isDebugEnabled()) {
            log.debugf("Stopping cache %s on %s", this.getName(), this.getCacheManager().getAddress());
        }
        this.dataContainer = null;
        this.componentRegistry.stop();
    }

    @Override
    public void putForExternalRead(K key, V value) {
        ByRef.Boolean isCreatedRef = new ByRef.Boolean(false);
        this.putForExternalReadInternal(key, value, this.defaultMetadata, isCreatedRef);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = this.createMetadata(lifespan, unit);
        ByRef.Boolean isCreatedRef = new ByRef.Boolean(false);
        this.putForExternalReadInternal(key, value, metadata, isCreatedRef);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = this.createMetadata(lifespan, lifespanUnit, maxIdle, maxIdleUnit);
        ByRef.Boolean isCreatedRef = new ByRef.Boolean(false);
        this.putForExternalReadInternal(key, value, metadata, isCreatedRef);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        ByRef.Boolean isCreatedRef = new ByRef.Boolean(false);
        this.putForExternalReadInternal(key, value, this.applyDefaultMetadata(metadata), isCreatedRef);
    }

    protected void putForExternalReadInternal(K key, V value, Metadata metadata, ByRef.Boolean isCreatedRef) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (this.isNull(oldEntry)) {
                if (hasListeners) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryCreated(k, value, metadata, true, ImmutableContext.INSTANCE, null));
                }
                isCreatedRef.set(true);
                return factory.create(k, value, metadata);
            }
            return oldEntry;
        });
        if (hasListeners && isCreatedRef.get()) {
            CompletionStages.join(this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, false, ImmutableContext.INSTANCE, null));
        }
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return CompletableFuture.completedFuture(this.getAndPutInternal(key, value, this.applyDefaultMetadata(metadata)));
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> putAsyncEntry(K key, V value, Metadata metadata) {
        return CompletableFuture.completedFuture(this.getAndPutInternalEntry(key, value, this.applyDefaultMetadata(metadata)));
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        HashMap map = new HashMap(keys.size());
        AggregateCompletionStage aggregateCompletionStage = null;
        if (this.hasListeners && this.cacheNotifier.hasListener(CacheEntryVisited.class)) {
            aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        }
        for (Object k : keys) {
            Objects.requireNonNull(k, NULL_KEYS_NOT_SUPPORTED);
            InternalCacheEntry<K, V> entry = this.getDataContainer().get(k);
            if (entry == null) continue;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (aggregateCompletionStage != null) {
                aggregateCompletionStage.dependsOn(this.cacheNotifier.notifyCacheEntryVisited(key, value, true, ImmutableContext.INSTANCE, null).thenCompose(ignore -> this.cacheNotifier.notifyCacheEntryVisited(key, value, false, ImmutableContext.INSTANCE, null)));
            }
            map.put(key, value);
        }
        if (aggregateCompletionStage != null) {
            CompletionStages.join((CompletionStage)aggregateCompletionStage.freeze());
        }
        return map;
    }

    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        return CompletableFuture.completedFuture(this.getAll(keys));
    }

    @Override
    public CacheEntry<K, V> getCacheEntry(Object k) {
        InternalCacheEntry<K, V> entry = this.getDataContainer().get(k);
        if (entry != null) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.hasListeners) {
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryVisited(key, value, true, ImmutableContext.INSTANCE, null));
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryVisited(key, value, false, ImmutableContext.INSTANCE, null));
            }
        }
        return entry;
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> getCacheEntryAsync(Object key) {
        return CompletableFuture.completedFuture(this.getCacheEntry(key));
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        HashMap map = new HashMap(keys.size());
        AggregateCompletionStage aggregateCompletionStage = null;
        if (this.hasListeners && this.cacheNotifier.hasListener(CacheEntryVisited.class)) {
            aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        }
        for (Object key : keys) {
            Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
            InternalCacheEntry<K, V> entry = this.getDataContainer().get(key);
            if (entry == null) continue;
            Object value = entry.getValue();
            if (aggregateCompletionStage != null) {
                aggregateCompletionStage.dependsOn(this.cacheNotifier.notifyCacheEntryVisited(key, value, true, ImmutableContext.INSTANCE, null));
                aggregateCompletionStage.dependsOn(this.cacheNotifier.notifyCacheEntryVisited(key, value, false, ImmutableContext.INSTANCE, null));
            }
            map.put(entry.getKey(), entry);
        }
        if (aggregateCompletionStage != null) {
            CompletionStages.join((CompletionStage)aggregateCompletionStage.freeze());
        }
        return map;
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return CompletableFuture.completedFuture(this.compute(key, remappingFunction, metadata));
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return CompletableFuture.completedFuture(this.computeIfPresent(key, remappingFunction, metadata));
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        return CompletableFuture.completedFuture(this.computeIfAbsent(key, mappingFunction, metadata));
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return CompletableFuture.completedFuture(this.merge(key, value, remappingFunction, lifespan, lifespanUnit));
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return CompletableFuture.completedFuture(this.merge(key, value, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return CompletableFuture.completedFuture(this.merge(key, value, remappingFunction, metadata));
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return CompletableFuture.completedFuture(this.compute(key, remappingFunction));
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return CompletableFuture.completedFuture(this.compute(key, remappingFunction, lifespan, lifespanUnit));
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return CompletableFuture.completedFuture(this.compute(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit));
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        return CompletableFuture.completedFuture(this.computeIfAbsent(key, mappingFunction));
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return CompletableFuture.completedFuture(this.computeIfAbsent(key, mappingFunction, lifespan, lifespanUnit));
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return CompletableFuture.completedFuture(this.computeIfAbsent(key, mappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit));
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return CompletableFuture.completedFuture(this.computeIfPresent(key, remappingFunction));
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return CompletableFuture.completedFuture(this.computeIfPresent(key, remappingFunction, lifespan, lifespanUnit));
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return CompletableFuture.completedFuture(this.computeIfPresent(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit));
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return CompletableFuture.completedFuture(this.merge(key, value, remappingFunction));
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        return Collections.emptyMap();
    }

    @Override
    public void removeGroup(String groupName) {
    }

    @Override
    public AvailabilityMode getAvailability() {
        return AvailabilityMode.AVAILABLE;
    }

    @Override
    public void setAvailability(AvailabilityMode availabilityMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Boolean> touch(Object key, boolean touchEvenIfExpired) {
        return this.touch(key, -1, touchEvenIfExpired);
    }

    @Override
    public CompletionStage<Boolean> touch(Object key, int segment, boolean touchEvenIfExpired) {
        InternalCacheEntry<K, V> entry;
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        if (segment < 0) {
            segment = this.keyPartitioner.getSegment(key);
        }
        if ((entry = this.dataContainer.peek(segment, key)) != null) {
            long currentTime = this.timeService.wallClockTime();
            if (touchEvenIfExpired || !entry.isExpired(currentTime)) {
                return CompletableFutures.booleanStage((boolean)this.dataContainer.touch(segment, key, currentTime));
            }
        }
        return CompletableFutures.completedFalse();
    }

    @Override
    public void evict(K key) {
        ByRef oldEntryRef = new ByRef(null);
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (!this.isNull(oldEntry)) {
                oldEntryRef.set((Object)oldEntry);
            }
            return null;
        });
        InternalCacheEntry oldEntry2 = (InternalCacheEntry)oldEntryRef.get();
        if (this.hasListeners && oldEntry2 != null) {
            CompletionStages.join(this.cacheNotifier.notifyCacheEntriesEvicted(Collections.singleton(oldEntry2), ImmutableContext.INSTANCE, null));
        }
    }

    @Override
    public Configuration getCacheConfiguration() {
        return this.configuration;
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.componentRegistry.getStatus();
    }

    @ManagedAttribute(description="Returns the cache status", displayName="Cache status", dataType=DataType.TRAIT)
    public String getCacheStatus() {
        return this.getStatus().toString();
    }

    protected boolean checkExpiration(InternalCacheEntry<K, V> entry, long now) {
        if (entry.isExpired(now)) {
            return null == this.dataContainer.compute(entry.getKey(), (K key, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
                if (entry.isExpired(now)) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryExpired(key, oldEntry.getValue(), oldEntry.getMetadata(), ImmutableContext.INSTANCE));
                    return null;
                }
                return oldEntry;
            });
        }
        return false;
    }

    @Override
    public int size() {
        long now = Long.MIN_VALUE;
        int size = 0;
        DataContainer<K, V> dataContainer = this.getDataContainer();
        for (InternalCacheEntry<K, V> entry : dataContainer) {
            if (entry.canExpire()) {
                if (now == Long.MIN_VALUE) {
                    now = this.timeService.wallClockTime();
                }
                if (this.checkExpiration(entry, now) || ++size >= 0) continue;
                return Integer.MAX_VALUE;
            }
            if (++size >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return size;
    }

    public CompletableFuture<Long> sizeAsync() {
        long now = Long.MIN_VALUE;
        long size = 0L;
        DataContainer<K, V> dataContainer = this.getDataContainer();
        for (InternalCacheEntry<K, V> entry : dataContainer) {
            if (entry.canExpire()) {
                if (now == Long.MIN_VALUE) {
                    now = this.timeService.wallClockTime();
                }
                if (this.checkExpiration(entry, now)) continue;
                ++size;
                continue;
            }
            ++size;
        }
        return CompletableFuture.completedFuture(size);
    }

    public boolean isEmpty() {
        long now = Long.MIN_VALUE;
        DataContainer<K, V> dataContainer = this.getDataContainer();
        for (InternalCacheEntry<K, V> entry : dataContainer) {
            if (entry.canExpire()) {
                if (now == Long.MIN_VALUE) {
                    now = this.timeService.wallClockTime();
                }
                if (this.checkExpiration(entry, now)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        for (InternalCacheEntry<K, V> ice : this.getDataContainer()) {
            if (!Objects.equals(ice.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    public V get(Object key) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        InternalCacheEntry<K, V> entry = this.getDataContainer().get(key);
        if (entry == null) {
            return null;
        }
        if (this.hasListeners) {
            CompletionStages.join(this.cacheNotifier.notifyCacheEntryVisited(entry.getKey(), entry.getValue(), true, ImmutableContext.INSTANCE, null));
            CompletionStages.join(this.cacheNotifier.notifyCacheEntryVisited(entry.getKey(), entry.getValue(), false, ImmutableContext.INSTANCE, null));
        }
        return entry.getValue();
    }

    @Override
    public CacheSet<K> keySet() {
        return new KeySet();
    }

    @Override
    public CacheCollection<V> values() {
        return new Values();
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return new CacheEntrySet();
    }

    @Override
    public LockedStream<K, V> lockedStream() {
        throw new UnsupportedOperationException("Simple cache doesn't support lock stream!");
    }

    @Override
    public CompletableFuture<Boolean> removeLifespanExpired(K key, V value, Long lifespan) {
        this.checkExpiration(this.getDataContainer().get(key), this.timeService.wallClockTime());
        return CompletableFutures.completedTrue();
    }

    @Override
    public CompletableFuture<Boolean> removeMaxIdleExpired(K key, V value) {
        if (this.checkExpiration(this.getDataContainer().get(key), this.timeService.wallClockTime())) {
            return CompletableFutures.completedTrue();
        }
        return CompletableFutures.completedFalse();
    }

    @Override
    public AdvancedCache<?, ?> withEncoding(Class<? extends Encoder> encoder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AdvancedCache<?, ?> withEncoding(Class<? extends Encoder> keyEncoder, Class<? extends Encoder> valueEncoder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AdvancedCache<Object, Object> withKeyEncoding(Class<? extends Encoder> encoder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> wrapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AdvancedCache<?, ?> withMediaType(String keyMediaType, String valueMediaType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K1, V1> AdvancedCache<K1, V1> withMediaType(MediaType keyMediaType, MediaType valueMediaType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AdvancedCache<K, V> withStorageMediaType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> keyWrapper, Class<? extends Wrapper> valueWrapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataConversion getKeyDataConversion() {
        throw new UnsupportedOperationException("Conversion requires EncoderCache");
    }

    @Override
    public DataConversion getValueDataConversion() {
        throw new UnsupportedOperationException("Conversion requires EncoderCache");
    }

    @Override
    @ManagedOperation(description="Clears the cache", displayName="Clears the cache", name="clear")
    public void clear() {
        ArrayList copyEntries;
        DataContainer<K, V> dataContainer = this.getDataContainer();
        boolean hasListeners = this.hasListeners;
        if (hasListeners && this.cacheNotifier.hasListener(CacheEntryRemoved.class)) {
            copyEntries = new ArrayList(dataContainer.sizeIncludingExpired());
            dataContainer.forEach((? super T entry) -> {
                copyEntries.add(entry);
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryRemoved(entry.getKey(), entry.getValue(), entry.getMetadata(), true, ImmutableContext.INSTANCE, null));
            });
        } else {
            copyEntries = null;
        }
        dataContainer.clear();
        if (copyEntries != null) {
            for (InternalCacheEntry entry2 : copyEntries) {
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryRemoved(entry2.getKey(), entry2.getValue(), entry2.getMetadata(), false, ImmutableContext.INSTANCE, null));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    @ManagedAttribute(description="Returns the cache name", displayName="Cache name", dataType=DataType.TRAIT)
    public String getCacheName() {
        return this.getName() + "(" + this.getCacheConfiguration().clustering().cacheMode().toString().toLowerCase() + ")";
    }

    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", dataType=DataType.TRAIT)
    public String getVersion() {
        return Version.getVersion();
    }

    @ManagedAttribute(description="Returns the cache configuration in form of properties", displayName="Cache configuration properties", dataType=DataType.TRAIT)
    public Properties getConfigurationAsProperties() {
        return new PropertyFormatter().format(this.configuration);
    }

    public V put(K key, V value) {
        return this.getAndPutInternal(key, value, this.defaultMetadata);
    }

    public V put(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = this.createMetadata(lifespan, unit);
        return this.getAndPutInternal(key, value, metadata);
    }

    protected V getAndPutInternal(K key, V value, Metadata metadata) {
        CacheEntry<K, V> oldEntry = this.getAndPutInternalEntry(key, value, metadata);
        return oldEntry != null ? (V)oldEntry.getValue() : null;
    }

    private CacheEntry<K, V> getAndPutInternalEntry(K key, V value, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        ByRef oldEntryRef = new ByRef(null);
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (this.isNull(oldEntry)) {
                if (hasListeners) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, true, ImmutableContext.INSTANCE, null));
                }
            } else {
                oldEntryRef.set((Object)oldEntry.clone());
                if (hasListeners) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, oldEntry.getValue(), oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null));
                }
            }
            if (oldEntry == null) {
                return factory.create(k, value, metadata);
            }
            return factory.update(oldEntry, value, metadata);
        });
        CacheEntry oldEntry2 = (CacheEntry)oldEntryRef.get();
        if (hasListeners) {
            Object oldValue;
            Object v = oldValue = oldEntry2 != null ? (Object)oldEntry2.getValue() : null;
            if (oldValue == null) {
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, false, ImmutableContext.INSTANCE, null));
            } else {
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, oldValue, oldEntry2.getMetadata(), false, ImmutableContext.INSTANCE, null));
            }
        }
        return oldEntry2;
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = this.createMetadata(lifespan, unit);
        return this.putIfAbsentInternal(key, value, metadata);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        return this.putIfAbsentInternal(key, value, this.applyDefaultMetadata(metadata));
    }

    protected V putIfAbsentInternal(K key, V value, Metadata metadata) {
        CacheEntry<K, V> entry = this.putIfAbsentInternalEntry(key, value, metadata);
        return entry != null ? (V)entry.getValue() : null;
    }

    private CacheEntry<K, V> putIfAbsentInternalEntry(K key, V value, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        ByRef previousEntryRef = new ByRef(null);
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (this.isNull(oldEntry)) {
                if (hasListeners) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, true, ImmutableContext.INSTANCE, null));
                }
                return factory.create(k, value, metadata);
            }
            previousEntryRef.set((Object)oldEntry.clone());
            return oldEntry;
        });
        CacheEntry previousEntry = (CacheEntry)previousEntryRef.get();
        if (hasListeners && previousEntry == null) {
            CompletionStages.join(this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, false, ImmutableContext.INSTANCE, null));
        }
        return previousEntry;
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAllInternal(map, this.createMetadata(lifespan, unit));
    }

    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        Metadata metadata = this.createMetadata(lifespan, unit);
        return this.getAndReplaceInternal(key, value, metadata);
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replaceInternal(key, oldValue, value, this.createMetadata(lifespan, unit));
    }

    protected V getAndReplaceInternal(K key, V value, Metadata metadata) {
        CacheEntry<K, V> oldEntry = this.getAndReplaceInternalEntry(key, value, metadata);
        return oldEntry != null ? (V)oldEntry.getValue() : null;
    }

    private CacheEntry<K, V> getAndReplaceInternalEntry(K key, V value, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        ByRef ref = new ByRef(null);
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (!this.isNull(oldEntry)) {
                if (hasListeners) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, oldEntry.getValue(), oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null));
                }
                ref.set((Object)oldEntry.clone());
                return factory.update(oldEntry, value, metadata);
            }
            return oldEntry;
        });
        CacheEntry oldRef = (CacheEntry)ref.get();
        if (hasListeners && oldRef != null && oldRef.getValue() != null) {
            Object oldValue = oldRef.getValue();
            CompletionStages.join(this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, oldValue, oldRef.getMetadata(), false, ImmutableContext.INSTANCE, null));
        }
        return oldRef;
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.getAndPutInternal(key, value, metadata);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.putIfAbsentInternal(key, value, metadata);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.putAllInternal(map, this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.getAndReplaceInternal(key, value, metadata);
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.replaceInternal(key, oldValue, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return this.replaceInternal(key, oldValue, value, this.applyDefaultMetadata(metadata));
    }

    protected boolean replaceInternal(K key, V oldValue, V value, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        Objects.requireNonNull(oldValue, NULL_VALUES_NOT_SUPPORTED);
        ValueAndMetadata oldRef = new ValueAndMetadata();
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V prevValue = this.getValue(oldEntry);
            if (Objects.equals(prevValue, oldValue)) {
                oldRef.set(prevValue, oldEntry.getMetadata());
                if (hasListeners) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, prevValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null));
                }
                return factory.update(oldEntry, value, metadata);
            }
            return oldEntry;
        });
        if (oldRef.getValue() != null) {
            if (hasListeners) {
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, oldRef.getValue(), oldRef.getMetadata(), false, ImmutableContext.INSTANCE, null));
            }
            return true;
        }
        return false;
    }

    public V remove(Object key) {
        CacheEntry<K, V> oldEntry = this.removeEntry(key);
        return oldEntry != null ? (V)oldEntry.getValue() : null;
    }

    public <T> Query<T> query(String query) {
        throw log.querySimpleCacheNotSupported();
    }

    public ContinuousQuery<K, V> continuousQuery() {
        throw log.querySimpleCacheNotSupported();
    }

    private CacheEntry<K, V> removeEntry(Object key) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        ByRef oldEntryRef = new ByRef(null);
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (!this.isNull(oldEntry)) {
                if (hasListeners) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryRemoved(oldEntry.getKey(), oldEntry.getValue(), oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null));
                }
                oldEntryRef.set((Object)oldEntry);
            }
            return null;
        });
        InternalCacheEntry oldEntry2 = (InternalCacheEntry)oldEntryRef.get();
        if (oldEntry2 != null && hasListeners) {
            CompletionStages.join(this.cacheNotifier.notifyCacheEntryRemoved(oldEntry2.getKey(), oldEntry2.getValue(), oldEntry2.getMetadata(), false, ImmutableContext.INSTANCE, null));
        }
        return oldEntry2;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAllInternal(map, this.defaultMetadata);
    }

    public CompletableFuture<V> putAsync(K key, V value) {
        return CompletableFuture.completedFuture(this.put(key, value));
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return CompletableFuture.completedFuture(this.put(key, value, lifespan, unit));
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return CompletableFuture.completedFuture(this.put(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit));
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        this.putAll(data);
        return CompletableFutures.completedNull();
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        this.putAll(data, lifespan, unit);
        return CompletableFutures.completedNull();
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.putAll(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.putAll(map, metadata);
        return CompletableFutures.completedNull();
    }

    public CompletableFuture<Void> clearAsync() {
        this.clear();
        return CompletableFutures.completedNull();
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return CompletableFuture.completedFuture(this.putIfAbsent(key, value));
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return CompletableFuture.completedFuture(this.putIfAbsent(key, value, lifespan, unit));
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return CompletableFuture.completedFuture(this.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit));
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata) {
        return CompletableFuture.completedFuture(this.putIfAbsent(key, value, metadata));
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> putIfAbsentAsyncEntry(K key, V value, Metadata metadata) {
        return CompletableFuture.completedFuture(this.putIfAbsentInternalEntry(key, value, metadata));
    }

    public CompletableFuture<V> removeAsync(Object key) {
        return CompletableFuture.completedFuture(this.remove(key));
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> removeAsyncEntry(Object key) {
        return CompletableFuture.completedFuture(this.removeEntry(key));
    }

    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return CompletableFuture.completedFuture(this.remove(key, value));
    }

    public CompletableFuture<V> replaceAsync(K key, V value) {
        return CompletableFuture.completedFuture(this.replace(key, value));
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return CompletableFuture.completedFuture(this.replace(key, value, lifespan, unit));
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return CompletableFuture.completedFuture(this.replace(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit));
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return CompletableFuture.completedFuture(this.replace(key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return CompletableFuture.completedFuture(this.replace(key, oldValue, newValue, lifespan, unit));
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return CompletableFuture.completedFuture(this.replace(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit));
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata) {
        return CompletableFuture.completedFuture(this.replace(key, value, metadata));
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> replaceAsyncEntry(K key, V value, Metadata metadata) {
        return CompletableFuture.completedFuture(this.getAndReplaceInternalEntry(key, value, metadata));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata) {
        return CompletableFuture.completedFuture(this.replace(key, oldValue, newValue, metadata));
    }

    public CompletableFuture<V> getAsync(K key) {
        InternalCacheEntry e = this.getDataContainer().peek(key);
        if (e == null) {
            return CompletableFutures.completedNull();
        }
        if (!e.canExpire()) {
            return CompletableFuture.completedFuture(this.get(key));
        }
        long currentTimeMs = this.timeService.wallClockTime();
        if (!e.isExpired(currentTimeMs)) {
            return this.invokeGetListener(e).thenApply(ignore -> e.getValue()).toCompletableFuture();
        }
        InternalExpirationManager iem = (InternalExpirationManager)this.getExpirationManager();
        return ((CompletableFuture)iem.entryExpiredInMemory(e, currentTimeMs, false).thenApply(expired -> {
            if (expired.booleanValue()) {
                return null;
            }
            return e.getValue();
        })).thenCompose(v -> v != null ? this.invokeGetListener(e).thenApply(ignore -> v) : CompletableFutures.completedNull());
    }

    private CompletionStage<Void> invokeGetListener(InternalCacheEntry<K, V> e) {
        if (!this.hasListeners) {
            return CompletableFutures.completedNull();
        }
        return this.cacheNotifier.notifyCacheEntryVisited(e.getKey(), e.getValue(), true, ImmutableContext.INSTANCE, null).thenCompose(ignore -> this.cacheNotifier.notifyCacheEntryVisited(e.getKey(), e.getValue(), false, ImmutableContext.INSTANCE, null));
    }

    public boolean startBatch() {
        throw Log.CONFIG.invocationBatchingNotEnabled();
    }

    public void endBatch(boolean successful) {
        throw Log.CONFIG.invocationBatchingNotEnabled();
    }

    public V putIfAbsent(K key, V value) {
        return this.putIfAbsentInternal(key, value, this.defaultMetadata);
    }

    public boolean remove(Object key, Object value) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        ByRef oldEntryRef = new ByRef(null);
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V oldValue = this.getValue(oldEntry);
            if (Objects.equals(oldValue, value)) {
                if (hasListeners) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryRemoved(oldEntry.getKey(), oldValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null));
                }
                oldEntryRef.set((Object)oldEntry);
                return null;
            }
            return oldEntry;
        });
        InternalCacheEntry oldEntry2 = (InternalCacheEntry)oldEntryRef.get();
        if (oldEntry2 != null) {
            if (hasListeners) {
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryRemoved(oldEntry2.getKey(), oldEntry2.getValue(), oldEntry2.getMetadata(), false, ImmutableContext.INSTANCE, null));
            }
            return true;
        }
        return false;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.replaceInternal(key, oldValue, newValue, this.defaultMetadata);
    }

    public V replace(K key, V value) {
        return this.getAndReplaceInternal(key, value, this.defaultMetadata);
    }

    @Override
    public <C> CompletionStage<Void> addListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        if (!this.hasListeners && this.canFire(listener)) {
            this.hasListeners = true;
        }
        return this.cacheNotifier.addListenerAsync(listener, filter, converter);
    }

    @Override
    public CompletionStage<Void> addListenerAsync(Object listener) {
        if (!this.hasListeners && this.canFire(listener)) {
            this.hasListeners = true;
        }
        return this.cacheNotifier.addListenerAsync(listener);
    }

    @Override
    public CompletionStage<Void> removeListenerAsync(Object listener) {
        return this.cacheNotifier.removeListenerAsync(listener);
    }

    @Override
    public <C> CompletionStage<Void> addFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        if (!this.hasListeners && this.canFire(listener)) {
            this.hasListeners = true;
        }
        return this.cacheNotifier.addFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    @Override
    public <C> CompletionStage<Void> addStorageFormatFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        throw new UnsupportedOperationException();
    }

    private boolean canFire(Object listener) {
        for (Method m : listener.getClass().getMethods()) {
            for (Class<? extends Annotation> annotation : FIRED_EVENTS) {
                if (!m.isAnnotationPresent(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private Metadata applyDefaultMetadata(Metadata metadata) {
        Metadata.Builder builder = metadata.builder();
        return builder != null ? builder.merge(this.defaultMetadata).build() : metadata;
    }

    private Metadata createMetadata(long lifespan, TimeUnit unit) {
        return new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.configuration.expiration().maxIdle()).build();
    }

    private Metadata createMetadata(long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        return this;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Collection<Flag> flags) {
        return this;
    }

    @Override
    public AdvancedCache<K, V> noFlags() {
        return this;
    }

    @Override
    public AdvancedCache<K, V> transform(Function<AdvancedCache<K, V>, ? extends AdvancedCache<K, V>> transformation) {
        return transformation.apply(this);
    }

    @Override
    public AdvancedCache<K, V> withSubject(Subject subject) {
        return this;
    }

    @Override
    public ExpirationManager<K, V> getExpirationManager() {
        return this.getComponentRegistry().getComponent(InternalExpirationManager.class);
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.getComponentRegistry().getComponent(DistributionManager.class);
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.getComponentRegistry().getComponent(AuthorizationManager.class);
    }

    @Override
    public AdvancedCache<K, V> lockAs(Object lockOwner) {
        throw new UnsupportedOperationException("lockAs method not supported with Simple Cache!");
    }

    @Override
    public boolean lock(K ... keys) {
        throw Log.CONTAINER.lockOperationsNotSupported();
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        throw Log.CONTAINER.lockOperationsNotSupported();
    }

    @Override
    public RpcManager getRpcManager() {
        return null;
    }

    @Override
    public BatchContainer getBatchContainer() {
        return null;
    }

    @Override
    public DataContainer<K, V> getDataContainer() {
        InternalDataContainer<K, V> dataContainer = this.dataContainer;
        if (dataContainer == null) {
            ComponentStatus status = this.getStatus();
            switch (status) {
                case STOPPING: {
                    throw Log.CONTAINER.cacheIsStopping(this.name);
                }
                case TERMINATED: 
                case FAILED: {
                    throw Log.CONTAINER.cacheIsTerminated(this.name, status.toString());
                }
            }
            throw new IllegalStateException("Status: " + String.valueOf((Object)status));
        }
        return dataContainer;
    }

    public TransactionManager getTransactionManager() {
        return null;
    }

    @Override
    public LockManager getLockManager() {
        return null;
    }

    @Override
    public Stats getStats() {
        return null;
    }

    @Override
    public XAResource getXAResource() {
        return null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return null;
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.getAndPutInternal(key, value, this.applyDefaultMetadata(metadata));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.putAllInternal(map, this.applyDefaultMetadata(metadata));
    }

    protected void putAllInternal(Map<? extends K, ? extends V> map, Metadata metadata) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Objects.requireNonNull(entry.getKey(), NULL_KEYS_NOT_SUPPORTED);
            Objects.requireNonNull(entry.getValue(), NULL_VALUES_NOT_SUPPORTED);
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.getAndPutInternal(entry.getKey(), entry.getValue(), metadata);
        }
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        return this.getAndReplaceInternal(key, value, this.applyDefaultMetadata(metadata));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        ByRef newValueRef = new ByRef(null);
        return this.computeIfAbsentInternal(key, mappingFunction, newValueRef, this.defaultMetadata);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        ByRef newValueRef = new ByRef(null);
        return this.computeIfAbsentInternal(key, mappingFunction, newValueRef, metadata);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        ByRef newValueRef = new ByRef(null);
        return this.computeIfAbsentInternal(key, mappingFunction, newValueRef, this.createMetadata(lifespan, lifespanUnit));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        ByRef newValueRef = new ByRef(null);
        return this.computeIfAbsentInternal(key, mappingFunction, newValueRef, this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    protected V computeIfAbsentInternal(K key, Function<? super K, ? extends V> mappingFunction, ByRef<V> newValueRef) {
        return this.computeIfAbsentInternal(key, mappingFunction, newValueRef, this.defaultMetadata);
    }

    private V computeIfAbsentInternal(K key, Function<? super K, ? extends V> mappingFunction, ByRef<V> newValueRef, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(mappingFunction, NULL_FUNCTION_NOT_SUPPORTED);
        boolean hasListeners = this.hasListeners;
        this.componentRegistry.wireDependencies(mappingFunction);
        InternalCacheEntry<Object, V> returnEntry = this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V oldValue = this.getValue(oldEntry);
            if (oldValue == null) {
                Object newValue = mappingFunction.apply((K)k);
                if (newValue == null) {
                    return null;
                }
                if (hasListeners) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryCreated(k, newValue, metadata, true, ImmutableContext.INSTANCE, null));
                }
                newValueRef.set(newValue);
                return factory.create(k, newValue, metadata);
            }
            return oldEntry;
        });
        Object newValue = newValueRef.get();
        if (hasListeners && newValue != null) {
            CompletionStages.join(this.cacheNotifier.notifyCacheEntryCreated(key, newValueRef.get(), metadata, false, ImmutableContext.INSTANCE, null));
        }
        return returnEntry == null ? null : (V)returnEntry.getValue();
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        CacheEntryChange ref = new CacheEntryChange();
        return this.computeIfPresentInternal(key, remappingFunction, ref, this.defaultMetadata);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        CacheEntryChange ref = new CacheEntryChange();
        return this.computeIfPresentInternal(key, remappingFunction, ref, this.createMetadata(lifespan, lifespanUnit));
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        CacheEntryChange ref = new CacheEntryChange();
        return this.computeIfPresentInternal(key, remappingFunction, ref, this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        CacheEntryChange ref = new CacheEntryChange();
        return this.computeIfPresentInternal(key, remappingFunction, ref, metadata);
    }

    protected V computeIfPresentInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, CacheEntryChange<K, V> ref) {
        return this.computeIfPresentInternal(key, remappingFunction, ref, this.defaultMetadata);
    }

    private V computeIfPresentInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, CacheEntryChange<K, V> ref, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(remappingFunction, NULL_FUNCTION_NOT_SUPPORTED);
        boolean hasListeners = this.hasListeners;
        this.componentRegistry.wireDependencies(remappingFunction);
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V oldValue = this.getValue(oldEntry);
            if (oldValue != null) {
                Object newValue = remappingFunction.apply((K)k, (V)oldValue);
                if (newValue == null) {
                    if (hasListeners) {
                        CompletionStages.join(this.cacheNotifier.notifyCacheEntryRemoved(k, oldValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null));
                    }
                    ref.set(k, null, oldValue, oldEntry.getMetadata());
                    return null;
                }
                if (hasListeners) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryModified(k, newValue, metadata, oldValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null));
                }
                ref.set(k, newValue, oldValue, oldEntry.getMetadata());
                return factory.update(oldEntry, newValue, metadata);
            }
            return null;
        });
        V newValue = ref.getNewValue();
        if (hasListeners) {
            if (newValue != null) {
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryModified(ref.getKey(), newValue, metadata, ref.getOldValue(), ref.getOldMetadata(), false, ImmutableContext.INSTANCE, null));
            } else {
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryRemoved(ref.getKey(), ref.getOldValue(), ref.getOldMetadata(), false, ImmutableContext.INSTANCE, null));
            }
        }
        return newValue;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        CacheEntryChange ref = new CacheEntryChange();
        return this.computeInternal(key, remappingFunction, ref, this.defaultMetadata);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeInternal(key, remappingFunction, new CacheEntryChange(), this.createMetadata(lifespan, lifespanUnit));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.computeInternal(key, remappingFunction, new CacheEntryChange(), this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        CacheEntryChange ref = new CacheEntryChange();
        return this.computeInternal(key, remappingFunction, ref, metadata);
    }

    protected V computeInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, CacheEntryChange<K, V> ref) {
        return this.computeInternal(key, remappingFunction, ref, this.defaultMetadata);
    }

    private V computeInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, CacheEntryChange<K, V> ref, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(remappingFunction, NULL_FUNCTION_NOT_SUPPORTED);
        boolean hasListeners = this.hasListeners;
        this.componentRegistry.wireDependencies(remappingFunction);
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V oldValue = this.getValue(oldEntry);
            Object newValue = remappingFunction.apply((K)k, (V)oldValue);
            return this.getUpdatedEntry(k, oldEntry, factory, oldValue, newValue, metadata, ref, hasListeners);
        });
        return this.notifyAndReturn(ref, hasListeners, metadata);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.mergeInternal(key, value, remappingFunction, new CacheEntryChange(), this.defaultMetadata);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.mergeInternal(key, value, remappingFunction, new CacheEntryChange(), this.createMetadata(lifespan, lifespanUnit));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.mergeInternal(key, value, remappingFunction, new CacheEntryChange(), this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.mergeInternal(key, value, remappingFunction, new CacheEntryChange(), metadata);
    }

    protected V mergeInternal(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, CacheEntryChange<K, V> ref, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        Objects.requireNonNull(remappingFunction, NULL_FUNCTION_NOT_SUPPORTED);
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V oldValue = this.getValue(oldEntry);
            Object newValue = oldValue == null ? value : remappingFunction.apply((V)oldValue, (V)value);
            return this.getUpdatedEntry(k, oldEntry, factory, oldValue, newValue, metadata, ref, hasListeners);
        });
        return this.notifyAndReturn(ref, hasListeners, metadata);
    }

    private V notifyAndReturn(CacheEntryChange<K, V> ref, boolean hasListeners, Metadata metadata) {
        K key = ref.getKey();
        V newValue = ref.getNewValue();
        if (key != null) {
            V oldValue = ref.getOldValue();
            if (hasListeners) {
                if (newValue == null) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryRemoved(key, oldValue, ref.getOldMetadata(), false, ImmutableContext.INSTANCE, null));
                } else if (oldValue == null) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryCreated(key, newValue, metadata, false, ImmutableContext.INSTANCE, null));
                } else {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryModified(key, newValue, metadata, oldValue, ref.getOldMetadata(), false, ImmutableContext.INSTANCE, null));
                }
            }
        }
        return newValue;
    }

    private InternalCacheEntry<K, V> getUpdatedEntry(K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory, V oldValue, V newValue, Metadata metadata, CacheEntryChange<K, V> ref, boolean hasListeners) {
        if (newValue == null) {
            if (oldValue != null) {
                if (hasListeners) {
                    CompletionStages.join(this.cacheNotifier.notifyCacheEntryRemoved(k, oldValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null));
                }
                ref.set(k, null, oldValue, oldEntry.getMetadata());
            }
            return null;
        }
        if (oldValue == null) {
            if (hasListeners) {
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryCreated(k, newValue, metadata, true, ImmutableContext.INSTANCE, null));
            }
            ref.set(k, newValue, null, null);
            return factory.create(k, newValue, metadata);
        }
        if (hasListeners) {
            CompletionStages.join(this.cacheNotifier.notifyCacheEntryModified(k, newValue, metadata, oldValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null));
        }
        ref.set(k, newValue, oldValue, oldEntry.getMetadata());
        return factory.update(oldEntry, newValue, metadata);
    }

    private boolean isNull(InternalCacheEntry<K, V> entry) {
        if (entry == null) {
            return true;
        }
        if (entry.canExpire() && entry.isExpired(this.timeService.wallClockTime())) {
            if (this.cacheNotifier.hasListener(CacheEntryExpired.class)) {
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryExpired(entry.getKey(), entry.getValue(), entry.getMetadata(), ImmutableContext.INSTANCE));
            }
            return true;
        }
        return false;
    }

    private V getValue(InternalCacheEntry<K, V> entry) {
        return this.isNull(entry) ? null : (V)entry.getValue();
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (InternalCacheEntry ice : this.dataContainer) {
            action.accept(ice.getKey(), ice.getValue());
        }
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        AggregateCompletionStage aggregateCompletionStage = this.hasListeners && this.cacheNotifier.hasListener(CacheEntryModified.class) ? CompletionStages.aggregateCompletionStage() : null;
        CacheEntryChange ref = new CacheEntryChange();
        for (InternalCacheEntry ice : this.dataContainer) {
            this.getDataContainer().compute(ice.getKey(), (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
                V oldValue = this.getValue(oldEntry);
                if (oldValue != null) {
                    Object newValue = function.apply((K)k, (V)oldValue);
                    Objects.requireNonNull(newValue, NULL_VALUES_NOT_SUPPORTED);
                    if (aggregateCompletionStage != null) {
                        aggregateCompletionStage.dependsOn(this.cacheNotifier.notifyCacheEntryModified(k, newValue, this.defaultMetadata, oldValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null));
                    }
                    ref.set(k, newValue, oldValue, oldEntry.getMetadata());
                    return factory.update(oldEntry, newValue, this.defaultMetadata);
                }
                return null;
            });
            if (aggregateCompletionStage == null) continue;
            aggregateCompletionStage.dependsOn(this.cacheNotifier.notifyCacheEntryModified(ref.getKey(), ref.getNewValue(), this.defaultMetadata, ref.getOldValue(), ref.getOldMetadata(), false, ImmutableContext.INSTANCE, null));
        }
        if (aggregateCompletionStage != null) {
            CompletionStages.join((CompletionStage)aggregateCompletionStage.freeze());
        }
    }

    private static <K, V> CacheStream<Map.Entry<K, V>> cacheStreamCast(CacheStream stream) {
        return stream;
    }

    protected Supplier<Stream<CacheEntry<K, V>>> getStreamSupplier(boolean parallel) {
        Spliterator spliterator = this.dataContainer.spliterator();
        return () -> StreamSupport.stream(spliterator, parallel);
    }

    public String toString() {
        return "SimpleCache '" + this.getName() + "'@" + Util.hexIdHashCode((Object)this.getCacheManager());
    }

    protected class KeySet
    extends AbstractSet<K>
    implements CacheSet<K> {
        protected KeySet() {
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            HashSet retained = new HashSet(c.size());
            retained.addAll(c);
            boolean changed = false;
            for (InternalCacheEntry entry : SimpleCacheImpl.this.getDataContainer()) {
                if (retained.contains(entry.getKey())) continue;
                changed |= SimpleCacheImpl.this.remove(entry.getKey()) != null;
            }
            return changed;
        }

        @Override
        public boolean remove(Object o) {
            return SimpleCacheImpl.this.remove(o) != null;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean changed = false;
            for (Object key : c) {
                changed |= SimpleCacheImpl.this.remove(key) != null;
            }
            return changed;
        }

        @Override
        public void clear() {
            SimpleCacheImpl.this.clear();
        }

        @Override
        public CloseableIterator<K> iterator() {
            return Closeables.iterator((Iterator)new IteratorMapper(new DataContainerRemoveIterator(SimpleCacheImpl.this), Map.Entry::getKey));
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            return new SpliteratorMapper(SimpleCacheImpl.this.dataContainer.spliterator(), Map.Entry::getKey);
        }

        @Override
        public int size() {
            return SimpleCacheImpl.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SimpleCacheImpl.this.isEmpty();
        }

        @Override
        public CacheStream<K> stream() {
            return new LocalCacheStream(new KeyStreamSupplier(SimpleCacheImpl.this, null, () -> super.stream()), false, SimpleCacheImpl.this.componentRegistry);
        }

        @Override
        public CacheStream<K> parallelStream() {
            return new LocalCacheStream(new KeyStreamSupplier(SimpleCacheImpl.this, null, () -> super.stream()), true, SimpleCacheImpl.this.componentRegistry);
        }
    }

    protected class Values
    extends AbstractSet<V>
    implements CacheCollection<V> {
        protected Values() {
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            HashSet retained = new HashSet(c.size());
            retained.addAll(c);
            boolean changed = false;
            for (InternalCacheEntry entry : SimpleCacheImpl.this.getDataContainer()) {
                if (retained.contains(entry.getValue())) continue;
                changed |= SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue());
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            int removeSize = c.size();
            if (removeSize == 0) {
                return false;
            }
            if (removeSize == 1) {
                return this.remove(c.iterator().next());
            }
            HashSet removed = new HashSet(removeSize);
            removed.addAll(c);
            boolean changed = false;
            for (InternalCacheEntry entry : SimpleCacheImpl.this.getDataContainer()) {
                if (!removed.contains(entry.getValue())) continue;
                changed |= SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue());
            }
            return changed;
        }

        @Override
        public boolean remove(Object o) {
            for (InternalCacheEntry entry : SimpleCacheImpl.this.getDataContainer()) {
                if (!Objects.equals(entry.getValue(), o) || !SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SimpleCacheImpl.this.clear();
        }

        @Override
        public CloseableIterator<V> iterator() {
            return Closeables.iterator((Iterator)new IteratorMapper(new DataContainerRemoveIterator(SimpleCacheImpl.this), Map.Entry::getValue));
        }

        @Override
        public CloseableSpliterator<V> spliterator() {
            return Closeables.spliterator((Spliterator)new SpliteratorMapper(SimpleCacheImpl.this.getDataContainer().spliterator(), Map.Entry::getValue));
        }

        @Override
        public int size() {
            return SimpleCacheImpl.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SimpleCacheImpl.this.isEmpty();
        }

        @Override
        public CacheStream<V> stream() {
            LocalCacheStream lcs = new LocalCacheStream(new EntryStreamSupplier(SimpleCacheImpl.this, null, SimpleCacheImpl.this.getStreamSupplier(false)), false, SimpleCacheImpl.this.componentRegistry);
            return lcs.map(CacheEntry::getValue);
        }

        @Override
        public CacheStream<V> parallelStream() {
            LocalCacheStream lcs = new LocalCacheStream(new EntryStreamSupplier(SimpleCacheImpl.this, null, SimpleCacheImpl.this.getStreamSupplier(false)), true, SimpleCacheImpl.this.componentRegistry);
            return lcs.map(CacheEntry::getValue);
        }
    }

    protected class EntrySet
    extends EntrySetBase<Map.Entry<K, V>>
    implements CacheSet<Map.Entry<K, V>> {
        protected EntrySet() {
        }

        @Override
        public CloseableIterator<Map.Entry<K, V>> iterator() {
            return Closeables.iterator(new DataContainerRemoveIterator(SimpleCacheImpl.this));
        }

        @Override
        public CloseableSpliterator<Map.Entry<K, V>> spliterator() {
            return Closeables.spliterator(SimpleCacheImpl.this.dataContainer.spliterator());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CacheStream<Map.Entry<K, V>> stream() {
            return SimpleCacheImpl.cacheStreamCast(new LocalCacheStream(new EntryStreamSupplier(SimpleCacheImpl.this, null, SimpleCacheImpl.this.getStreamSupplier(false)), false, SimpleCacheImpl.this.componentRegistry));
        }

        @Override
        public CacheStream<Map.Entry<K, V>> parallelStream() {
            return SimpleCacheImpl.cacheStreamCast(new LocalCacheStream(new EntryStreamSupplier(SimpleCacheImpl.this, null, SimpleCacheImpl.this.getStreamSupplier(false)), true, SimpleCacheImpl.this.componentRegistry));
        }
    }

    protected class CacheEntrySet
    extends EntrySetBase<CacheEntry<K, V>>
    implements CacheSet<CacheEntry<K, V>> {
        protected CacheEntrySet() {
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            return Closeables.iterator(new DataContainerRemoveIterator(SimpleCacheImpl.this));
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            return Closeables.spliterator(SimpleCacheImpl.this.dataContainer.spliterator());
        }

        @Override
        public boolean add(CacheEntry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends CacheEntry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CacheStream<CacheEntry<K, V>> stream() {
            return new LocalCacheStream(new EntryStreamSupplier(SimpleCacheImpl.this, null, SimpleCacheImpl.this.getStreamSupplier(false)), false, SimpleCacheImpl.this.componentRegistry);
        }

        @Override
        public CacheStream<CacheEntry<K, V>> parallelStream() {
            return new LocalCacheStream(new EntryStreamSupplier(SimpleCacheImpl.this, null, SimpleCacheImpl.this.getStreamSupplier(true)), true, SimpleCacheImpl.this.componentRegistry);
        }
    }

    protected static class ValueAndMetadata<V> {
        private V value;
        private Metadata metadata;

        protected ValueAndMetadata() {
        }

        public void set(V value, Metadata metadata) {
            this.value = value;
            this.metadata = metadata;
        }

        public V getValue() {
            return this.value;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }
    }

    protected static class CacheEntryChange<K, V> {
        private K key;
        private V newValue;
        private V oldValue;
        private Metadata oldMetadata;

        protected CacheEntryChange() {
        }

        public void set(K key, V newValue, V oldValue, Metadata oldMetadata) {
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
            this.oldMetadata = oldMetadata;
        }

        public K getKey() {
            return this.key;
        }

        public V getNewValue() {
            return this.newValue;
        }

        public V getOldValue() {
            return this.oldValue;
        }

        public Metadata getOldMetadata() {
            return this.oldMetadata;
        }
    }

    protected abstract class EntrySetBase<T extends Map.Entry<K, V>>
    extends AbstractSet<T>
    implements CacheSet<T> {
        private final DataContainer<K, V> delegate;

        protected EntrySetBase() {
            this.delegate = SimpleCacheImpl.this.getDataContainer();
        }

        @Override
        public int size() {
            return SimpleCacheImpl.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SimpleCacheImpl.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.get(o) != null;
        }

        @Override
        public Object[] toArray() {
            return StreamSupport.stream(this.delegate.spliterator(), false).toArray();
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean changed = false;
            for (InternalCacheEntry entry : SimpleCacheImpl.this.getDataContainer()) {
                if (c.contains(entry)) continue;
                changed |= SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue());
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean changed = false;
            for (Object o : c) {
                if (!(o instanceof Map.Entry)) continue;
                Map.Entry entry = (Map.Entry)o;
                changed |= SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue());
            }
            return changed;
        }

        @Override
        public void clear() {
            SimpleCacheImpl.this.clear();
        }
    }
}

